/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.launching.VMDefinitionsContainer;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JREsUpdater {
    private VMDefinitionsContainer fOriginalVMs = new VMDefinitionsContainer();
    private Shell fShell;

    public JREsUpdater(Shell shell) {
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def != null) {
            this.fOriginalVMs.setDefaultVMInstallCompositeID(JavaRuntime.getCompositeIdFromVM((IVMInstall)def));
        }
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] vms = types[i].getVMInstalls();
            int j = 0;
            while (j < vms.length) {
                this.fOriginalVMs.addVM(vms[j]);
                ++j;
            }
            ++i;
        }
        this.fShell = shell;
    }

    public boolean updateJRESettings(IVMInstall[] jres, IVMInstall defaultJRE) {
        VMDefinitionsContainer vmContainer = new VMDefinitionsContainer();
        String defaultVMId = JavaRuntime.getCompositeIdFromVM((IVMInstall)defaultJRE);
        vmContainer.setDefaultVMInstallCompositeID(defaultVMId);
        int i = 0;
        while (i < jres.length) {
            vmContainer.addVM(jres[i]);
            ++i;
        }
        boolean buildRequired = false;
        try {
            buildRequired = this.isBuildRequired(this.fOriginalVMs, vmContainer);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        boolean build = false;
        if (buildRequired) {
            MessageDialog messageDialog = new MessageDialog(this.getShell(), JREMessages.getString("JREsPreferencePage.4"), null, JREMessages.getString("JREsPreferencePage.5"), 3, new String[]{JREMessages.getString("JREsPreferencePage.6"), JREMessages.getString("JREsPreferencePage.7"), JREMessages.getString("JREsPreferencePage.8")}, 0);
            int button = messageDialog.open();
            if (button == 2) {
                return false;
            }
            build = button == 0;
        }
        this.saveVMDefinitions(vmContainer);
        if (build) {
            this.buildWorkspace();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isBuildRequired(VMDefinitionsContainer prev, VMDefinitionsContainer curr) throws CoreException {
        String currDef;
        String prevDef = prev.getDefaultVMInstallCompositeID();
        boolean defaultChanged = !this.isEqual(prevDef, currDef = curr.getDefaultVMInstallCompositeID());
        IJavaProject[] projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
        if (defaultChanged) {
            int i = 0;
            while (i < projects.length) {
                IJavaProject project = projects[i];
                IClasspathEntry[] entries = project.getRawClasspath();
                int j = 0;
                while (j < entries.length) {
                    IClasspathEntry entry = entries[j];
                    switch (entry.getEntryKind()) {
                        case 4: {
                            IPath path = entry.getPath();
                            if (path.segmentCount() != 1 || !path.segment(0).equals("JRE_LIB")) break;
                            return true;
                        }
                        case 5: {
                            IPath path = entry.getPath();
                            if (path.segmentCount() != 1 || !path.segment(0).equals(JavaRuntime.JRE_CONTAINER)) break;
                            return true;
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        List futureVMs = curr.getVMList();
        int i = 0;
        while (i < projects.length) {
            IJavaProject project = projects[i];
            IVMInstall prevVM = JavaRuntime.getVMInstall((IJavaProject)project);
            if (prevVM != null) {
                LibraryLocation[] newLibs;
                int index = futureVMs.indexOf(prevVM);
                if (index < 0) return true;
                IVMInstall futureVM = (IVMInstall)futureVMs.get(index);
                LibraryLocation[] prevLibs = JavaRuntime.getLibraryLocations((IVMInstall)prevVM);
                if (prevLibs.length != (newLibs = JavaRuntime.getLibraryLocations((IVMInstall)futureVM)).length) return true;
                int j = 0;
                while (j < newLibs.length) {
                    String prevPath;
                    LibraryLocation newLib = newLibs[j];
                    LibraryLocation prevLib = prevLibs[j];
                    String newPath = newLib.getSystemLibraryPath().toOSString();
                    if (!newPath.equalsIgnoreCase(prevPath = prevLib.getSystemLibraryPath().toOSString())) {
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return a.equals(b);
    }

    private void saveVMDefinitions(final VMDefinitionsContainer container) {
        BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    String vmDefXML = container.getAsXML();
                    JavaRuntime.getPreferences().setValue(JavaRuntime.PREF_VM_XML, vmDefXML);
                    JavaRuntime.savePreferences();
                }
                catch (IOException ioe) {
                    JDIDebugUIPlugin.log(ioe);
                }
                catch (ParserConfigurationException e) {
                    JDIDebugUIPlugin.log(e);
                }
                catch (TransformerException e) {
                    JDIDebugUIPlugin.log(e);
                }
            }
        });
    }

    private Shell getShell() {
        if (this.fShell == null) {
            return JDIDebugUIPlugin.getActiveWorkbenchShell();
        }
        return this.fShell;
    }

    private void buildWorkspace() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.getShell());
        try {
            dialog.run(true, true, (IRunnableWithProgress)new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ResourcesPlugin.getWorkspace().build(6, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), JREMessages.getString("JREsPreferencePage.1"), JREMessages.getString("JREsPreferencePage.9"));
        }
    }
}

