/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.InstalledJREsBlock;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.JREsUpdater;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class JREsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private InstalledJREsBlock fJREBlock;

    public JREsPreferencePage() {
        this.setTitle(JREMessages.getString("JREsPreferencePage.1"));
        this.setDescription(JREMessages.getString("JREsPreferencePage.2"));
    }

    public void init(IWorkbench workbench) {
    }

    private void initDefaultVM() {
        IVMInstall realDefault = JavaRuntime.getDefaultVMInstall();
        if (realDefault != null) {
            IVMInstall[] vms = this.fJREBlock.getJREs();
            int i = 0;
            while (i < vms.length) {
                IVMInstall fakeVM = vms[i];
                if (fakeVM.equals(realDefault)) {
                    this.verifyDefaultVM(fakeVM);
                    break;
                }
                ++i;
            }
        }
    }

    protected Control createContents(Composite ancestor) {
        Font font = ancestor.getFont();
        this.initializeDialogUnits((Control)ancestor);
        this.noDefaultAndApplyButton();
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        parent.setFont(font);
        this.fJREBlock = new InstalledJREsBlock();
        this.fJREBlock.createControl(parent);
        Control control = this.fJREBlock.getControl();
        GridData data = new GridData(1808);
        data.horizontalSpan = 1;
        control.setLayoutData((Object)data);
        this.fJREBlock.restoreColumnSettings(JDIDebugUIPlugin.getDefault().getDialogSettings(), IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        WorkbenchHelp.setHelp((Control)parent, (String)IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        this.initDefaultVM();
        this.fJREBlock.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IVMInstall install = JREsPreferencePage.this.getCurrentDefaultVM();
                if (install == null) {
                    JREsPreferencePage.this.setValid(false);
                    JREsPreferencePage.this.setErrorMessage(JREMessages.getString("JREsPreferencePage.13"));
                } else {
                    JREsPreferencePage.this.setValid(true);
                    JREsPreferencePage.this.setErrorMessage(null);
                }
            }
        });
        return parent;
    }

    public boolean performOk() {
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                IVMInstall defaultVM = JREsPreferencePage.this.getCurrentDefaultVM();
                IVMInstall[] vms = JREsPreferencePage.this.fJREBlock.getJREs();
                JREsUpdater updater = new JREsUpdater(JREsPreferencePage.this.getShell());
                updater.updateJRESettings(vms, defaultVM);
            }
        });
        IDialogSettings settings = JDIDebugUIPlugin.getDefault().getDialogSettings();
        this.fJREBlock.saveColumnSettings(settings, IJavaDebugHelpContextIds.JRE_PREFERENCE_PAGE);
        return super.performOk();
    }

    protected IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
    }

    /*
     * Enabled aggressive block sorting
     */
    private void verifyDefaultVM(IVMInstall vm) {
        if (vm == null) {
            this.fJREBlock.setCheckedJRE(null);
            return;
        }
        LibraryLocation[] locations = JavaRuntime.getLibraryLocations((IVMInstall)vm);
        boolean exist = true;
        int i = 0;
        while (i < locations.length) {
            exist = exist && new File(locations[i].getSystemLibraryPath().toOSString()).exists();
            ++i;
        }
        if (exist) {
            this.fJREBlock.setCheckedJRE(vm);
            return;
        }
        this.fJREBlock.removeJREs(new IVMInstall[]{vm});
        IVMInstall def = JavaRuntime.getDefaultVMInstall();
        if (def == null) {
            this.fJREBlock.setCheckedJRE(null);
        } else {
            this.fJREBlock.setCheckedJRE(def);
        }
        ErrorDialog.openError((Shell)this.getControl().getShell(), (String)JREMessages.getString("JREsPreferencePage.1"), (String)JREMessages.getString("JREsPreferencePage.10"), (IStatus)new Status(4, IJavaDebugUIConstants.PLUGIN_ID, 150, JREMessages.getString("JREsPreferencePage.11"), null));
    }

    private IVMInstall getCurrentDefaultVM() {
        return this.fJREBlock.getCheckedJRE();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setTitle(JREMessages.getString("JREsPreferencePage.12"));
        }
    }
}

