/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.jdt.internal.debug.ui.jres.DefaultJREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.DefineSystemLibraryQuickFix;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class JREsComboBlock
implements ISelectionProvider {
    private Composite fControl;
    private List fVMs = new ArrayList();
    private Combo fCombo;
    private Button fManageButton;
    private ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private DefaultJREDescriptor fDefaultDescriptor = null;
    private Button fDefaultButton = null;
    private Button fSpecificButton = null;
    private String fTitle = null;

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        IVMInstall vm = this.getJRE();
        if (vm == null) {
            return new StructuredSelection();
        }
        return new StructuredSelection((Object)vm);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            if (selection.isEmpty()) {
                this.fCombo.setText("");
                this.fCombo.select(-1);
                this.fCombo.setItems(new String[0]);
                this.fillWithWorkspaceJREs();
            } else {
                Object jre = ((IStructuredSelection)selection).getFirstElement();
                int index = this.fVMs.indexOf(jre);
                if (index >= 0) {
                    this.fCombo.select(index);
                }
            }
            this.fireSelectionChanged();
        }
    }

    public void createControl(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        parent.setLayout((Layout)layout);
        Font font = ancestor.getFont();
        parent.setFont(font);
        this.fControl = parent;
        if (this.fTitle == null) {
            this.fTitle = JREMessages.getString("JREsComboBlock.3");
        }
        Label label = new Label(parent, 0);
        label.setFont(font);
        label.setText(this.fTitle);
        GridData data = new GridData(1);
        data.horizontalSpan = 3;
        label.setLayoutData((Object)data);
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton = new Button(parent, 16);
            this.fDefaultButton.setText(this.fDefaultDescriptor.getDescription());
            this.fDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (JREsComboBlock.this.fDefaultButton.getSelection()) {
                        JREsComboBlock.this.setUseDefaultJRE();
                    }
                }
            });
            data = new GridData();
            data.horizontalSpan = 3;
            this.fDefaultButton.setLayoutData((Object)data);
            this.fDefaultButton.setFont(font);
        }
        this.fSpecificButton = new Button(parent, 16);
        this.fSpecificButton.setText(JREMessages.getString("JREsComboBlock.1"));
        this.fSpecificButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (JREsComboBlock.this.fSpecificButton.getSelection()) {
                    JREsComboBlock.this.fCombo.setEnabled(true);
                    JREsComboBlock.this.fManageButton.setEnabled(true);
                    JREsComboBlock.this.fireSelectionChanged();
                }
            }
        });
        this.fSpecificButton.setFont(font);
        data = new GridData(1);
        this.fSpecificButton.setLayoutData((Object)data);
        this.fCombo = new Combo(parent, 12);
        this.fCombo.setFont(font);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.fCombo.setLayoutData((Object)data);
        this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JREsComboBlock.this.setJRE(JREsComboBlock.this.getJRE());
            }
        });
        this.fManageButton = this.createPushButton(parent, JREMessages.getString("JREsComboBlock.2"));
        this.fManageButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                IVMInstall oldSelection = JREsComboBlock.this.getJRE();
                int oldIndex = -1;
                if (oldSelection != null) {
                    oldIndex = JREsComboBlock.this.fVMs.indexOf(oldSelection);
                }
                DefineSystemLibraryQuickFix fix = new DefineSystemLibraryQuickFix();
                fix.run(null);
                JREsComboBlock.this.fillWithWorkspaceJREs();
                int newIndex = -1;
                if (oldSelection != null) {
                    newIndex = JREsComboBlock.this.fVMs.indexOf(oldSelection);
                }
                if (newIndex != oldIndex) {
                    JREsComboBlock.this.fPrevSelection = null;
                }
                JREsComboBlock.this.setDefaultJREDescriptor(JREsComboBlock.this.fDefaultDescriptor);
                if (JREsComboBlock.this.isDefaultJRE()) {
                    JREsComboBlock.this.setUseDefaultJRE();
                } else {
                    if (newIndex >= 0) {
                        JREsComboBlock.this.fCombo.select(newIndex);
                    } else {
                        JREsComboBlock.this.fCombo.select(0);
                    }
                    JREsComboBlock.this.setJRE(JREsComboBlock.this.getJRE());
                }
            }
        });
        this.fillWithWorkspaceJREs();
    }

    private void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] listeners = this.fSelectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
            listener.selectionChanged(event);
            ++i;
        }
    }

    protected Button createPushButton(Composite parent, String label) {
        return SWTUtil.createPushButton((Composite)parent, (String)label, null);
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setJREs(List jres) {
        this.fVMs.clear();
        this.fVMs.addAll(jres);
        Collections.sort(this.fVMs, new Comparator(){

            public int compare(Object o1, Object o2) {
                IVMInstall left = (IVMInstall)o1;
                IVMInstall right = (IVMInstall)o2;
                return left.getName().compareToIgnoreCase(right.getName());
            }

            public boolean equals(Object obj) {
                return obj == this;
            }
        });
        String[] names = new String[this.fVMs.size()];
        Iterator iter = this.fVMs.iterator();
        int i = 0;
        while (iter.hasNext()) {
            IVMInstall vm = (IVMInstall)iter.next();
            names[i] = vm.getName();
            ++i;
        }
        this.fCombo.setItems(names);
    }

    public IVMInstall[] getJREs() {
        return this.fVMs.toArray(new IVMInstall[this.fVMs.size()]);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    public void setJRE(IVMInstall vm) {
        this.fSpecificButton.setSelection(true);
        this.fDefaultButton.setSelection(false);
        this.fCombo.setEnabled(true);
        this.fManageButton.setEnabled(true);
        if (vm == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)vm));
        }
    }

    public IVMInstall getJRE() {
        int index = this.fCombo.getSelectionIndex();
        if (index >= 0) {
            return (IVMInstall)this.fVMs.get(index);
        }
        return null;
    }

    protected void fillWithWorkspaceJREs() {
        ArrayList<VMStandin> standins = new ArrayList<VMStandin>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                standins.add(new VMStandin(install));
                ++j;
            }
            ++i;
        }
        this.setJREs(standins);
    }

    public void setDefaultJREDescriptor(DefaultJREDescriptor descriptor) {
        this.fDefaultDescriptor = descriptor;
        if (this.fDefaultButton != null) {
            String currentText = this.fDefaultButton.getText();
            String newText = descriptor.getDescription();
            if (!newText.equals(currentText)) {
                this.fDefaultButton.setText(newText);
                this.fControl.layout();
            }
        }
    }

    public boolean isDefaultJRE() {
        if (this.fDefaultButton != null) {
            return this.fDefaultButton.getSelection();
        }
        return false;
    }

    public void setUseDefaultJRE() {
        if (this.fDefaultDescriptor != null) {
            this.fDefaultButton.setSelection(true);
            this.fSpecificButton.setSelection(false);
            this.fCombo.setEnabled(false);
            this.fManageButton.setEnabled(false);
            this.fPrevSelection = null;
            this.fireSelectionChanged();
        }
    }

    public void setTitle(String title) {
        this.fTitle = title;
    }

    public void refresh() {
        this.setDefaultJREDescriptor(this.fDefaultDescriptor);
    }
}

