/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.jres;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.IAddVMDialogRequestor;
import org.eclipse.jdt.internal.debug.ui.jres.JREMessages;
import org.eclipse.jdt.internal.debug.ui.jres.VMLibraryBlock;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.launching.AbstractVMInstallType;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.VMStandin;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddVMDialog
extends StatusDialog {
    private IAddVMDialogRequestor fRequestor;
    private IVMInstall fEditedVM;
    private IVMInstallType[] fVMTypes;
    private IVMInstallType fSelectedVMType;
    private ComboDialogField fVMTypeCombo;
    private VMLibraryBlock fLibraryBlock;
    private StringButtonDialogField fJRERoot;
    private StringDialogField fVMName;
    private StringButtonDialogField fJavadocURL;
    private boolean fAutoDetectJavadocLocation = false;
    private IStatus[] fStati;
    private int fPrevIndex = -1;

    public AddVMDialog(IAddVMDialogRequestor requestor, Shell shell, IVMInstallType[] vmInstallTypes, IVMInstall editedVM) {
        super(shell);
        this.fRequestor = requestor;
        this.fStati = new IStatus[5];
        int i = 0;
        while (i < this.fStati.length) {
            this.fStati[i] = new StatusInfo();
            ++i;
        }
        this.fVMTypes = vmInstallTypes;
        this.fSelectedVMType = editedVM != null ? editedVM.getVMInstallType() : vmInstallTypes[0];
        this.fEditedVM = editedVM;
        this.fAutoDetectJavadocLocation = this.fEditedVM == null || this.fEditedVM.getJavadocLocation() == null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)IJavaDebugHelpContextIds.EDIT_JRE_DIALOG);
    }

    protected void createDialogFields() {
        this.fVMTypeCombo = new ComboDialogField(8);
        this.fVMTypeCombo.setLabelText(JREMessages.getString("addVMDialog.jreType"));
        this.fVMTypeCombo.setItems(this.getVMTypeNames());
        this.fVMName = new StringDialogField();
        this.fVMName.setLabelText(JREMessages.getString("addVMDialog.jreName"));
        this.fJRERoot = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddVMDialog.this.browseForInstallDir();
            }
        });
        this.fJRERoot.setLabelText(JREMessages.getString("addVMDialog.jreHome"));
        this.fJRERoot.setButtonLabel(JREMessages.getString("addVMDialog.browse1"));
        this.fJavadocURL = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                AddVMDialog.this.browseForJavadocURL();
            }
        });
        this.fJavadocURL.setLabelText(JREMessages.getString("AddVMDialog.Java&doc_URL__1"));
        this.fJavadocURL.setButtonLabel(JREMessages.getString("AddVMDialog.Bro&wse..._2"));
    }

    protected void createFieldListeners() {
        this.fVMTypeCombo.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.updateVMType();
            }
        });
        this.fVMName.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setVMNameStatus(AddVMDialog.this.validateVMName());
                AddVMDialog.this.updateStatusLine();
            }
        });
        this.fJRERoot.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setJRELocationStatus(AddVMDialog.this.validateJRELocation());
                AddVMDialog.this.updateStatusLine();
            }
        });
        this.fJavadocURL.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                AddVMDialog.this.setJavadocURLStatus(AddVMDialog.this.validateJavadocURL());
                AddVMDialog.this.updateStatusLine();
            }
        });
    }

    protected String getVMName() {
        return this.fVMName.getText();
    }

    protected File getInstallLocation() {
        return new File(this.fJRERoot.getText());
    }

    protected Control createDialogArea(Composite ancestor) {
        Font font = ancestor.getFont();
        this.createDialogFields();
        Composite parent = (Composite)super.createDialogArea(ancestor);
        ((GridLayout)parent.getLayout()).numColumns = 3;
        this.fVMTypeCombo.doFillIntoGrid(parent, 3);
        ((GridData)this.fVMTypeCombo.getComboControl(null).getLayoutData()).widthHint = this.convertWidthInCharsToPixels(50);
        this.fVMName.doFillIntoGrid(parent, 3);
        this.fJRERoot.doFillIntoGrid(parent, 3);
        this.fJavadocURL.doFillIntoGrid(parent, 3);
        Label l = new Label(parent, 0);
        l.setText(JREMessages.getString("AddVMDialog.JRE_system_libraries__1"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        l.setLayoutData((Object)gd);
        l.setFont(font);
        this.fLibraryBlock = new VMLibraryBlock(this);
        Control block = this.fLibraryBlock.createControl(parent);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        block.setLayoutData((Object)gd);
        Text t = this.fJRERoot.getTextControl(parent);
        gd = (GridData)t.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        t = this.fJavadocURL.getTextControl(parent);
        gd = (GridData)t.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = this.convertWidthInCharsToPixels(50);
        this.initializeFields();
        this.createFieldListeners();
        return parent;
    }

    private void updateVMType() {
        int selIndex = this.fVMTypeCombo.getSelectionIndex();
        if (selIndex == this.fPrevIndex) {
            return;
        }
        this.fPrevIndex = selIndex;
        if (selIndex >= 0 && selIndex < this.fVMTypes.length) {
            this.fSelectedVMType = this.fVMTypes[selIndex];
        }
        this.setJRELocationStatus(this.validateJRELocation());
        this.fLibraryBlock.initializeFrom(this.fEditedVM, this.fSelectedVMType);
        this.updateStatusLine();
    }

    public void create() {
        super.create();
        this.fVMName.setFocus();
        this.selectVMType();
    }

    private String[] getVMTypeNames() {
        String[] names = new String[this.fVMTypes.length];
        int i = 0;
        while (i < this.fVMTypes.length) {
            names[i] = this.fVMTypes[i].getName();
            ++i;
        }
        return names;
    }

    private void selectVMType() {
        int i = 0;
        while (i < this.fVMTypes.length) {
            if (this.fSelectedVMType == this.fVMTypes[i]) {
                this.fVMTypeCombo.selectItem(i);
                return;
            }
            ++i;
        }
    }

    private void initializeFields() {
        this.fVMTypeCombo.setItems(this.getVMTypeNames());
        if (this.fEditedVM == null) {
            this.fVMName.setText("");
            this.fJRERoot.setText("");
            this.fJavadocURL.setText("");
            this.fLibraryBlock.initializeFrom(null, this.fSelectedVMType);
        } else {
            this.fVMTypeCombo.setEnabled(false);
            this.fVMName.setText(this.fEditedVM.getName());
            this.fJRERoot.setText(this.fEditedVM.getInstallLocation().getAbsolutePath());
            URL url = this.fEditedVM.getJavadocLocation();
            if (url == null) {
                this.fJavadocURL.setText("");
            } else {
                this.fJavadocURL.setText(url.toExternalForm());
            }
        }
        this.setVMNameStatus(this.validateVMName());
        this.updateStatusLine();
    }

    private IVMInstallType getVMType() {
        return this.fSelectedVMType;
    }

    private IStatus validateJRELocation() {
        String locationName = this.fJRERoot.getText();
        StatusInfo s = null;
        File file = null;
        if (locationName.length() == 0) {
            s = new StatusInfo(1, JREMessages.getString("addVMDialog.enterLocation"));
        } else {
            file = new File(locationName);
            if (!file.exists()) {
                s = new StatusInfo(4, JREMessages.getString("addVMDialog.locationNotExists"));
            } else {
                final IStatus[] temp = new IStatus[1];
                final File tempFile = file;
                Runnable r = new Runnable(){

                    public void run() {
                        temp[0] = AddVMDialog.this.getVMType().validateInstallLocation(tempFile);
                    }
                };
                BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)r);
                s = temp[0];
            }
        }
        if (s.isOK()) {
            this.fLibraryBlock.setHomeDirectory(file);
        } else {
            this.fLibraryBlock.setHomeDirectory(null);
        }
        this.fLibraryBlock.update();
        this.detectJavadocLocation();
        return s;
    }

    private IStatus validateJavadocURL() {
        String text = this.fJavadocURL.getText();
        if (text != null && text.length() > 0) {
            try {
                new URL(text);
            }
            catch (MalformedURLException e) {
                return new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, JREMessages.getString("AddVMDialog.Invalid_URL_syntax_specified_for_Javadoc_location._1"), (Throwable)e);
            }
        }
        return new StatusInfo();
    }

    private void detectJavadocLocation() {
        if (this.fAutoDetectJavadocLocation && this.getVMType() instanceof AbstractVMInstallType) {
            AbstractVMInstallType type = (AbstractVMInstallType)this.getVMType();
            URL url = type.getDefaultJavadocLocation(this.getInstallLocation());
            if (url == null) {
                this.fJavadocURL.setText("");
            } else {
                this.fJavadocURL.setText(url.toExternalForm());
            }
        }
    }

    private IStatus validateVMName() {
        StatusInfo status = new StatusInfo();
        String name = this.fVMName.getText();
        if (name == null || name.trim().length() == 0) {
            status.setInfo(JREMessages.getString("addVMDialog.enterName"));
        } else if (this.fRequestor.isDuplicateName(name) && (this.fEditedVM == null || !name.equals(this.fEditedVM.getName()))) {
            status.setError(JREMessages.getString("addVMDialog.duplicateName"));
        } else {
            IStatus s = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (!s.isOK()) {
                status.setError(MessageFormat.format(JREMessages.getString("AddVMDialog.JRE_name_must_be_a_valid_file_name__{0}_1"), s.getMessage()));
            }
        }
        return status;
    }

    protected void updateStatusLine() {
        IStatus max = null;
        int i = 0;
        while (i < this.fStati.length) {
            IStatus curr = this.fStati[i];
            if (curr.matches(4)) {
                this.updateStatus(curr);
                return;
            }
            if (max == null || curr.getSeverity() > max.getSeverity()) {
                max = curr;
            }
            ++i;
        }
        this.updateStatus(max);
    }

    private void browseForInstallDir() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        dialog.setFilterPath(this.fJRERoot.getText());
        dialog.setMessage(JREMessages.getString("addVMDialog.pickJRERootDialog.message"));
        String newPath = dialog.open();
        if (newPath != null) {
            this.fJRERoot.setText(newPath);
        }
    }

    private void browseForJavadocURL() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        String initPath = "";
        URL url = this.getURL();
        if (url != null && "file".equals(url.getProtocol())) {
            initPath = new File(url.getFile()).getPath();
        }
        dialog.setFilterPath(initPath);
        dialog.setMessage(JREMessages.getString("AddVMDialog.Select_Javadoc_location__3"));
        String res = dialog.open();
        if (res != null) {
            try {
                url = new File(res).toURL();
                this.fJavadocURL.setText(url.toExternalForm());
            }
            catch (MalformedURLException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
    }

    protected URL getURL() {
        try {
            return new URL(this.fJavadocURL.getText());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    protected void okPressed() {
        this.doOkPressed();
        super.okPressed();
    }

    private void doOkPressed() {
        if (this.fEditedVM == null) {
            VMStandin vm = new VMStandin(this.fSelectedVMType, this.createUniqueId(this.fSelectedVMType));
            this.setFieldValuesToVM((IVMInstall)vm);
            this.fRequestor.vmAdded((IVMInstall)vm);
        } else {
            this.setFieldValuesToVM(this.fEditedVM);
        }
    }

    private String createUniqueId(IVMInstallType vmType) {
        String id = null;
        while (vmType.findVMInstall(id = String.valueOf(System.currentTimeMillis())) != null) {
        }
        return id;
    }

    protected void setFieldValuesToVM(IVMInstall vm) {
        vm.setInstallLocation(new File(this.fJRERoot.getText()).getAbsoluteFile());
        vm.setName(this.fVMName.getText());
        vm.setJavadocLocation(this.getURL());
        this.fLibraryBlock.performApply(vm);
    }

    protected File getAbsoluteFileOrEmpty(String path) {
        if (path == null || path.length() == 0) {
            return new File("");
        }
        return new File(path).getAbsoluteFile();
    }

    private void setVMNameStatus(IStatus status) {
        this.fStati[0] = status;
    }

    private void setJRELocationStatus(IStatus status) {
        this.fStati[1] = status;
    }

    private void setJavadocURLStatus(IStatus status) {
        this.fStati[2] = status;
    }

    protected IStatus getSystemLibraryStatus() {
        return this.fStati[3];
    }

    protected void setSystemLibraryStatus(IStatus status) {
        this.fStati[3] = status;
    }

    protected void updateButtonsEnableState(IStatus status) {
        Button ok = this.getButton(0);
        if (ok != null && !ok.isDisposed()) {
            ok.setEnabled(status.getSeverity() == 0);
        }
    }

    protected void setButtonLayoutData(Button button) {
        super.setButtonLayoutData(button);
    }
}

