/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.display;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.display.ClearDisplayAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayMessages;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewAction;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class DisplayView
extends ViewPart
implements ITextInputListener {
    protected IDataDisplay fDataDisplay = new DataDisplay();
    protected IDocumentListener fDocumentListener = null;
    protected JDISourceViewer fSourceViewer;
    protected IAction fClearDisplayAction;
    protected DisplayViewAction fContentAssistAction;
    protected Map fGlobalActions = new HashMap(4);
    protected List fSelectionActions = new ArrayList(3);
    protected String fRestoredContents = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void createPartControl(Composite parent) {
        int styles = 66306;
        this.fSourceViewer = new JDISourceViewer(parent, null, styles);
        this.fSourceViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration());
        this.fSourceViewer.getSelectionProvider().addSelectionChangedListener(this.getSelectionChangedListener());
        IDocument doc = this.getRestoredDocument();
        this.fSourceViewer.setDocument(doc);
        this.fSourceViewer.addTextInputListener(this);
        this.fRestoredContents = null;
        this.createActions();
        this.initializeToolBar();
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DisplayView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fSourceViewer.getTextWidget());
        this.fSourceViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, this.fSourceViewer.getSelectionProvider());
        this.getSite().setSelectionProvider(this.fSourceViewer.getSelectionProvider());
        WorkbenchHelp.setHelp((Control)this.fSourceViewer.getTextWidget(), (String)IJavaDebugHelpContextIds.DISPLAY_VIEW);
    }

    protected IDocument getRestoredDocument() {
        Document doc = null;
        doc = this.fRestoredContents != null ? new Document(this.fRestoredContents) : new Document();
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        partitioner.connect((IDocument)doc);
        doc.setDocumentPartitioner(partitioner);
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DisplayView.this.updateAction(ActionFactory.FIND.getId());
            }
        };
        doc.addDocumentListener(this.fDocumentListener);
        return doc;
    }

    public void setFocus() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.getControl().setFocus();
        }
    }

    protected void createActions() {
        this.fClearDisplayAction = new ClearDisplayAction((IWorkbenchPart)this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        DisplayViewAction action = new DisplayViewAction((IAdaptable)this, 3);
        action.setText(DisplayMessages.getString("DisplayView.Cut.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.Cut.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.Cut.description"));
        this.setGlobalAction(actionBars, ActionFactory.CUT.getId(), (IAction)action);
        action = new DisplayViewAction((IAdaptable)this, 4);
        action.setText(DisplayMessages.getString("DisplayView.Copy.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.Copy.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.Copy.description"));
        this.setGlobalAction(actionBars, ActionFactory.COPY.getId(), (IAction)action);
        action = new DisplayViewAction((IAdaptable)this, 5);
        action.setText(DisplayMessages.getString("DisplayView.Paste.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.Paste.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.Paste.Description"));
        this.setGlobalAction(actionBars, ActionFactory.PASTE.getId(), (IAction)action);
        action = new DisplayViewAction((IAdaptable)this, 7);
        action.setText(DisplayMessages.getString("DisplayView.SelectAll.label"));
        action.setToolTipText(DisplayMessages.getString("DisplayView.SelectAll.tooltip"));
        action.setDescription(DisplayMessages.getString("DisplayView.SelectAll.description"));
        this.setGlobalAction(actionBars, ActionFactory.SELECT_ALL.getId(), (IAction)action);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.jdt.internal.debug.ui.display.DisplayMessages");
        this.setGlobalAction(actionBars, ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(bundle, "find_replace_action.", (IWorkbenchPart)this));
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.fContentAssistAction = new DisplayViewAction((IAdaptable)this, 13);
        this.fContentAssistAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fContentAssistAction.setText(DisplayMessages.getString("DisplayView.Co&ntent_Assist@Ctrl+Space_1"));
        this.fContentAssistAction.setDescription(DisplayMessages.getString("DisplayView.Content_Assist_2"));
        this.fContentAssistAction.setToolTipText(DisplayMessages.getString("DisplayView.Content_Assist_2"));
        this.fContentAssistAction.setImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_ELCL_CONTENT_ASSIST"));
        this.fContentAssistAction.setHoverImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_LCL_CONTENT_ASSIST"));
        this.fContentAssistAction.setDisabledImageDescriptor(DebugUITools.getImageDescriptor((String)"IMG_DLCL_CONTENT_ASSIST"));
        actionBars.updateActionBars();
        this.addVerifyKeyListener();
        this.getSite().getKeyBindingService().registerAction((IAction)this.fContentAssistAction);
    }

    protected void addVerifyKeyListener() {
        this.fSourceViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 0 && event.character == ' ' && DisplayView.this.fContentAssistAction.isEnabled()) {
                    DisplayView.this.fContentAssistAction.run();
                    event.doit = false;
                }
            }
        });
    }

    protected void setGlobalAction(IActionBars actionBars, String actionID, IAction action) {
        this.fGlobalActions.put(actionID, action);
        actionBars.setGlobalActionHandler(actionID, action);
    }

    protected void initializeToolBar() {
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        tbm.add((IContributionItem)new Separator("evaluationGroup"));
        tbm.add(this.fClearDisplayAction);
        this.getViewSite().getActionBars().updateActionBars();
    }

    protected void fillContextMenu(IMenuManager menu) {
        if (this.fSourceViewer.getDocument() == null) {
            return;
        }
        menu.add((IContributionItem)new Separator("evaluationGroup"));
        if (DebugUITools.getDebugContext() != null) {
            menu.add((IAction)this.fContentAssistAction);
        }
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.CUT.getId()));
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.COPY.getId()));
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.PASTE.getId()));
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.SELECT_ALL.getId()));
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.fGlobalActions.get(ActionFactory.FIND.getId()));
        menu.add(this.fClearDisplayAction);
        menu.add((IContributionItem)new Separator("additions"));
    }

    public Object getAdapter(Class required) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jface.text.ITextOperationTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.fSourceViewer.getTextOperationTarget();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.jface.text.IFindReplaceTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.fSourceViewer.getFindReplaceTarget();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.jdt.internal.debug.ui.display.IDataDisplay;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required)) {
            return this.fDataDisplay;
        }
        return super.getAdapter(required);
    }

    protected void updateActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            IAction action = (IAction)this.fGlobalActions.get(iterator.next());
            if (!(action instanceof IUpdate)) continue;
            ((IUpdate)action).update();
        }
    }

    public void saveState(IMemento memento) {
        if (this.fSourceViewer != null) {
            IDocument doc = this.fSourceViewer.getDocument();
            String contents = doc.get().trim();
            memento.putTextData(contents);
        } else if (this.fRestoredContents != null) {
            memento.putTextData(this.fRestoredContents);
        }
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            this.fRestoredContents = memento.getTextData();
        }
    }

    protected String getContents() {
        return this.fSourceViewer.getDocument().get();
    }

    protected final ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DisplayView.this.updateSelectionDependentActions();
            }
        };
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = (IAction)this.fGlobalActions.get(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        oldInput.removeDocumentListener(this.fDocumentListener);
    }

    public void dispose() {
        if (this.fSourceViewer != null) {
            this.fSourceViewer.dispose();
        }
        super.dispose();
    }

    class DataDisplay
    implements IDataDisplay {
        DataDisplay() {
        }

        public void clear() {
            IDocument document = DisplayView.this.fSourceViewer.getDocument();
            if (document != null) {
                document.set("");
            }
        }

        public void displayExpression(String expression) {
            IDocument document = DisplayView.this.fSourceViewer.getDocument();
            int offset = document.getLength();
            try {
                if (offset != document.getLineInformationOfOffset(offset).getOffset()) {
                    expression = String.valueOf(System.getProperty("line.separator")) + expression.trim();
                }
                DisplayView.this.fSourceViewer.getDocument().replace(offset, 0, expression);
                DisplayView.this.fSourceViewer.setSelectedRange(offset + expression.length(), 0);
                DisplayView.this.fSourceViewer.revealRange(offset, expression.length());
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
        }

        public void displayExpressionValue(String value) {
            value = String.valueOf(System.getProperty("line.separator")) + '\t' + value;
            ITextSelection selection = (ITextSelection)DisplayView.this.fSourceViewer.getSelection();
            int offset = selection.getOffset() + selection.getLength();
            int length = value.length();
            try {
                DisplayView.this.fSourceViewer.getDocument().replace(offset, 0, value);
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
            DisplayView.this.fSourceViewer.setSelectedRange(offset + length, 0);
            DisplayView.this.fSourceViewer.revealRange(offset, length);
        }
    }
}

