/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICodeAssist;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.StepIntoSelectionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class StepIntoSelectionActionDelegate
implements IEditorActionDelegate,
IWorkbenchWindowActionDelegate {
    private IEditorPart fEditorPart = null;
    private IWorkbenchWindow fWindow = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void run(IAction action) {
        if (this.getActiveEditor() != null) {
            ITextSelection textSelection;
            ICodeAssist codeAssist;
            block19: {
                codeAssist = null;
                textSelection = null;
                IJavaStackFrame frame = this.getStackFrame();
                if (frame != null && frame.isSuspended()) {
                    IEditorPart part = this.getActiveEditor();
                    if (part instanceof ITextEditor) {
                        ITextEditor editor = (ITextEditor)part;
                        textSelection = (ITextSelection)editor.getSelectionProvider().getSelection();
                        try {
                            if (frame.getThread().getTopStackFrame().equals(frame)) {
                                int lineNumber = frame.getLineNumber();
                                if (textSelection.getStartLine() == lineNumber - 1) {
                                    IEditorInput input = this.getActiveEditor().getEditorInput();
                                    Object element = JavaUI.getWorkingCopyManager().getWorkingCopy(input);
                                    if (element == null) {
                                        Class<?> clazz = class$0;
                                        if (clazz == null) {
                                            try {
                                                clazz = class$0 = Class.forName("[Lorg.eclipse.jdt.core.IClassFile;").getComponentType();
                                            }
                                            catch (ClassNotFoundException classNotFoundException) {
                                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                            }
                                        }
                                        element = input.getAdapter((Class)clazz);
                                    }
                                    if (element instanceof ICodeAssist) {
                                        codeAssist = (ICodeAssist)element;
                                        break block19;
                                    }
                                    this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_for_types_in_Java_projects._1"));
                                    return;
                                }
                                this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_on_current_line_of_execution._2"));
                                return;
                            }
                            this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_in_top_stack_frame._3"));
                            return;
                        }
                        catch (CoreException e) {
                            this.showErrorMessage(e.getStatus().getMessage());
                            return;
                        }
                    }
                    this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.Step_into_selection_only_available_in_Java_editor._4"));
                    return;
                }
                return;
            }
            IMethod method = null;
            try {
                IJavaElement[] resolve = codeAssist.codeSelect(textSelection.getOffset(), textSelection.getLength());
                int i = 0;
                while (i < resolve.length) {
                    IJavaElement javaElement = resolve[i];
                    if (javaElement instanceof IMethod) {
                        method = (IMethod)javaElement;
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                JDIDebugPlugin.log((Throwable)e);
            }
            if (method == null) {
                this.showErrorMessage(ActionMessages.getString("StepIntoSelectionActionDelegate.No_Method"));
            } else {
                StepIntoSelectionHandler handler = new StepIntoSelectionHandler((IJavaThread)this.getStackFrame().getThread(), this.getStackFrame(), method);
                handler.step();
            }
        }
    }

    protected void showErrorMessage(String message) {
        if (this.getActiveEditor() != null) {
            IEditorStatusLine statusLine;
            IEditorPart iEditorPart = this.getActiveEditor();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.ui.texteditor.IEditorStatusLine;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((statusLine = (IEditorStatusLine)iEditorPart.getAdapter((Class)clazz)) != null) {
                statusLine.setMessage(true, message, null);
            }
        }
        JDIDebugUIPlugin.getStandardDisplay().beep();
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.fEditorPart = targetEditor;
    }

    protected IEditorPart getActiveEditor() {
        if (this.fWindow != null) {
            return this.fWindow.getActivePage().getActiveEditor();
        }
        return this.fEditorPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    protected IJavaStackFrame getStackFrame() {
        return EvaluationContextManager.getEvaluationContext((IWorkbenchPart)this.getActiveEditor());
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }
}

