/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.PrimitiveOptionsAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class PrimitiveOptionsDialog
extends Dialog {
    private Button fHexButton;
    private Button fCharButton;
    private Button fUnsignedButton;
    private String fPrefix;

    public PrimitiveOptionsDialog(Shell parentShell, String prefix) {
        super(parentShell);
        this.fPrefix = prefix;
    }

    protected Control createDialogArea(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)IJavaDebugHelpContextIds.PRIMITIVE_DISPLAY_OPTIONS_DIALOG);
        this.getShell().setText(ActionMessages.getString("PrimitiveOptionsDialog.Primitive_Type_Display_Options_1"));
        Composite composite = (Composite)super.createDialogArea(parent);
        this.fHexButton = new Button(composite, 32);
        this.fHexButton.setText(DebugUIMessages.getString("JavaDebugPreferencePage.Display_&hexadecimal_values_(byte,_short,_char,_int,_long)_3"));
        this.fHexButton.setSelection(PrimitiveOptionsAction.getPreferenceValue(this.fPrefix, IJDIPreferencesConstants.PREF_SHOW_HEX));
        this.fCharButton = new Button(composite, 32);
        this.fCharButton.setText(DebugUIMessages.getString("JavaDebugPreferencePage.Display_ASCII_&character_values_(byte,_short,_int,_long)_4"));
        this.fCharButton.setSelection(PrimitiveOptionsAction.getPreferenceValue(this.fPrefix, IJDIPreferencesConstants.PREF_SHOW_CHAR));
        this.fUnsignedButton = new Button(composite, 32);
        this.fUnsignedButton.setText(DebugUIMessages.getString("JavaDebugPreferencePage.Display_&unsigned_values_(byte)_5"));
        this.fUnsignedButton.setSelection(PrimitiveOptionsAction.getPreferenceValue(this.fPrefix, IJDIPreferencesConstants.PREF_SHOW_UNSIGNED));
        return composite;
    }

    protected void okPressed() {
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        store.setValue(String.valueOf(this.fPrefix) + "." + IJDIPreferencesConstants.PREF_SHOW_HEX, this.fHexButton.getSelection());
        store.setValue(String.valueOf(this.fPrefix) + "." + IJDIPreferencesConstants.PREF_SHOW_CHAR, this.fCharButton.getSelection());
        store.setValue(String.valueOf(this.fPrefix) + "." + IJDIPreferencesConstants.PREF_SHOW_UNSIGNED, this.fUnsignedButton.getSelection());
        super.okPressed();
    }
}

