/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenReceivingTypeAction;
import org.eclipse.jdt.internal.ui.util.OpenTypeHierarchyUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class OpenReceivingTypeHierarchyAction
extends OpenReceivingTypeAction {
    protected IWorkbenchPart fTargetPart;

    protected void doAction(Object e) throws DebugException {
        IAdaptable element = (IAdaptable)e;
        IDebugElement dbgElement = this.getDebugElement(element);
        if (dbgElement != null) {
            String typeName = this.getTypeNameToOpen(dbgElement);
            try {
                IType t = this.findTypeInWorkspace(typeName);
                if (t != null) {
                    OpenTypeHierarchyUtil.open((IJavaElement)t, (IWorkbenchWindow)this.fTargetPart.getSite().getWorkbenchWindow());
                }
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x);
            }
        }
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.fTargetPart = targetPart;
    }
}

