/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AbstractManageBreakpointActionDelegate;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointMethodLocator;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class ManageMethodBreakpointActionDelegate
extends AbstractManageBreakpointActionDelegate {
    protected IJavaBreakpoint getBreakpoint(IMember element) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
            IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof IJavaMethodBreakpoint) {
                    IJavaMethodBreakpoint methodBreakpoint = (IJavaMethodBreakpoint)breakpoint;
                    IMember container = null;
                    try {
                        container = BreakpointUtils.getMember((IJavaLineBreakpoint)methodBreakpoint);
                    }
                    catch (CoreException e) {
                        JDIDebugUIPlugin.log(e);
                        return null;
                    }
                    if (container == null) {
                        try {
                            if (method.getDeclaringType().getFullyQualifiedName().equals(methodBreakpoint.getTypeName()) && method.getElementName().equals(methodBreakpoint.getMethodName()) && method.getSignature().equals(methodBreakpoint.getMethodSignature())) {
                                return methodBreakpoint;
                            }
                        }
                        catch (CoreException e) {
                            JDIDebugUIPlugin.log(e);
                        }
                    } else if (container instanceof IMethod && method.getDeclaringType().getFullyQualifiedName().equals(container.getDeclaringType().getFullyQualifiedName()) && method.isSimilar((IMethod)container)) {
                        return methodBreakpoint;
                    }
                }
                ++i;
            }
        }
        return null;
    }

    protected IMember[] getMembers(ISelection s) {
        if (s instanceof IStructuredSelection) {
            ArrayList members = new ArrayList();
            Iterator iter = ((IStructuredSelection)s).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!(o instanceof IMethod)) continue;
                members.add(o);
            }
            return members.toArray(new IMember[0]);
        }
        return null;
    }

    public void run(IAction action) {
        block18: {
            this.updateForRun();
            this.report(null);
            try {
                IMember[] members = this.getMembers();
                if (members == null || members.length == 0) {
                    ISelection selection;
                    IWorkbenchPage page = this.getPage();
                    if (page != null && (selection = page.getSelection()) instanceof ITextSelection) {
                        IEditorInput editorInput = this.getTextEditor().getEditorInput();
                        Object resource = editorInput instanceof IFileEditorInput ? ((IFileEditorInput)editorInput).getFile() : ResourcesPlugin.getWorkspace().getRoot();
                        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)editorInput);
                        CompilationUnit compilationUnit = AST.parseCompilationUnit((char[])document.get().toCharArray());
                        BreakpointMethodLocator locator = new BreakpointMethodLocator(((ITextSelection)selection).getOffset());
                        compilationUnit.accept((ASTVisitor)locator);
                        String methodName = locator.getMethodName();
                        if (methodName == null) {
                            this.report(ActionMessages.getString("ManageMethodBreakpointActionDelegate.CantAdd"));
                            return;
                        }
                        String typeName = locator.getTypeName();
                        String methodSignature = locator.getMethodSignature();
                        if (methodSignature == null) {
                            this.report(ActionMessages.getString("ManageMethodBreakpointActionDelegate.methodNonAvailable"));
                            return;
                        }
                        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
                        int i = 0;
                        while (i < breakpoints.length) {
                            IJavaMethodBreakpoint methodBreakpoint;
                            IBreakpoint breakpoint = breakpoints[i];
                            if (breakpoint instanceof IJavaMethodBreakpoint && typeName.equals((methodBreakpoint = (IJavaMethodBreakpoint)breakpoint).getTypeName()) && methodName.equals(methodBreakpoint.getMethodName()) && methodSignature.equals(methodBreakpoint.getMethodSignature())) {
                                breakpointManager.removeBreakpoint((IBreakpoint)methodBreakpoint, true);
                                return;
                            }
                            ++i;
                        }
                        JDIDebugModel.createMethodBreakpoint((IResource)resource, (String)typeName, (String)methodName, (String)methodSignature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)-1, (int)-1, (int)0, (boolean)true, new HashMap(10));
                    }
                    break block18;
                }
                int i = 0;
                int length = members.length;
                while (i < length) {
                    if (!this.enableForMember(members[i])) {
                        this.report(ActionMessages.getString("ManageMethodBreakpointActionDelegate.CantAdd"));
                        return;
                    }
                    ++i;
                }
                IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                int i2 = 0;
                int length2 = members.length;
                while (i2 < length2) {
                    IMethod method = (IMethod)members[i2];
                    IJavaBreakpoint breakpoint = this.getBreakpoint((IMember)method);
                    if (breakpoint == null) {
                        int start = -1;
                        int end = -1;
                        ISourceRange range = method.getNameRange();
                        if (range != null) {
                            start = range.getOffset();
                            end = start + range.getLength();
                        }
                        HashMap attributes = new HashMap(10);
                        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
                        String methodName = method.getElementName();
                        if (method.isConstructor()) {
                            methodName = "<init>";
                        }
                        IType type = method.getDeclaringType();
                        String methodSignature = method.getSignature();
                        if (!type.isBinary() && (methodSignature = ManageMethodBreakpointActionDelegate.resolveMethodSignature(type, methodSignature)) == null) {
                            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, "Source method signature could not be resolved", null);
                            JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageMethodBreakpointActionDelegate.Add_Method_Breakpoint_Failed_2"), (IStatus)status);
                            return;
                        }
                        JDIDebugModel.createMethodBreakpoint((IResource)BreakpointUtils.getBreakpointResource((IMember)method), (String)type.getFullyQualifiedName(), (String)methodName, (String)methodSignature, (boolean)true, (boolean)false, (boolean)false, (int)-1, (int)start, (int)end, (int)0, (boolean)true, attributes);
                    } else {
                        try {
                            breakpointManager.removeBreakpoint((IBreakpoint)breakpoint, true);
                        }
                        catch (CoreException x) {
                            JDIDebugUIPlugin.log(x);
                            MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageMethodBreakpointAction.Problems_removing_breakpoint_8"), (String)x.getMessage());
                        }
                    }
                    ++i2;
                }
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x);
                MessageDialog.openError((Shell)JDIDebugUIPlugin.getActiveWorkbenchShell(), (String)ActionMessages.getString("ManageMethodBreakpointAction.Problems_creating_breakpoint_7"), (String)x.getMessage());
            }
        }
    }

    public static String resolveMethodSignature(IType type, String methodSignature) throws JavaModelException {
        String[] parameterTypes = Signature.getParameterTypes((String)methodSignature);
        StringBuffer resolvedSig = new StringBuffer("(");
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = parameterTypes[i];
            if (parameterType.length() > 1) {
                if (!ManageMethodBreakpointActionDelegate.generateQualifiedName(type, resolvedSig, parameterType)) {
                    return null;
                }
                resolvedSig.append(';');
            } else {
                resolvedSig.append(parameterType);
            }
            ++i;
        }
        resolvedSig.append(')');
        String returnType = Signature.getReturnType((String)methodSignature);
        if (returnType.length() > 1) {
            if (!ManageMethodBreakpointActionDelegate.generateQualifiedName(type, resolvedSig, returnType)) {
                return null;
            }
            resolvedSig.append(';');
        } else {
            resolvedSig.append(returnType);
        }
        methodSignature = resolvedSig.toString();
        return methodSignature;
    }

    protected static boolean generateQualifiedName(IType type, StringBuffer resolvedSig, String typeName) throws JavaModelException {
        int count = Signature.getArrayCount((String)typeName);
        String[][] resolvedType = type.resolveType(typeName = Signature.getElementType((String)typeName.substring(1 + count, typeName.length() - 1)));
        if (resolvedType != null && resolvedType.length == 1) {
            String[] typeNames = resolvedType[0];
            String qualifiedName = Signature.toQualifiedName((String[])typeNames);
            if (qualifiedName.startsWith(".")) {
                qualifiedName = qualifiedName.substring(1);
            }
            int j = 0;
            while (j < count) {
                resolvedSig.append('[');
                ++j;
            }
            resolvedSig.append('L');
            resolvedSig.append(qualifiedName.replace('.', '/'));
            return true;
        }
        return false;
    }

    protected boolean enableForMember(IMember member) {
        try {
            return member instanceof IMethod && !Flags.isAbstract((int)member.getFlags());
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            return false;
        }
    }

    protected void setEnabledState(ITextEditor editor) {
        if (this.getAction() != null && this.getPage() != null) {
            IWorkbenchPart part = this.getPage().getActivePart();
            if (part == null) {
                this.getAction().setEnabled(false);
            } else if (part == this.getPage().getActiveEditor()) {
                if (this.getPage().getActiveEditor() instanceof ITextEditor) {
                    super.setEnabledState((ITextEditor)this.getPage().getActiveEditor());
                } else {
                    this.getAction().setEnabled(false);
                }
            }
        }
    }
}

