/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.BreakpointLocationVerifierJob;
import org.eclipse.jdt.ui.IWorkingCopyManager;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.AbstractMarkerAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.IUpdate;

public class ManageBreakpointRulerAction
extends Action
implements IUpdate {
    private IVerticalRulerInfo fRuler;
    private ITextEditor fTextEditor;
    private List fMarkers;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ManageBreakpointRulerAction(IVerticalRulerInfo ruler, ITextEditor editor) {
        super(ActionMessages.getString("ManageBreakpointRulerAction.label"));
        this.fRuler = ruler;
        this.fTextEditor = editor;
    }

    protected IResource getResource() {
        IResource resource;
        IEditorInput input = this.fTextEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.core.resources.IFile;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)input.getAdapter((Class)clazz)) == null) {
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("[Lorg.eclipse.core.resources.IResource;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            resource = (IResource)input.getAdapter((Class)clazz2);
        }
        return resource;
    }

    protected boolean includesRulerLine(Position position, IDocument document) {
        if (position != null) {
            try {
                int markerLine = document.getLineOfOffset(position.getOffset());
                int line = this.fRuler.getLineOfLastMouseButtonActivity();
                if (line == markerLine) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {}
        }
        return false;
    }

    protected IVerticalRulerInfo getVerticalRulerInfo() {
        return this.fRuler;
    }

    protected ITextEditor getTextEditor() {
        return this.fTextEditor;
    }

    protected AbstractMarkerAnnotationModel getAnnotationModel() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        IAnnotationModel model = provider.getAnnotationModel((Object)this.fTextEditor.getEditorInput());
        if (model instanceof AbstractMarkerAnnotationModel) {
            return (AbstractMarkerAnnotationModel)model;
        }
        return null;
    }

    protected IDocument getDocument() {
        IDocumentProvider provider = this.fTextEditor.getDocumentProvider();
        return provider.getDocument((Object)this.fTextEditor.getEditorInput());
    }

    public void update() {
        this.fMarkers = this.getMarkers();
    }

    public void run() {
        this.report(null);
        if (this.fMarkers.isEmpty()) {
            this.addMarker();
        } else {
            this.removeMarkers(this.fMarkers);
        }
    }

    protected List getMarkers() {
        ArrayList<IMarker> breakpoints = new ArrayList<IMarker>();
        IResource resource = this.getResource();
        IDocument document = this.getDocument();
        AbstractMarkerAnnotationModel model = this.getAnnotationModel();
        if (model != null) {
            try {
                IMarker[] markers = null;
                if (resource instanceof IFile) {
                    markers = resource.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                } else {
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    markers = root.findMarkers(IBreakpoint.BREAKPOINT_MARKER, true, 2);
                }
                if (markers != null) {
                    IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
                    int i = 0;
                    while (i < markers.length) {
                        IBreakpoint breakpoint = breakpointManager.getBreakpoint(markers[i]);
                        if (breakpoint != null && breakpointManager.isRegistered(breakpoint) && this.includesRulerLine(model.getMarkerPosition(markers[i]), document)) {
                            breakpoints.add(markers[i]);
                        }
                        ++i;
                    }
                }
            }
            catch (CoreException x) {
                JDIDebugUIPlugin.log(x.getStatus());
            }
        }
        return breakpoints;
    }

    protected void addMarker() {
        IEditorInput editorInput = this.getTextEditor().getEditorInput();
        try {
            Object resource;
            IClassFile classFile;
            IDocument document = this.getDocument();
            int lineNumber = this.getVerticalRulerInfo().getLineOfLastMouseButtonActivity();
            IRegion line = document.getLineInformation(lineNumber);
            ++lineNumber;
            IType type = null;
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("[Lorg.eclipse.jdt.core.IClassFile;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((classFile = (IClassFile)editorInput.getAdapter((Class)clazz)) != null) {
                type = classFile.getType();
                if (type.getDeclaringType() != null) {
                    ISourceRange sourceRange = type.getSourceRange();
                    int offset = line.getOffset();
                    int start = sourceRange.getOffset();
                    int end = start + sourceRange.getLength();
                    if (offset < start || offset > end) {
                        this.report(MessageFormat.format(ActionMessages.getString("ManageBreakpointRulerAction.Breakpoints_can_only_be_created_within_the_type_associated_with_the_editor__{0}._1"), type.getTypeQualifiedName()));
                        return;
                    }
                }
                resource = BreakpointUtils.getBreakpointResource((IMember)type);
            } else if (editorInput instanceof IFileEditorInput) {
                IWorkingCopyManager manager = JavaUI.getWorkingCopyManager();
                ICompilationUnit unit = manager.getWorkingCopy(editorInput);
                if (unit != null) {
                    ICompilationUnit start = unit;
                    synchronized (start) {
                        unit.reconcile();
                    }
                    IJavaElement e = unit.getElementAt(line.getOffset());
                    if (e instanceof IType) {
                        type = (IType)e;
                    } else if (e instanceof IMember) {
                        type = ((IMember)e).getDeclaringType();
                    }
                }
                resource = type != null ? BreakpointUtils.getBreakpointResource((IMember)type) : ((IFileEditorInput)editorInput).getFile();
            } else {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            HashMap attributes = new HashMap(10);
            String typeName = null;
            IJavaLineBreakpoint breakpoint = null;
            if (type != null) {
                IJavaProject project = type.getJavaProject();
                typeName = type.getFullyQualifiedName();
                if (type.exists() && project != null && project.isOnClasspath((IJavaElement)type) && JDIDebugModel.lineBreakpointExists((String)typeName, (int)lineNumber) == null) {
                    int start = line.getOffset();
                    int end = start + line.getLength() - 1;
                    BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, (IJavaElement)type, start, end);
                }
                breakpoint = JDIDebugModel.createLineBreakpoint((IResource)resource, (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, attributes);
            }
            ITextEditor iTextEditor = this.getTextEditor();
            Class<?> clazz2 = class$3;
            if (clazz2 == null) {
                try {
                    clazz2 = class$3 = Class.forName("[Lorg.eclipse.ui.texteditor.IEditorStatusLine;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            new BreakpointLocationVerifierJob(document, breakpoint, lineNumber, typeName, type, (IResource)resource, (IEditorStatusLine)iTextEditor.getAdapter((Class)clazz2)).schedule();
        }
        catch (DebugException e) {
            JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.adding.message1"), e);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.adding.message1"), e);
        }
        catch (BadLocationException e) {
            JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.adding.message1"), e);
        }
    }

    protected void removeMarkers(List markers) {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        try {
            Iterator e = markers.iterator();
            while (e.hasNext()) {
                IBreakpoint breakpoint = breakpointManager.getBreakpoint((IMarker)e.next());
                breakpointManager.removeBreakpoint(breakpoint, true);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(ActionMessages.getString("ManageBreakpointRulerAction.error.removing.message1"), e);
        }
    }

    protected void report(String message) {
        IEditorStatusLine statusLine;
        ITextEditor iTextEditor = this.getTextEditor();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("[Lorg.eclipse.ui.texteditor.IEditorStatusLine;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)iTextEditor.getAdapter((Class)clazz)) != null) {
            statusLine.setMessage(true, message, null);
        }
        if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
            Display.getCurrent().beep();
        }
    }
}

