/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import com.sun.jdi.InvocationException;
import com.sun.jdi.ObjectReference;
import java.text.MessageFormat;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaArray;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.debug.eval.IAstEvaluationEngine;
import org.eclipse.jdt.debug.eval.IEvaluationListener;
import org.eclipse.jdt.debug.eval.IEvaluationResult;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.internal.debug.ui.EvaluationContextManager;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.display.DataDisplay;
import org.eclipse.jdt.internal.debug.ui.display.IDataDisplay;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.ISnippetStateChangedListener;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;

public abstract class EvaluateAction
implements IEvaluationListener,
IWorkbenchWindowActionDelegate,
IObjectActionDelegate,
IEditorActionDelegate,
IPartListener,
IViewActionDelegate,
ISnippetStateChangedListener {
    private IAction fAction;
    private IWorkbenchPart fTargetPart;
    private IWorkbenchWindow fWindow;
    private Object fSelection;
    private boolean fEvaluating;
    private IWorkbenchPart fNewTargetPart = null;
    private IDebugModelPresentation fPresentation;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected IJavaObject getObjectContext() {
        IWorkbenchPart activePart;
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page != null && (activePart = page.getActivePart()) != null) {
            IStructuredSelection structuredSelection;
            ISelection s;
            IDebugView a;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.debug.ui.IDebugView;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((a = (IDebugView)activePart.getAdapter((Class)clazz)) != null && a.getViewer() != null && (s = a.getViewer().getSelection()) instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)s).size() == 1) {
                IValue value;
                Object selection = structuredSelection.getFirstElement();
                if (selection instanceof IJavaVariable) {
                    IJavaVariable var = (IJavaVariable)selection;
                    try {
                        IValue value2;
                        if (!var.getName().equals("this") && (value2 = var.getValue()) instanceof IJavaObject && !(value2 instanceof IJavaArray)) {
                            return (IJavaObject)value2;
                        }
                    }
                    catch (DebugException e) {
                        JDIDebugUIPlugin.log(e);
                    }
                } else if (selection instanceof JavaInspectExpression && (value = ((JavaInspectExpression)((Object)selection)).getValue()) instanceof IJavaObject && !(value instanceof IJavaArray)) {
                    return (IJavaObject)value;
                }
            }
        }
        return null;
    }

    protected IJavaStackFrame getStackFrameContext() {
        IWorkbenchPart part = this.getTargetPart();
        IJavaStackFrame frame = null;
        frame = part == null ? EvaluationContextManager.getEvaluationContext(this.getWindow()) : EvaluationContextManager.getEvaluationContext(part);
        return frame;
    }

    public void evaluationComplete(IEvaluationResult result) {
        if (JDIDebugUIPlugin.getDefault() == null) {
            return;
        }
        IJavaValue value = result.getValue();
        if (result.hasErrors() || value != null) {
            Display display = JDIDebugUIPlugin.getStandardDisplay();
            if (display.isDisposed()) {
                return;
            }
            this.displayResult(result);
        }
    }

    protected void evaluationCleanup() {
        this.setEvaluating(false);
        this.setTargetPart(this.fNewTargetPart);
    }

    protected abstract void displayResult(IEvaluationResult var1);

    protected void run() {
        IJavaObject object = this.getObjectContext();
        IJavaStackFrame stackFrame = this.getStackFrameContext();
        if (stackFrame == null) {
            this.reportError(ActionMessages.getString("Evaluate.error.message.stack_frame_context"));
            return;
        }
        IJavaThread thread = (IJavaThread)stackFrame.getThread();
        if (thread.isPerformingEvaluation()) {
            this.reportError(ActionMessages.getString("EvaluateAction.Cannot_perform_nested_evaluations._1"));
            return;
        }
        this.setNewTargetPart(this.getTargetPart());
        if (stackFrame.isSuspended()) {
            IJavaElement javaElement = this.getJavaElement((IStackFrame)stackFrame);
            if (javaElement != null) {
                IJavaProject project = javaElement.getJavaProject();
                IAstEvaluationEngine engine = null;
                try {
                    Object selection = this.getSelectedObject();
                    if (!(selection instanceof String)) {
                        return;
                    }
                    String expression = (String)selection;
                    engine = JDIDebugUIPlugin.getDefault().getEvaluationEngine(project, (IJavaDebugTarget)stackFrame.getDebugTarget());
                    this.setEvaluating(true);
                    if (object == null) {
                        engine.evaluate(expression, stackFrame, (IEvaluationListener)this, 64, true);
                    } else {
                        engine.evaluate(expression, object, (IJavaThread)stackFrame.getThread(), (IEvaluationListener)this, 64, true);
                    }
                    return;
                }
                catch (CoreException e) {
                    this.reportError(this.getExceptionMessage(e));
                }
            } else {
                this.reportError(ActionMessages.getString("Evaluate.error.message.src_context"));
            }
        } else {
            this.reportError(ActionMessages.getString("EvaluateAction.Thread_not_suspended_-_unable_to_perform_evaluation._1"));
        }
        this.evaluationCleanup();
    }

    protected IJavaElement getJavaElement(IStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return null;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return null;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement instanceof IJavaElement) {
            return (IJavaElement)sourceElement;
        }
        return null;
    }

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            this.resolveSelectedObject();
        }
    }

    protected void resolveSelectedObject() {
        String selectedObject = null;
        ISelection selection = this.getTargetSelection();
        if (selection instanceof ITextSelection) {
            String text = ((ITextSelection)selection).getText();
            if (this.textHasContent(text)) {
                selectedObject = text;
            }
        } else if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            if (this.getTargetPart().getSite().getId().equals("org.eclipse.debug.ui.DebugView")) {
                String text;
                this.setTargetPart((IWorkbenchPart)this.getTargetPart().getSite().getPage().getActiveEditor());
                selection = this.getTargetSelection();
                if (selection instanceof ITextSelection && this.textHasContent(text = ((ITextSelection)selection).getText())) {
                    selectedObject = text;
                }
            } else {
                IStructuredSelection ss = (IStructuredSelection)selection;
                Iterator elements = ss.iterator();
                while (elements.hasNext()) {
                    if (elements.next() instanceof IJavaVariable) continue;
                    this.setSelectedObject(null);
                    return;
                }
                selectedObject = ss;
            }
        }
        this.setSelectedObject(selectedObject);
    }

    protected ISelection getTargetSelection() {
        ISelectionProvider provider;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null && (provider = part.getSite().getSelectionProvider()) != null) {
            return provider.getSelection();
        }
        return null;
    }

    protected boolean compareToEditorInput(IStackFrame stackFrame) {
        ILaunch launch = stackFrame.getLaunch();
        if (launch == null) {
            return false;
        }
        ISourceLocator locator = launch.getSourceLocator();
        if (locator == null) {
            return false;
        }
        Object sourceElement = locator.getSourceElement(stackFrame);
        if (sourceElement == null) {
            return false;
        }
        IEditorInput sfEditorInput = this.getDebugModelPresentation().getEditorInput(sourceElement);
        if (this.getTargetPart() instanceof IEditorPart) {
            return ((IEditorPart)this.getTargetPart()).getEditorInput().equals(sfEditorInput);
        }
        return false;
    }

    protected Shell getShell() {
        if (this.getTargetPart() != null) {
            return this.getTargetPart().getSite().getShell();
        }
        return JDIDebugUIPlugin.getActiveWorkbenchShell();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected IDataDisplay getDataDisplay() {
        Class<?> clazz;
        IDataDisplay display = this.getDirectDataDisplay();
        if (display != null) {
            return display;
        }
        IWorkbenchPage page = JDIDebugUIPlugin.getActivePage();
        if (page == null) return null;
        IWorkbenchPart activePart = page.getActivePart();
        if (activePart == null) return null;
        IViewPart view = page.findView(IJavaDebugUIConstants.ID_DISPLAY_VIEW);
        if (view == null) {
            try {
                try {
                    view = page.showView(IJavaDebugUIConstants.ID_DISPLAY_VIEW);
                }
                catch (PartInitException e) {
                    JDIDebugUIPlugin.errorDialog(ActionMessages.getString("EvaluateAction.Cannot_open_Display_view"), e);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                page.activate(activePart);
                throw throwable;
            }
            {
                Object var6_8 = null;
            }
            page.activate(activePart);
        }
        if (view == null) return null;
        page.bringToTop((IWorkbenchPart)view);
        Class<?> clazz2 = class$1;
        Class<?> clazz3 = clazz2;
        if (clazz2 != null) return (IDataDisplay)view.getAdapter((Class)clazz3);
        try {
            clazz = Class.forName("[Lorg.eclipse.jdt.internal.debug.ui.display.IDataDisplay;").getComponentType();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        clazz3 = class$1 = clazz;
        return (IDataDisplay)view.getAdapter((Class)clazz3);
    }

    protected IDataDisplay getDirectDataDisplay() {
        IWorkbenchPart activePart;
        IWorkbenchPage page;
        IWorkbenchPart part = this.getTargetPart();
        if (part != null) {
            IDataDisplay display;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.internal.debug.ui.display.IDataDisplay;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((display = (IDataDisplay)part.getAdapter((Class)clazz)) != null) {
                IWorkbenchPart activePart2;
                IWorkbenchPage page2 = JDIDebugUIPlugin.getActivePage();
                if (page2 != null && (activePart2 = page2.getActivePart()) != null && activePart2 != part) {
                    page2.activate(part);
                }
                return display;
            }
        }
        if ((page = JDIDebugUIPlugin.getActivePage()) != null && (activePart = page.getActivePart()) != null) {
            ITextViewer viewer;
            IDataDisplay display;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("[Lorg.eclipse.jdt.internal.debug.ui.display.IDataDisplay;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((display = (IDataDisplay)activePart.getAdapter((Class)clazz)) != null) {
                return display;
            }
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("[Lorg.eclipse.jface.text.ITextViewer;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((viewer = (ITextViewer)activePart.getAdapter((Class)clazz2)) != null) {
                return new DataDisplay(viewer);
            }
        }
        return null;
    }

    protected boolean textHasContent(String text) {
        int length;
        if (text != null && (length = text.length()) > 0) {
            int i = 0;
            while (i < length) {
                if (Character.isLetterOrDigit(text.charAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void reportErrors(IEvaluationResult result) {
        String message = this.getErrorMessage(result);
        this.reportError(message);
    }

    protected void reportError(String message) {
        IDataDisplay dataDisplay = this.getDirectDataDisplay();
        if (dataDisplay != null) {
            if (message.length() != 0) {
                dataDisplay.displayExpressionValue(MessageFormat.format(ActionMessages.getString("EvaluateAction.(evaluation_failed)_Reason"), this.format(message)));
            } else {
                dataDisplay.displayExpressionValue(ActionMessages.getString("EvaluateAction.(evaluation_failed)_1"));
            }
        } else {
            Status status = new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 4, message, null);
            ErrorDialog.openError((Shell)this.getShell(), (String)ActionMessages.getString("Evaluate.error.title.eval_problems"), null, (IStatus)status);
        }
    }

    private String format(String message) {
        int pos;
        StringBuffer result = new StringBuffer();
        int index = 0;
        while ((pos = message.indexOf(10, index)) != -1) {
            int n = index;
            index = pos + 1;
            result.append("\t\t").append(message.substring(n, index));
        }
        if (index < message.length()) {
            result.append("\t\t").append(message.substring(index));
        }
        return result.toString();
    }

    protected String getExceptionMessage(Throwable exception) {
        if (exception instanceof CoreException) {
            CoreException ce = (CoreException)exception;
            Throwable throwable = ce.getStatus().getException();
            if (throwable instanceof InvocationException) {
                return this.getInvocationExceptionMessage((InvocationException)throwable);
            }
            if (throwable instanceof CoreException) {
                return this.getExceptionMessage(throwable);
            }
            return ce.getStatus().getMessage();
        }
        String message = MessageFormat.format(ActionMessages.getString("Evaluate.error.message.direct_exception"), exception.getClass());
        if (exception.getMessage() != null) {
            message = MessageFormat.format(ActionMessages.getString("Evaluate.error.message.exception.pattern"), message, exception.getMessage());
        }
        return message;
    }

    protected String getInvocationExceptionMessage(InvocationException exception) {
        InvocationException ie = exception;
        ObjectReference ref = ie.exception();
        return MessageFormat.format(ActionMessages.getString("Evaluate.error.message.wrapped_exception"), ref.referenceType().name());
    }

    protected String getErrorMessage(IEvaluationResult result) {
        String[] errors = result.getErrorMessages();
        if (errors.length == 0) {
            return this.getExceptionMessage(result.getException());
        }
        return this.getErrorMessage(errors);
    }

    protected String getErrorMessage(String[] errors) {
        String message = "";
        int i = 0;
        while (i < errors.length) {
            String msg = errors[i];
            message = i == 0 ? msg : MessageFormat.format(ActionMessages.getString("Evaluate.error.problem_append_pattern"), message, msg);
            ++i;
        }
        return message;
    }

    public void run(IAction action) {
        this.update();
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.setAction(action);
    }

    public void dispose() {
        this.disposeDebugModelPresentation();
        IWorkbenchWindow win = this.getWindow();
        if (win != null) {
            win.getPartService().removePartListener((IPartListener)this);
        }
    }

    public void init(IWorkbenchWindow window) {
        this.setWindow(window);
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            this.setTargetPart(page.getActivePart());
        }
        window.getPartService().addPartListener((IPartListener)this);
        this.update();
    }

    protected IAction getAction() {
        return this.fAction;
    }

    protected void setAction(IAction action) {
        this.fAction = action;
    }

    protected IDebugModelPresentation getDebugModelPresentation() {
        if (this.fPresentation == null) {
            this.fPresentation = DebugUITools.newDebugModelPresentation((String)JDIDebugModel.getPluginIdentifier());
        }
        return this.fPresentation;
    }

    protected void disposeDebugModelPresentation() {
        if (this.fPresentation != null) {
            this.fPresentation.dispose();
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setAction(action);
        this.setTargetPart((IWorkbenchPart)targetEditor);
    }

    public void partActivated(IWorkbenchPart part) {
        this.setTargetPart(part);
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        if (part == this.getTargetPart()) {
            this.setTargetPart(null);
        }
        if (part == this.getNewTargetPart()) {
            this.setNewTargetPart(null);
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void init(IViewPart view) {
        this.setTargetPart((IWorkbenchPart)view);
    }

    protected IWorkbenchPart getTargetPart() {
        return this.fTargetPart;
    }

    protected void setTargetPart(IWorkbenchPart part) {
        if (this.isEvaluating()) {
            this.setNewTargetPart(part);
        } else {
            if (this.getTargetPart() instanceof JavaSnippetEditor) {
                ((JavaSnippetEditor)this.getTargetPart()).removeSnippetStateChangedListener(this);
            }
            this.fTargetPart = part;
            if (part instanceof JavaSnippetEditor) {
                ((JavaSnippetEditor)part).addSnippetStateChangedListener(this);
            }
        }
    }

    protected IWorkbenchWindow getWindow() {
        return this.fWindow;
    }

    protected void setWindow(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.setAction(action);
        this.setTargetPart(targetPart);
        this.update();
    }

    protected Object getSelectedObject() {
        return this.fSelection;
    }

    protected void setSelectedObject(Object selection) {
        this.fSelection = selection;
    }

    public void snippetStateChanged(JavaSnippetEditor editor) {
        if (editor != null && !editor.isEvaluating()) {
            this.update();
        } else {
            this.getAction().setEnabled(false);
        }
    }

    protected IWorkbenchPart getNewTargetPart() {
        return this.fNewTargetPart;
    }

    protected void setNewTargetPart(IWorkbenchPart newTargetPart) {
        this.fNewTargetPart = newTargetPart;
    }

    protected boolean isEvaluating() {
        return this.fEvaluating;
    }

    protected void setEvaluating(boolean evaluating) {
        this.fEvaluating = evaluating;
    }
}

