/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.texteditor.IEditorStatusLine;

public class BreakpointLocationVerifierJob
extends Job {
    private IDocument fDocument;
    private IJavaLineBreakpoint fBreakpoint;
    private int fLineNumber;
    private String fTypeName;
    private IType fType;
    private IResource fResource;
    private IEditorStatusLine fStatusLine;

    public BreakpointLocationVerifierJob(IDocument document, IJavaLineBreakpoint breakpoint, int lineNumber, String typeName, IType type, IResource resource, IEditorStatusLine statusLine) {
        super(ActionMessages.getString("BreakpointLocationVerifierJob.breakpoint_location"));
        this.fDocument = document;
        this.fBreakpoint = breakpoint;
        this.fLineNumber = lineNumber;
        this.fTypeName = typeName;
        this.fType = type;
        this.fResource = resource;
        this.fStatusLine = statusLine;
    }

    public IStatus run(IProgressMonitor monitor) {
        CompilationUnit compilationUnit = AST.parseCompilationUnit((char[])this.fDocument.get().toCharArray());
        ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(compilationUnit, this.fLineNumber);
        compilationUnit.accept((ASTVisitor)locator);
        int lineNumber = locator.getValidLocation();
        String typeName = locator.getFullyQualifiedTypeName();
        try {
            boolean breakpointExist;
            if (lineNumber == -1) {
                this.report(ActionMessages.getString("BreakpointLocationVerifierJob.not_valid_location"));
                if (this.fBreakpoint != null) {
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                }
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.getString("BreakpointLocationVerifierJob.not_valid_location"), null);
            }
            boolean differentLineNumber = lineNumber != this.fLineNumber;
            IJavaLineBreakpoint breakpoint = JDIDebugModel.lineBreakpointExists((String)typeName, (int)lineNumber);
            boolean bl = breakpointExist = breakpoint != null;
            if (this.fBreakpoint == null) {
                if (breakpointExist) {
                    if (differentLineNumber) {
                        this.report(ActionMessages.getString("BreakpointLocationVerifierJob.not_valid_location"));
                        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.getString("BreakpointLocationVerifierJob.not_valid_location"), null);
                    }
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)breakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.getString("BreakpointLocationVerifierJob.breakpointRemoved"), null);
                }
                this.createNewBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.getString("BreakpointLocationVerifierJob.breakpoint_set"), null);
            }
            if (differentLineNumber) {
                if (breakpointExist) {
                    this.report(ActionMessages.getString("BreakpointLocationVerifierJob.not_valid_location"));
                    DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
                    return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 4, ActionMessages.getString("BreakpointLocationVerifierJob.not_valid_location"), null);
                }
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.getString("BreakpointLocationVerifierJob.breakpointMovedToValidPosition"), null);
            }
            if (!typeName.equals(this.fTypeName)) {
                this.replaceBreakpoint(lineNumber, typeName);
                return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 2, ActionMessages.getString("BreakpointLocationVerifierJob.breakpointSetToRightType"), null);
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return new Status(0, JDIDebugUIPlugin.getUniqueIdentifier(), 0, ActionMessages.getString("BreakpointLocationVerifierJob.breakpoint_set"), null);
    }

    private void replaceBreakpoint(int lineNumber, String typeName) throws CoreException {
        this.createNewBreakpoint(lineNumber, typeName);
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)this.fBreakpoint, true);
    }

    private void createNewBreakpoint(int lineNumber, String typeName) throws CoreException {
        HashMap newAttributes = new HashMap(10);
        if (this.fType != null) {
            try {
                IRegion line = this.fDocument.getLineInformation(lineNumber - 1);
                int start = line.getOffset();
                int end = start + line.getLength() - 1;
                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(newAttributes, (IJavaElement)this.fType, start, end);
            }
            catch (BadLocationException ble) {
                JDIDebugUIPlugin.log(ble);
            }
        }
        JDIDebugModel.createLineBreakpoint((IResource)this.fResource, (String)typeName, (int)lineNumber, (int)-1, (int)-1, (int)0, (boolean)true, newAttributes);
    }

    protected void report(final String message) {
        JDIDebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                if (BreakpointLocationVerifierJob.this.fStatusLine != null) {
                    BreakpointLocationVerifierJob.this.fStatusLine.setMessage(true, message, null);
                }
                if (message != null && JDIDebugUIPlugin.getActiveWorkbenchShell() != null) {
                    Display.getCurrent().beep();
                }
            }
        });
    }
}

