/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class BreakpointHitCountAction
extends ObjectActionDelegate {
    private static final String INITIAL_VALUE = "1";

    /*
     * Unable to fully structure code
     */
    public void run(IAction action) {
        selection = this.getCurrentSelection();
        if (selection == null) {
            return;
        }
        itr = selection.iterator();
        if (itr.hasNext()) ** GOTO lbl18
        return;
lbl-1000:
        // 1 sources

        {
            breakpoint = (IJavaBreakpoint)itr.next();
            try {
                oldHitCount = breakpoint.getHitCount();
                newHitCount = this.hitCountDialog(breakpoint);
                if (newHitCount == -1) continue;
                if (oldHitCount == newHitCount && newHitCount == 0) {
                    return;
                }
                breakpoint.setHitCount(newHitCount);
                continue;
            }
            catch (CoreException ce) {
                JDIDebugUIPlugin.errorDialog(ActionMessages.getString("BreakpointHitCountAction.Exception_occurred_attempting_to_set_hit_count_1"), ce);
            }
lbl18:
            // 4 sources

            ** while (itr.hasNext())
        }
lbl19:
        // 1 sources

    }

    protected int hitCountDialog(IJavaBreakpoint breakpoint) {
        String title = ActionMessages.getString("BreakpointHitCountAction.Set_Breakpoint_Hit_Count_2");
        String message = ActionMessages.getString("BreakpointHitCountAction.&Enter_the_new_hit_count_for_the_breakpoint__3");
        IInputValidator validator = new IInputValidator(){
            int hitCount = -1;

            public String isValid(String value) {
                try {
                    this.hitCount = Integer.valueOf(value.trim());
                }
                catch (NumberFormatException numberFormatException) {
                    this.hitCount = -1;
                }
                if (this.hitCount < 1) {
                    return ActionMessages.getString("BreakpointHitCountAction.Value_must_be_positive_integer");
                }
                return null;
            }
        };
        int currentHitCount = 0;
        try {
            currentHitCount = breakpoint.getHitCount();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        String initialValue = currentHitCount > 0 ? Integer.toString(currentHitCount) : INITIAL_VALUE;
        Shell activeShell = JDIDebugUIPlugin.getActiveWorkbenchShell();
        HitCountDialog dialog = new HitCountDialog(activeShell, title, message, initialValue, validator);
        if (dialog.open() != 0) {
            return -1;
        }
        if (dialog.isHitCountEnabled()) {
            return Integer.parseInt(dialog.getValue().trim());
        }
        return 0;
    }

    class HitCountDialog
    extends InputDialog {
        private Button fEnabledButton;
        private boolean fHitCountEnabled;

        protected HitCountDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
            super(parentShell, dialogTitle, dialogMessage, initialValue, validator);
        }

        public boolean close() {
            this.setHitCountEnabled(this.getEnabledButton().getSelection());
            return super.close();
        }

        protected Control createDialogArea(Composite parent) {
            Composite area = (Composite)super.createDialogArea(parent);
            Button b = new Button(area, 32);
            GridData data = new GridData(768);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            b.setLayoutData((Object)data);
            b.setFont(parent.getFont());
            b.setText(ActionMessages.getString("BreakpointHitCountAction.Enable_Hit_Count_1"));
            b.setSelection(true);
            b.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ HitCountDialog this$1;
                {
                    this.this$1 = hitCountDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = this.this$1.getEnabledButton().getSelection();
                    HitCountDialog.access$0(this.this$1).setEnabled(enabled);
                    if (enabled) {
                        HitCountDialog.access$1(this.this$1);
                    } else {
                        HitCountDialog.access$2(this.this$1).setEnabled(true);
                        HitCountDialog.access$3(this.this$1).setText("");
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.setEnabledButton(b);
            return area;
        }

        protected Button getEnabledButton() {
            return this.fEnabledButton;
        }

        protected void setEnabledButton(Button enabledButton) {
            this.fEnabledButton = enabledButton;
        }

        protected boolean isHitCountEnabled() {
            return this.fHitCountEnabled;
        }

        protected void setHitCountEnabled(boolean hitCountEnabled) {
            this.fHitCountEnabled = hitCountEnabled;
        }

        static /* synthetic */ Text access$0(HitCountDialog hitCountDialog) {
            return hitCountDialog.getText();
        }

        static /* synthetic */ void access$1(HitCountDialog hitCountDialog) {
            hitCountDialog.validateInput();
        }

        static /* synthetic */ Button access$2(HitCountDialog hitCountDialog) {
            return hitCountDialog.getOkButton();
        }

        static /* synthetic */ Label access$3(HitCountDialog hitCountDialog) {
            return hitCountDialog.getErrorMessageLabel();
        }
    }
}

