/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.help.WorkbenchHelp;

public class AttachSourceAction
extends RuntimeClasspathAction {
    private IRuntimeClasspathEntry fEntry;

    public AttachSourceAction(RuntimeClasspathViewer viewer, int style) {
        super(style == 16 ? ActionMessages.getString("AttachSourceAction.2") : ActionMessages.getString("AttachSourceAction.3"), viewer);
    }

    public void run() {
        SourceAttachmentDialog dialog = new SourceAttachmentDialog(this.getShell(), this.fEntry);
        int res = dialog.open();
        if (res == 0) {
            this.fEntry.setSourceAttachmentPath(dialog.getSourceAttachmentPath());
            this.fEntry.setSourceAttachmentRootPath(dialog.getSourceAttachmentRootPath());
            this.getViewer().refresh(this.fEntry);
            this.getViewer().notifyChanged();
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object selected;
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof IRuntimeClasspathEntry) {
            this.fEntry = (IRuntimeClasspathEntry)selected;
            int type = this.fEntry.getType();
            return type == 3 || type == 2;
        }
        return false;
    }

    private class SourceAttachmentDialog
    extends StatusDialog
    implements IStatusChangeListener {
        private SourceAttachmentBlock fSourceAttachmentBlock;

        public SourceAttachmentDialog(Shell parent, IRuntimeClasspathEntry entry) {
            super(parent);
            this.setTitle(MessageFormat.format(ActionMessages.getString("AttachSourceAction.Attachments_For_____{0}_____1"), entry.getPath().toString()));
            this.fSourceAttachmentBlock = new SourceAttachmentBlock((IStatusChangeListener)this, entry.getClasspathEntry(), null, null);
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.source_attachment_dialog_context");
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Control inner = this.fSourceAttachmentBlock.createControl(composite);
            inner.setLayoutData((Object)new GridData(1808));
            return composite;
        }

        public void statusChanged(IStatus status) {
            this.updateStatus(status);
        }

        public IPath getSourceAttachmentPath() {
            return this.fSourceAttachmentBlock.getSourceAttachmentPath();
        }

        public IPath getSourceAttachmentRootPath() {
            return this.fSourceAttachmentBlock.getSourceAttachmentRootPath();
        }
    }
}

