/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class JavaDebugImages {
    private static final String NAME_PREFIX = "org.eclipse.jdt.debug.ui.";
    private static final int NAME_PREFIX_LENGTH = "org.eclipse.jdt.debug.ui.".length();
    private static URL fgIconBaseURL = null;
    private static ImageRegistry fgImageRegistry;
    private static HashMap fgAvoidSWTErrorMap;
    public static final String IMG_OBJS_EXCEPTION = "org.eclipse.jdt.debug.ui.jexception_obj.gif";
    public static final String IMG_OBJS_EXCEPTION_DISABLED = "org.eclipse.jdt.debug.ui.jexceptiond_obj.gif";
    public static final String IMG_OBJS_ERROR = "org.eclipse.jdt.debug.ui.jrtexception_obj.gif";
    public static final String IMG_OBJS_BREAKPOINT_INSTALLED = "org.eclipse.jdt.debug.ui.installed_ovr.gif";
    public static final String IMG_OBJS_BREAKPOINT_INSTALLED_DISABLED = "org.eclipse.jdt.debug.ui.installed_ovr_disabled.gif";
    public static final String IMG_OBJS_ACCESS_WATCHPOINT_ENABLED = "org.eclipse.jdt.debug.ui.read_obj.gif";
    public static final String IMG_OBJS_ACCESS_WATCHPOINT_DISABLED = "org.eclipse.jdt.debug.ui.read_obj_disabled.gif";
    public static final String IMG_OBJS_MODIFICATION_WATCHPOINT_ENABLED = "org.eclipse.jdt.debug.ui.write_obj.gif";
    public static final String IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED = "org.eclipse.jdt.debug.ui.write_obj_disabled.gif";
    public static final String IMG_OBJS_WATCHPOINT_ENABLED = "org.eclipse.jdt.debug.ui.readwrite_obj.gif";
    public static final String IMG_OBJS_WATCHPOINT_DISABLED = "org.eclipse.jdt.debug.ui.readwrite_obj_disabled.gif";
    public static final String IMG_OBJS_LOCAL_VARIABLE = "org.eclipse.jdt.debug.ui.localvariable_obj.gif";
    public static final String IMG_OBJS_METHOD_BREAKPOINT_ENTRY = "org.eclipse.jdt.debug.ui.entry_ovr.gif";
    public static final String IMG_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED = "org.eclipse.jdt.debug.ui.entry_ovr_disabled.gif";
    public static final String IMG_OBJS_METHOD_BREAKPOINT_EXIT = "org.eclipse.jdt.debug.ui.exit_ovr.gif";
    public static final String IMG_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED = "org.eclipse.jdt.debug.ui.exit_ovr_disabled.gif";
    public static final String IMG_OBJS_CONDITIONAL_BREAKPOINT = "org.eclipse.jdt.debug.ui.conditional_ovr.gif";
    public static final String IMG_OBJS_CONDITIONAL_BREAKPOINT_DISABLED = "org.eclipse.jdt.debug.ui.conditional_ovr_disabled.gif";
    public static final String IMG_OBJS_SCOPED_BREAKPOINT = "org.eclipse.jdt.debug.ui.scoped_ovr.gif";
    public static final String IMG_OBJS_SCOPED_BREAKPOINT_DISABLED = "org.eclipse.jdt.debug.ui.scoped_ovr_disabled.gif";
    public static final String IMG_OBJS_UNCAUGHT_BREAKPOINT = "org.eclipse.jdt.debug.ui.uncaught_ovr.gif";
    public static final String IMG_OBJS_UNCAUGHT_BREAKPOINT_DISABLED = "org.eclipse.jdt.debug.ui.uncaught_ovr_disabled.gif";
    public static final String IMG_OBJS_CAUGHT_BREAKPOINT = "org.eclipse.jdt.debug.ui.caught_ovr.gif";
    public static final String IMG_OBJS_CAUGHT_BREAKPOINT_DISABLED = "org.eclipse.jdt.debug.ui.caught_ovr_disabled.gif";
    public static final String IMG_OBJS_SNIPPET_EVALUATING = "org.eclipse.jdt.debug.ui.jsbook_run_obj.gif";
    public static final String IMG_VIEW_ARGUMENTS_TAB = "org.eclipse.jdt.debug.ui.variable_tab.gif";
    public static final String IMG_OBJS_MONITOR = "org.eclipse.jdt.debug.ui.monitor_obj.gif";
    public static final String IMG_OBJS_PLUS_SIGN = "org.eclipse.jdt.debug.ui.plus_sign.gif";
    public static final String IMG_OBJS_MINUS_SIGN = "org.eclipse.jdt.debug.ui.minus_sign.gif";
    private static final String T_OBJ = "obj16";
    private static final String T_OVR = "ovr16";
    private static final String T_WIZBAN = "wizban";
    private static final String T_CTOOL = "ctool16";
    private static final String T_CVIEW = "cview16";
    private static final String T_DTOOL = "dtool16";
    private static final String T_ETOOL = "etool16";
    public static final ImageDescriptor DESC_OBJS_EXCEPTION;
    public static final ImageDescriptor DESC_OBJS_EXCEPTION_DISABLED;
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT_INSTALLED;
    public static final ImageDescriptor DESC_OBJS_BREAKPOINT_INSTALLED_DISABLED;
    public static final ImageDescriptor DESC_OBJS_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_ACCESS_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_ACCESS_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_MODIFICATION_WATCHPOINT_ENABLED;
    public static final ImageDescriptor DESC_OBJS_MODIFICATION_WATCHPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_LOCAL_VARIABLE;
    public static final ImageDescriptor DESC_OBJS_METHOD_BREAKPOINT_ENTRY;
    public static final ImageDescriptor DESC_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED;
    public static final ImageDescriptor DESC_OBJS_METHOD_BREAKPOINT_EXIT;
    public static final ImageDescriptor DESC_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_CONDITIONAL_BREAKPOINT;
    public static final ImageDescriptor DESC_OBJS_CONDITIONAL_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_SCOPED_BREAKPOINT;
    public static final ImageDescriptor DESC_OBJS_SCOPED_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_UNCAUGHT_BREAKPOINT;
    public static final ImageDescriptor DESC_OBJS_UNCAUGHT_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_CAUGHT_BREAKPOINT;
    public static final ImageDescriptor DESC_OBJS_CAUGHT_BREAKPOINT_DISABLED;
    public static final ImageDescriptor DESC_OBJS_ERROR;
    public static final ImageDescriptor DESC_OBJS_SNIPPET_EVALUATING;
    public static final ImageDescriptor DESC_VIEW_ARGUMENTS_TAB;
    public static final ImageDescriptor DESC_OBJ_MONITOR;
    public static final ImageDescriptor DESC_OVR_IS_OUT_OF_SYNCH;
    public static final ImageDescriptor DESC_OVR_MAY_BE_OUT_OF_SYNCH;
    public static final ImageDescriptor DESC_OVR_OWNED;
    public static final ImageDescriptor DESC_OVR_OWNS_MONITOR;
    public static final ImageDescriptor DESC_OVR_IN_CONTENTION;
    public static final ImageDescriptor DESC_OVR_IN_CONTENTION_FOR_MONITOR;
    public static final ImageDescriptor DESC_WIZBAN_NEWSCRAPPAGE;
    public static final ImageDescriptor DESC_WIZBAN_JAVA_LAUNCH;
    public static final ImageDescriptor DESC_WIZBAN_JAVA_ATTACH;
    public static final ImageDescriptor DESC_WIZBAN_LIBRARY;
    public static final ImageDescriptor DESC_TOOL_RUNSNIPPET;
    public static final ImageDescriptor DESC_TOOL_RUNSNIPPET_HOVER;
    public static final ImageDescriptor DESC_TOOL_RUNSNIPPET_DISABLED;
    public static final ImageDescriptor DESC_TOOL_TERMSNIPPET;
    public static final ImageDescriptor DESC_TOOL_TERMSNIPPET_HOVER;
    public static final ImageDescriptor DESC_TOOL_TERMSNIPPET_DISABLED;
    public static final ImageDescriptor DESC_OBJS_PLUS_SIGN;
    public static final ImageDescriptor DESC_OBJS_MINUS_SIGN;
    public static final ImageDescriptor DESC_OBJ_JAVA_INSPECT_EXPRESSION;

    static {
        String pathSuffix = "icons/full/";
        try {
            fgIconBaseURL = new URL(JDIDebugUIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException e) {
            JDIDebugUIPlugin.log(e);
        }
        fgImageRegistry = null;
        fgAvoidSWTErrorMap = null;
        DESC_OBJS_EXCEPTION = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_EXCEPTION);
        DESC_OBJS_EXCEPTION_DISABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_EXCEPTION_DISABLED);
        DESC_OBJS_BREAKPOINT_INSTALLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_BREAKPOINT_INSTALLED);
        DESC_OBJS_BREAKPOINT_INSTALLED_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_BREAKPOINT_INSTALLED_DISABLED);
        DESC_OBJS_WATCHPOINT_ENABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_WATCHPOINT_ENABLED);
        DESC_OBJS_WATCHPOINT_DISABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_WATCHPOINT_DISABLED);
        DESC_OBJS_ACCESS_WATCHPOINT_ENABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_ACCESS_WATCHPOINT_ENABLED);
        DESC_OBJS_ACCESS_WATCHPOINT_DISABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_ACCESS_WATCHPOINT_DISABLED);
        DESC_OBJS_MODIFICATION_WATCHPOINT_ENABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_MODIFICATION_WATCHPOINT_ENABLED);
        DESC_OBJS_MODIFICATION_WATCHPOINT_DISABLED = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED);
        DESC_OBJS_LOCAL_VARIABLE = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_LOCAL_VARIABLE);
        DESC_OBJS_METHOD_BREAKPOINT_ENTRY = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_METHOD_BREAKPOINT_ENTRY);
        DESC_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_METHOD_BREAKPOINT_ENTRY_DISABLED);
        DESC_OBJS_METHOD_BREAKPOINT_EXIT = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_METHOD_BREAKPOINT_EXIT);
        DESC_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_METHOD_BREAKPOINT_EXIT_DISABLED);
        DESC_OBJS_CONDITIONAL_BREAKPOINT = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_CONDITIONAL_BREAKPOINT);
        DESC_OBJS_CONDITIONAL_BREAKPOINT_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_CONDITIONAL_BREAKPOINT_DISABLED);
        DESC_OBJS_SCOPED_BREAKPOINT = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_SCOPED_BREAKPOINT);
        DESC_OBJS_SCOPED_BREAKPOINT_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_SCOPED_BREAKPOINT_DISABLED);
        DESC_OBJS_UNCAUGHT_BREAKPOINT = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_UNCAUGHT_BREAKPOINT);
        DESC_OBJS_UNCAUGHT_BREAKPOINT_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_UNCAUGHT_BREAKPOINT_DISABLED);
        DESC_OBJS_CAUGHT_BREAKPOINT = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_CAUGHT_BREAKPOINT);
        DESC_OBJS_CAUGHT_BREAKPOINT_DISABLED = JavaDebugImages.createManaged(T_OVR, IMG_OBJS_CAUGHT_BREAKPOINT_DISABLED);
        DESC_OBJS_ERROR = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_ERROR);
        DESC_OBJS_SNIPPET_EVALUATING = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_SNIPPET_EVALUATING);
        DESC_VIEW_ARGUMENTS_TAB = JavaDebugImages.createManaged(T_CVIEW, IMG_VIEW_ARGUMENTS_TAB);
        DESC_OBJ_MONITOR = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_MONITOR);
        DESC_OVR_IS_OUT_OF_SYNCH = JavaDebugImages.create(T_OVR, "error_co.gif");
        DESC_OVR_MAY_BE_OUT_OF_SYNCH = JavaDebugImages.create(T_OVR, "warning_co.gif");
        DESC_OVR_OWNED = JavaDebugImages.create(T_OVR, "owned_ovr.gif");
        DESC_OVR_OWNS_MONITOR = JavaDebugImages.create(T_OVR, "ownsmonitor_ovr.gif");
        DESC_OVR_IN_CONTENTION = JavaDebugImages.create(T_OVR, "contention_ovr.gif");
        DESC_OVR_IN_CONTENTION_FOR_MONITOR = JavaDebugImages.create(T_OVR, "contentionformonitor_ovr.gif");
        DESC_WIZBAN_NEWSCRAPPAGE = JavaDebugImages.create(T_WIZBAN, "newsbook_wiz.gif");
        DESC_WIZBAN_JAVA_LAUNCH = JavaDebugImages.create(T_WIZBAN, "java_app_wiz.gif");
        DESC_WIZBAN_JAVA_ATTACH = JavaDebugImages.create(T_WIZBAN, "java_attach_wiz.gif");
        DESC_WIZBAN_LIBRARY = JavaDebugImages.create(T_WIZBAN, "library_wiz.gif");
        DESC_TOOL_RUNSNIPPET = JavaDebugImages.create(T_ETOOL, "run_sbook.gif");
        DESC_TOOL_RUNSNIPPET_HOVER = JavaDebugImages.create(T_CTOOL, "run_sbook.gif");
        DESC_TOOL_RUNSNIPPET_DISABLED = JavaDebugImages.create(T_DTOOL, "run_sbook.gif");
        DESC_TOOL_TERMSNIPPET = JavaDebugImages.create(T_ETOOL, "term_sbook.gif");
        DESC_TOOL_TERMSNIPPET_HOVER = JavaDebugImages.create(T_CTOOL, "term_sbook.gif");
        DESC_TOOL_TERMSNIPPET_DISABLED = JavaDebugImages.create(T_DTOOL, "term_sbook.gif");
        DESC_OBJS_PLUS_SIGN = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_PLUS_SIGN);
        DESC_OBJS_MINUS_SIGN = JavaDebugImages.createManaged(T_OBJ, IMG_OBJS_MINUS_SIGN);
        DESC_OBJ_JAVA_INSPECT_EXPRESSION = JavaDebugImages.create(T_OBJ, "insp_sbook.gif");
    }

    public static Image get(String key) {
        return JavaDebugImages.getImageRegistry().get(key);
    }

    public static void setToolImageDescriptors(IAction action, String iconName) {
        JavaDebugImages.setImageDescriptors(action, "tool16", iconName);
    }

    public static void setLocalImageDescriptors(IAction action, String iconName) {
        JavaDebugImages.setImageDescriptors(action, "lcl16", iconName);
    }

    static ImageRegistry getImageRegistry() {
        if (fgImageRegistry == null) {
            fgImageRegistry = new ImageRegistry();
            Iterator iter = fgAvoidSWTErrorMap.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                fgImageRegistry.put(key, (ImageDescriptor)fgAvoidSWTErrorMap.get(key));
            }
            fgAvoidSWTErrorMap = null;
        }
        return fgImageRegistry;
    }

    private static void setImageDescriptors(IAction action, String type, String relPath) {
        ImageDescriptor id;
        try {
            id = ImageDescriptor.createFromURL((URL)JavaDebugImages.makeIconFileURL("d" + type, relPath));
            if (id != null) {
                action.setDisabledImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            JDIDebugUIPlugin.log(e);
        }
        try {
            id = ImageDescriptor.createFromURL((URL)JavaDebugImages.makeIconFileURL("c" + type, relPath));
            if (id != null) {
                action.setHoverImageDescriptor(id);
            }
        }
        catch (MalformedURLException e) {
            JDIDebugUIPlugin.log(e);
        }
        action.setImageDescriptor(JavaDebugImages.create("e" + type, relPath));
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)JavaDebugImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (fgAvoidSWTErrorMap == null) {
                fgAvoidSWTErrorMap = new HashMap();
            }
            fgAvoidSWTErrorMap.put(name, result);
            if (fgImageRegistry != null) {
                JDIDebugUIPlugin.logErrorMessage("Internal Error: Image registry already defined");
            }
            return result;
        }
        catch (MalformedURLException e) {
            JDIDebugUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static ImageDescriptor create(String prefix, String name) {
        try {
            return ImageDescriptor.createFromURL((URL)JavaDebugImages.makeIconFileURL(prefix, name));
        }
        catch (MalformedURLException e) {
            JDIDebugUIPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (fgIconBaseURL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/');
        buffer.append(name);
        return new URL(fgIconBaseURL, buffer.toString());
    }
}

