/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchResultCollector;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterCompletionProcessor;
import org.eclipse.jdt.internal.debug.ui.ExceptionHandler;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDISourceViewer;
import org.eclipse.jdt.internal.debug.ui.display.DisplayViewerConfiguration;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.text.JavaTextTools;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class DetailFormatterDialog
extends StatusDialog {
    private DetailFormatter fDetailFormatter;
    private Text fTypeNameText;
    private JDISourceViewer fSnippetViewer;
    private Button fCheckBox;
    private boolean fTypeSearched;
    private boolean fEditTypeName;
    private IType fType;
    private List fDefinedTypes;

    public DetailFormatterDialog(Shell parent, DetailFormatter detailFormatter, List definedTypes, boolean editDialog) {
        this(parent, detailFormatter, definedTypes, true, editDialog);
    }

    public DetailFormatterDialog(Shell parent, DetailFormatter detailFormatter, List definedTypes, boolean editTypeName, boolean editDialog) {
        super(parent);
        this.fDetailFormatter = detailFormatter;
        this.fTypeSearched = false;
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        if (editDialog) {
            this.setTitle(DebugUIMessages.getString("DetailFormatterDialog.Edit_Detail_Formatter_1"));
        } else {
            this.setTitle(DebugUIMessages.getString("DetailFormatterDialog.Add_Detail_Formatter_2"));
        }
        this.fEditTypeName = editTypeName;
        this.fDefinedTypes = definedTypes;
    }

    protected Control createDialogArea(Composite parent) {
        WorkbenchHelp.setHelp((Control)parent, (String)IJavaDebugHelpContextIds.EDIT_DETAIL_FORMATTER_DIALOG);
        Font font = parent.getFont();
        Composite container = (Composite)super.createDialogArea(parent);
        Label label = new Label(container, 0);
        label.setText(DebugUIMessages.getString("DetailFormatterDialog.Qualified_type_&name__2"));
        GridData gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        Composite innerContainer = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        innerContainer.setLayout((Layout)layout);
        gd = new GridData(768);
        innerContainer.setLayoutData((Object)gd);
        this.fTypeNameText = new Text(innerContainer, 2052);
        this.fTypeNameText.setEditable(this.fEditTypeName);
        this.fTypeNameText.setText(this.fDetailFormatter.getTypeName());
        gd = new GridData(768);
        this.fTypeNameText.setLayoutData((Object)gd);
        this.fTypeNameText.setFont(font);
        this.fTypeNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DetailFormatterDialog.this.fTypeSearched = false;
                DetailFormatterDialog.this.checkValues();
            }
        });
        Button typeSearchButton = new Button(innerContainer, 8);
        typeSearchButton.setText(DebugUIMessages.getString("DetailFormatterDialog.Select_&type_4"));
        this.setButtonLayoutData(typeSearchButton);
        gd = (GridData)typeSearchButton.getLayoutData();
        gd.horizontalAlignment = 3;
        typeSearchButton.setLayoutData((Object)gd);
        typeSearchButton.setFont(font);
        typeSearchButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                DetailFormatterDialog.this.selectType();
            }
        });
        label = new Label(container, 0);
        label.setText(DebugUIMessages.getString("DetailFormatterDialog.Detail_formatter_&code_snippet__1"));
        gd = new GridData(1);
        label.setLayoutData((Object)gd);
        label.setFont(font);
        this.fSnippetViewer = new JDISourceViewer(container, null, 2816);
        this.fSnippetViewer.setInput((Object)this);
        JavaTextTools tools = JavaPlugin.getDefault().getJavaTextTools();
        Document document = new Document();
        IDocumentPartitioner partitioner = tools.createDocumentPartitioner();
        document.setDocumentPartitioner(partitioner);
        partitioner.connect((IDocument)document);
        this.fSnippetViewer.configure((SourceViewerConfiguration)new DisplayViewerConfiguration(){

            public IContentAssistProcessor getContentAssistantProcessor() {
                return new DetailFormatterCompletionProcessor(DetailFormatterDialog.this);
            }
        });
        this.fSnippetViewer.setEditable(true);
        this.fSnippetViewer.setDocument((IDocument)document);
        Control control = this.fSnippetViewer.getControl();
        gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(10);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        control.setLayoutData((Object)gd);
        document.set(this.fDetailFormatter.getSnippet());
        this.fSnippetViewer.getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                if (event.stateMask == 262144 && event.keyCode == 32) {
                    DetailFormatterDialog.this.findCorrespondingType();
                    DetailFormatterDialog.this.fSnippetViewer.doOperation(13);
                    event.doit = false;
                }
            }
        });
        this.fSnippetViewer.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent event) {
            }

            public void documentChanged(DocumentEvent event) {
                DetailFormatterDialog.this.checkValues();
            }
        });
        this.fCheckBox = new Button(container, 16416);
        this.fCheckBox.setText(DebugUIMessages.getString("DetailFormatterDialog.&Enable_1"));
        this.fCheckBox.setSelection(this.fDetailFormatter.isEnabled());
        this.fCheckBox.setFont(font);
        this.checkValues();
        return container;
    }

    private void checkValues() {
        StatusInfo status = new StatusInfo();
        String typeName = this.fTypeNameText.getText().trim();
        if (typeName.length() == 0) {
            status.setError(DebugUIMessages.getString("DetailFormatterDialog.Qualified_type_name_must_not_be_empty._3"));
        } else if (this.fDefinedTypes != null && this.fDefinedTypes.contains(typeName)) {
            status.setError(DebugUIMessages.getString("DetailFormatterDialog.A_detail_formatter_is_already_defined_for_this_type_2"));
        } else if (this.fSnippetViewer.getDocument().get().trim().length() == 0) {
            status.setError(DebugUIMessages.getString("DetailFormatterDialog.Associated_code_must_not_be_empty_3"));
        } else if (this.fType == null && this.fTypeSearched) {
            status.setWarning(DebugUIMessages.getString("No_type_with_the_given_name_found_in_the_workspace._1"));
        }
        this.updateStatus((IStatus)status);
    }

    protected void okPressed() {
        this.fDetailFormatter.setEnabled(this.fCheckBox.getSelection());
        this.fDetailFormatter.setTypeName(this.fTypeNameText.getText().trim());
        this.fDetailFormatter.setSnippet(this.fSnippetViewer.getDocument().get());
        super.okPressed();
    }

    private void selectType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)new ProgressMonitorDialog(shell), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = DebugUIMessages.getString("DetailFormatterDialog.Select_type_6");
            String message = DebugUIMessages.getString("DetailFormatterDialog.Could_not_open_type_selection_dialog_for_detail_formatters_7");
            ExceptionHandler.handle((CoreException)((Object)jme), title, message);
            return;
        }
        dialog.setTitle(DebugUIMessages.getString("DetailFormatterDialog.Select_type_8"));
        dialog.setMessage(DebugUIMessages.getString("DetailFormatterDialog.Select_a_type_to_format_when_displaying_its_detail_9"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            this.fType = (IType)types[0];
            this.fTypeNameText.setText(this.fType.getFullyQualifiedName());
        }
    }

    private void findCorrespondingType() {
        if (this.fTypeSearched) {
            return;
        }
        this.fType = null;
        this.fTypeSearched = true;
        String pattern = this.fTypeNameText.getText().trim();
        if (pattern == null || "".equals(pattern)) {
            return;
        }
        IJavaSearchResultCollector collector = new IJavaSearchResultCollector(){
            private boolean fFirst = true;

            public void aboutToStart() {
            }

            public void accept(IResource resource, int start, int end, IJavaElement enclosingElement, int accuracy) {
                if (!this.fFirst) {
                    return;
                }
                this.fFirst = false;
                if (enclosingElement instanceof IType) {
                    DetailFormatterDialog.this.fType = (IType)enclosingElement;
                }
            }

            public void done() {
                DetailFormatterDialog.this.checkValues();
            }

            public IProgressMonitor getProgressMonitor() {
                return null;
            }
        };
        IWorkingCopy[] workingCopies = JavaUI.getSharedWorkingCopies();
        ArrayList<IWorkingCopy> compilationUnits = new ArrayList<IWorkingCopy>(workingCopies.length);
        int i = 0;
        while (i < workingCopies.length) {
            IWorkingCopy copy = workingCopies[i];
            if (copy instanceof ICompilationUnit) {
                compilationUnits.add(copy);
            }
            ++i;
        }
        SearchEngine engine = new SearchEngine(compilationUnits.toArray(new ICompilationUnit[compilationUnits.size()]));
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        try {
            engine.search(JavaPlugin.getWorkspace(), SearchEngine.createSearchPattern((String)pattern, (int)0, (int)0, (boolean)true), scope, collector);
        }
        catch (JavaModelException javaModelException) {}
    }

    public IType getType() {
        if (!this.fTypeSearched) {
            this.findCorrespondingType();
        }
        return this.fType;
    }

    public boolean close() {
        this.fSnippetViewer.dispose();
        return super.close();
    }
}

