/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.jres.DefaultJREDescriptor;
import org.eclipse.jdt.internal.debug.ui.jres.JREsComboBlock;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaJRETab
extends JavaLaunchConfigurationTab {
    protected JREsComboBlock fJREBlock;
    protected String fUnknownVMType;
    protected String fUnknownVMName;
    protected boolean fOkToClearUnknownVM = true;
    protected ILaunchConfigurationTab fDynamicTab;
    protected Composite fDynamicTabHolder;
    protected boolean fUseDynamicArea = true;
    protected ILaunchConfigurationWorkingCopy fWorkingCopy;
    protected ILaunchConfiguration fLaunchConfiguration;
    protected boolean fIsInitializing = false;
    private ISelectionChangedListener fCheckListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            JavaJRETab.this.handleSelectedJREChanged();
        }
    };
    protected static final String EMPTY_STRING = "";

    public void dispose() {
        super.dispose();
        if (this.fJREBlock != null) {
            this.fJREBlock.removeSelectionChangedListener(this.fCheckListener);
        }
    }

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite topComp = new Composite(parent, 0);
        this.setControl((Control)topComp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_JRE_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 1;
        topComp.setLayout((Layout)topLayout);
        GridData gd = new GridData(768);
        topComp.setLayoutData((Object)gd);
        topComp.setFont(font);
        this.createVerticalSpacer(topComp, 1);
        this.fJREBlock = new JREsComboBlock();
        this.fJREBlock.setDefaultJREDescriptor(this.getDefaultJREDescriptor());
        this.fJREBlock.createControl(topComp);
        Control control = this.fJREBlock.getControl();
        this.fJREBlock.addSelectionChangedListener(this.fCheckListener);
        gd = new GridData(768);
        control.setLayoutData((Object)gd);
        Composite dynTabComp = new Composite(topComp, 0);
        dynTabComp.setFont(font);
        this.setDynamicTabHolder(dynTabComp);
        GridLayout tabHolderLayout = new GridLayout();
        tabHolderLayout.marginHeight = 0;
        tabHolderLayout.marginWidth = 0;
        tabHolderLayout.numColumns = 1;
        this.getDynamicTabHolder().setLayout((Layout)tabHolderLayout);
        gd = new GridData(1808);
        this.getDynamicTabHolder().setLayoutData((Object)gd);
    }

    protected void setDynamicTabHolder(Composite tabHolder) {
        this.fDynamicTabHolder = tabHolder;
    }

    protected Composite getDynamicTabHolder() {
        return this.fDynamicTabHolder;
    }

    protected void setDynamicTab(ILaunchConfigurationTab tab) {
        this.fDynamicTab = tab;
    }

    protected ILaunchConfigurationTab getDynamicTab() {
        return this.fDynamicTab;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        this.setLaunchConfigurationWorkingCopy(config);
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.setDefaults(config);
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fIsInitializing = true;
        this.getControl().setRedraw(false);
        this.fOkToClearUnknownVM = false;
        if (this.getLaunchConfiguration() != null && !configuration.equals(this.getLaunchConfiguration())) {
            this.fUnknownVMName = null;
            this.fUnknownVMType = null;
        }
        this.setLaunchConfiguration(configuration);
        this.updateJREFromConfig(configuration);
        this.fJREBlock.setDefaultJREDescriptor(this.getDefaultJREDescriptor());
        ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
        if (dynamicTab != null) {
            dynamicTab.initializeFrom(configuration);
        }
        this.fOkToClearUnknownVM = true;
        this.getControl().setRedraw(true);
        this.fIsInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.fUnknownVMName == null) {
            IVMInstall vm = null;
            boolean vmExists = true;
            if (!this.fJREBlock.isDefaultJRE()) {
                vm = this.fJREBlock.getJRE();
                boolean bl = vmExists = vm != null;
            }
            if (vmExists) {
                String vmName = null;
                String vmTypeID = null;
                if (vm != null) {
                    vmName = vm.getName();
                    vmTypeID = vm.getVMInstallType().getId();
                }
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmName);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmTypeID);
                ILaunchConfigurationTab dynamicTab = this.getDynamicTab();
                if (dynamicTab == null) {
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
                } else {
                    dynamicTab.performApply(configuration);
                }
            }
        }
    }

    public boolean isValid(ILaunchConfiguration config) {
        ILaunchConfigurationTab dynamicTab;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.fUnknownVMName != null) {
            this.setErrorMessage(MessageFormat.format(LauncherMessages.getString("JavaJRETab.Configuration_specifies_undefined_JRE_-_{0}_1"), this.fUnknownVMName));
            return false;
        }
        IVMInstall vm = this.fJREBlock.getJRE();
        if (vm == null) {
            if (!this.fJREBlock.isDefaultJRE()) {
                this.setErrorMessage(LauncherMessages.getString("JavaJRETab.JRE_not_specified_38"));
                return false;
            }
        } else {
            File location = vm.getInstallLocation();
            if (location == null) {
                this.setErrorMessage(LauncherMessages.getString("JavaJRETab.JRE_home_directory_not_specified_36"));
                return false;
            }
            if (!location.exists()) {
                this.setErrorMessage(LauncherMessages.getString("JavaJRETab.JRE_home_directory_does_not_exist_37"));
                return false;
            }
        }
        if ((dynamicTab = this.getDynamicTab()) != null) {
            return dynamicTab.isValid(config);
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.getString("JavaJRETab.&JRE_1");
    }

    public Image getImage() {
        return JavaPluginImages.get((String)"org.eclipse.jdt.ui.library_obj.gif");
    }

    protected void updateJREFromConfig(ILaunchConfiguration config) {
        String vmName = null;
        String vmTypeID = null;
        try {
            vmTypeID = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
            vmName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.selectJRE(vmTypeID, vmName);
    }

    protected void handleSelectedJREChanged() {
        if (this.fOkToClearUnknownVM) {
            this.fUnknownVMName = null;
            this.fUnknownVMType = null;
        }
        this.loadDynamicJREArea();
        ILaunchConfigurationWorkingCopy wc = this.getLaunchConfigurationWorkingCopy();
        if (this.getDynamicTab() == null) {
            if (wc == null && this.getLaunchConfiguration().isWorkingCopy()) {
                wc = (ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration();
            }
            if (!this.fIsInitializing && wc != null) {
                wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE_SPECIFIC_ATTRS_MAP, null);
            }
        } else {
            if (wc == null) {
                try {
                    wc = this.getLaunchConfiguration().isWorkingCopy() ? ((ILaunchConfigurationWorkingCopy)this.getLaunchConfiguration()).getOriginal().getWorkingCopy() : this.getLaunchConfiguration().getWorkingCopy();
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JavaJRETab.Unable_to_initialize_defaults_for_selected_JRE_1"), e);
                    return;
                }
            }
            if (!this.fIsInitializing) {
                this.getDynamicTab().setDefaults(wc);
                this.getDynamicTab().initializeFrom((ILaunchConfiguration)wc);
            }
        }
        this.updateLaunchConfigurationDialog();
    }

    protected void selectJRE(String typeID, String vmName) {
        if (typeID == null) {
            this.fJREBlock.setUseDefaultJRE();
        } else {
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstallType type = types[i];
                if (type.getId().equals(typeID)) {
                    IVMInstall[] installs = type.getVMInstalls();
                    int j = 0;
                    while (j < installs.length) {
                        IVMInstall install = installs[j];
                        if (install.getName().equals(vmName)) {
                            this.fJREBlock.setJRE(install);
                            return;
                        }
                        ++j;
                    }
                    break;
                }
                ++i;
            }
            this.fUnknownVMName = vmName;
            this.fJREBlock.setJRE(null);
        }
    }

    protected ILaunchConfigurationTab getTabForCurrentJRE() {
        IVMInstall vm;
        if (!this.fJREBlock.isDefaultJRE() && (vm = this.fJREBlock.getJRE()) != null) {
            String vmInstallTypeID = vm.getVMInstallType().getId();
            return JDIDebugUIPlugin.getDefault().getVMInstallTypePage(vmInstallTypeID);
        }
        return null;
    }

    protected void loadDynamicJREArea() {
        Control[] children = this.getDynamicTabHolder().getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        if (this.isUseDynamicJREArea()) {
            this.setDynamicTab(this.getTabForCurrentJRE());
            if (this.getDynamicTab() == null) {
                return;
            }
            this.getDynamicTab().setLaunchConfigurationDialog(this.getLaunchConfigurationDialog());
            this.getDynamicTab().createControl(this.getDynamicTabHolder());
            this.getDynamicTabHolder().layout();
        }
    }

    protected ILaunchConfigurationWorkingCopy getLaunchConfigurationWorkingCopy() {
        return this.fWorkingCopy;
    }

    public String getErrorMessage() {
        ILaunchConfigurationTab tab = this.getDynamicTab();
        if (super.getErrorMessage() != null || tab == null) {
            return super.getErrorMessage();
        }
        return tab.getErrorMessage();
    }

    protected void setLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fWorkingCopy = workingCopy;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration launchConfiguration) {
        this.fLaunchConfiguration = launchConfiguration;
    }

    public void setVMSpecificArgumentsVisible(boolean visible) {
        this.fUseDynamicArea = visible;
    }

    protected boolean isUseDynamicJREArea() {
        return this.fUseDynamicArea;
    }

    protected DefaultJREDescriptor getDefaultJREDescriptor() {
        return new DefaultJREDescriptor(){

            public String getDescription() {
                IJavaProject project = JavaJRETab.this.getJavaProject();
                String name = LauncherMessages.getString("JavaJRETab.7");
                if (project == null) {
                    IVMInstall vm = JavaRuntime.getDefaultVMInstall();
                    if (vm != null) {
                        name = vm.getName();
                    }
                    return MessageFormat.format(LauncherMessages.getString("JavaJRETab.8"), name);
                }
                try {
                    IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)project);
                    if (vm != null) {
                        name = vm.getName();
                    }
                }
                catch (CoreException coreException) {}
                return MessageFormat.format(LauncherMessages.getString("JavaJRETab.9"), name);
            }
        };
    }

    protected IJavaProject getJavaProject() {
        if (this.getLaunchConfiguration() != null) {
            try {
                IProject project;
                String name = this.getLaunchConfiguration().getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
                if (name != null && name.length() > 0 && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(name)).exists()) {
                    return JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.fJREBlock.refresh();
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

