/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import com.sun.jdi.connect.Connector;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.ComboFieldEditor;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMConnector;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaConnectTab
extends JavaLaunchConfigurationTab
implements IPropertyChangeListener {
    protected Label fProjLabel;
    protected Text fProjText;
    protected Button fProjButton;
    protected Button fAllowTerminateButton;
    protected Map fArgumentMap;
    protected Map fFieldEditorMap = new HashMap();
    protected Composite fArgumentComposite;
    protected IVMConnector fConnector;
    protected Combo fConnectorCombo;
    protected IVMConnector[] fConnectors = JavaRuntime.getVMConnectors();
    protected static final String EMPTY_STRING = "";

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CONNECT_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.marginHeight = 0;
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp, 1);
        Composite projComp = new Composite(comp, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 2;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LauncherMessages.getString("JavaConnectTab.&Project__2"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjLabel.setFont(font);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                JavaConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, LauncherMessages.getString("JavaConnectTab.&Browse_3"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaConnectTab.this.handleProjectButtonSelected();
            }
        });
        Composite connectorComp = new Composite(comp, 0);
        GridLayout y = new GridLayout();
        y.numColumns = 2;
        y.marginHeight = 0;
        y.marginWidth = 0;
        connectorComp.setLayout((Layout)y);
        gd = new GridData(768);
        connectorComp.setLayoutData((Object)gd);
        Label l = new Label(connectorComp, 0);
        l.setText(LauncherMessages.getString("JavaConnectTab.Connect&ion_Type__7"));
        gd = new GridData(1);
        gd.horizontalSpan = 2;
        l.setLayoutData((Object)gd);
        l.setFont(font);
        this.fConnectorCombo = new Combo(connectorComp, 8);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fConnectorCombo.setLayoutData((Object)gd);
        this.fConnectorCombo.setFont(font);
        String[] names = new String[this.fConnectors.length];
        int i = 0;
        while (i < this.fConnectors.length) {
            names[i] = this.fConnectors[i].getName();
            ++i;
        }
        this.fConnectorCombo.setItems(names);
        this.fConnectorCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaConnectTab.this.handleConnectorComboModified();
            }
        });
        this.createVerticalSpacer(comp, 2);
        Group group = new Group(comp, 0);
        group.setText(LauncherMessages.getString("JavaConnectTab.Connection_Properties_1"));
        group.setLayout((Layout)new GridLayout());
        group.setFont(font);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        group.setLayoutData((Object)gd);
        Composite spacingComposite = new Composite((Composite)group, 0);
        y = new GridLayout();
        spacingComposite.setLayout((Layout)y);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        spacingComposite.setLayoutData((Object)gd);
        this.fArgumentComposite = spacingComposite;
        this.fArgumentComposite.setFont(font);
        this.createVerticalSpacer(comp, 2);
        this.fAllowTerminateButton = new Button(comp, 32);
        this.fAllowTerminateButton.setText(LauncherMessages.getString("JavaConnectTab.&Allow_termination_of_remote_VM_6"));
        this.fAllowTerminateButton.setFont(font);
        this.fAllowTerminateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                JavaConnectTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    protected void handleConnectorComboModified() {
        int index = this.fConnectorCombo.getSelectionIndex();
        if (index < 0 || index >= this.fConnectors.length) {
            return;
        }
        IVMConnector vm = this.fConnectors[index];
        if (vm.equals(this.fConnector)) {
            return;
        }
        this.fConnector = vm;
        try {
            this.fArgumentMap = vm.getDefaultArguments();
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JavaConnectTab.Unable_to_display_connection_arguments._2"), e.getStatus());
            return;
        }
        Control[] children = this.fArgumentComposite.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].dispose();
            ++i;
        }
        this.fFieldEditorMap.clear();
        PreferenceStore store = new PreferenceStore();
        Iterator keys = vm.getArgumentOrder().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
            Object field = null;
            if (arg instanceof Connector.IntegerArgument) {
                store.setDefault(arg.name(), ((Connector.IntegerArgument)arg).intValue());
                field = new IntegerFieldEditor(arg.name(), this.getLabel(arg.label()), this.fArgumentComposite);
            } else if (arg instanceof Connector.SelectedArgument) {
                List<String> choices = ((Connector.SelectedArgument)arg).choices();
                String[][] namesAndValues = new String[choices.size()][2];
                Iterator<String> iter = choices.iterator();
                int count = 0;
                while (iter.hasNext()) {
                    String choice;
                    namesAndValues[count][0] = choice = iter.next();
                    namesAndValues[count][1] = choice;
                    ++count;
                }
                store.setDefault(arg.name(), arg.value());
                field = new ComboFieldEditor(arg.name(), this.getLabel(arg.label()), namesAndValues, this.fArgumentComposite);
            } else if (arg instanceof Connector.StringArgument) {
                store.setDefault(arg.name(), arg.value());
                field = new StringFieldEditor(arg.name(), this.getLabel(arg.label()), this.fArgumentComposite);
            } else if (arg instanceof Connector.BooleanArgument) {
                store.setDefault(arg.name(), ((Connector.BooleanArgument)arg).booleanValue());
                field = new BooleanFieldEditor(arg.name(), this.getLabel(arg.label()), this.fArgumentComposite);
            }
            field.setPreferenceStore((IPreferenceStore)store);
            field.loadDefault();
            field.setPropertyChangeListener((IPropertyChangeListener)this);
            this.fFieldEditorMap.put(key, field);
        }
        this.fArgumentComposite.getParent().getParent().layout();
        this.fArgumentComposite.layout();
    }

    protected String getLabel(String label) {
        if (!label.endsWith(":")) {
            label = String.valueOf(label) + ":";
        }
        return label;
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateAllowTerminateFromConfig(config);
        this.updateConnectionFromConfig(config);
    }

    protected void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    protected void updateAllowTerminateFromConfig(ILaunchConfiguration config) {
        boolean allowTerminate = false;
        try {
            allowTerminate = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fAllowTerminateButton.setSelection(allowTerminate);
    }

    protected void updateConnectionFromConfig(ILaunchConfiguration config) {
        String id = null;
        try {
            id = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
            this.fConnectorCombo.setText(JavaRuntime.getVMConnector((String)id).getName());
            this.handleConnectorComboModified();
            Map attrMap = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, null);
            if (attrMap == null) {
                return;
            }
            Iterator keys = attrMap.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
                FieldEditor editor = (FieldEditor)this.fFieldEditorMap.get(key);
                if (arg == null || editor == null) continue;
                String value = (String)attrMap.get(key);
                if (arg instanceof Connector.StringArgument || arg instanceof Connector.SelectedArgument) {
                    editor.getPreferenceStore().setValue(key, value);
                } else if (arg instanceof Connector.BooleanArgument) {
                    boolean b = new Boolean(value);
                    editor.getPreferenceStore().setValue(key, b);
                } else if (arg instanceof Connector.IntegerArgument) {
                    int i = new Integer(value);
                    editor.getPreferenceStore().setValue(key, i);
                }
                editor.load();
            }
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public void dispose() {
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText().trim());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, this.fAllowTerminateButton.getSelection());
        IVMConnector vmc = this.getSelectedConnector();
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, vmc.getIdentifier());
        HashMap<String, String> attrMap = new HashMap<String, String>(this.fFieldEditorMap.size());
        Iterator keys = this.fFieldEditorMap.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            FieldEditor editor = (FieldEditor)this.fFieldEditorMap.get(key);
            if (!editor.isValid()) {
                return;
            }
            Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
            editor.store();
            if (arg instanceof Connector.StringArgument || arg instanceof Connector.SelectedArgument) {
                String value = editor.getPreferenceStore().getString(key);
                attrMap.put(key, value);
                continue;
            }
            if (arg instanceof Connector.BooleanArgument) {
                boolean value = editor.getPreferenceStore().getBoolean(key);
                attrMap.put(key, new Boolean(value).toString());
                continue;
            }
            if (!(arg instanceof Connector.IntegerArgument)) continue;
            int value = editor.getPreferenceStore().getInt(key);
            attrMap.put(key, new Integer(value).toString());
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CONNECT_MAP, attrMap);
    }

    protected void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    protected IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LauncherMessages.getString("JavaConnectTab.Project_selection_10"));
        dialog.setMessage(LauncherMessages.getString("JavaConnectTab.Choose_a_project_to_constrain_the_search_for_main_types_11"));
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    protected IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    protected void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeName(javaElement, config);
        this.initializeHardCodedDefaults(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement javaElement = this.getContext();
        if (javaElement == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(javaElement, config);
        }
    }

    protected void initializeName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = EMPTY_STRING;
        try {
            IResource resource = javaElement.getUnderlyingResource();
            if (resource != null) {
                name = resource.getName();
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(0, index);
                }
            } else {
                name = javaElement.getElementName();
            }
            name = this.getLaunchConfigurationDialog().generateName(name);
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log(jme);
        }
        config.rename(name);
    }

    protected void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_ALLOW_TERMINATE, false);
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_CONNECTOR, JavaRuntime.getDefaultVMConnector().getIdentifier());
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.getString("JavaConnectTab.Project_does_not_exist_14"));
            return false;
        }
        Iterator keys = this.fFieldEditorMap.keySet().iterator();
        while (keys.hasNext()) {
            String value;
            String key = (String)keys.next();
            Connector.Argument arg = (Connector.Argument)this.fArgumentMap.get(key);
            FieldEditor editor = (FieldEditor)this.fFieldEditorMap.get(key);
            if (!(editor instanceof StringFieldEditor) || arg.isValid(value = ((StringFieldEditor)editor).getStringValue())) continue;
            this.setErrorMessage(String.valueOf(arg.label()) + LauncherMessages.getString("JavaConnectTab._is_invalid._5"));
            return false;
        }
        return true;
    }

    public String getName() {
        return LauncherMessages.getString("JavaConnectTab.Conn&ect_20");
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_LCL_DISCONNECT");
    }

    protected IVMConnector getSelectedConnector() {
        return this.fConnector;
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.updateLaunchConfigurationDialog();
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

