/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.AddAdvancedAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddExternalJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddFolderAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddJarAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddProjectAction;
import org.eclipse.jdt.internal.debug.ui.actions.AddVariableAction;
import org.eclipse.jdt.internal.debug.ui.actions.AttachSourceAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveDownAction;
import org.eclipse.jdt.internal.debug.ui.actions.MoveUpAction;
import org.eclipse.jdt.internal.debug.ui.actions.RemoveAction;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathModel;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.RuntimeClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaClasspathTab
extends JavaLaunchConfigurationTab {
    protected RuntimeClasspathViewer fClasspathViewer;
    protected static Image fgClasspathImage = null;
    private ClasspathModel model;
    protected static final String DIALOG_SETTINGS_PREFIX = "JavaClasspathTab";
    protected ILaunchConfiguration fLaunchConfiguration;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_CLASSPATH_TAB);
        GridLayout topLayout = new GridLayout();
        topLayout.numColumns = 2;
        comp.setLayout((Layout)topLayout);
        this.fClasspathViewer = new RuntimeClasspathViewer(comp);
        this.fClasspathViewer.addEntriesChangedListener(this);
        this.fClasspathViewer.getControl().setFont(font);
        this.fClasspathViewer.setLabelProvider((IBaseLabelProvider)new ClasspathLabelProvider());
        this.fClasspathViewer.setContentProvider((IContentProvider)new ClasspathContentProvider());
        Composite pathButtonComp = new Composite(comp, 0);
        GridLayout pathButtonLayout = new GridLayout();
        pathButtonLayout.marginHeight = 0;
        pathButtonLayout.marginWidth = 0;
        pathButtonComp.setLayout((Layout)pathButtonLayout);
        GridData gd = new GridData(258);
        pathButtonComp.setLayoutData((Object)gd);
        pathButtonComp.setFont(font);
        this.createVerticalSpacer(pathButtonComp, 1);
        ArrayList<RuntimeClasspathAction> advancedActions = new ArrayList<RuntimeClasspathAction>(5);
        RuntimeClasspathAction action = new MoveUpAction(this.fClasspathViewer);
        Button button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        action = new MoveDownAction(this.fClasspathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        action = new RemoveAction(this.fClasspathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        action = new AddProjectAction(this.fClasspathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        action = new AddJarAction(this.fClasspathViewer);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        action = new AddExternalJarAction(this.fClasspathViewer, DIALOG_SETTINGS_PREFIX);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        action = new AddFolderAction(null);
        advancedActions.add(action);
        action = new AddExternalFolderAction(null, DIALOG_SETTINGS_PREFIX);
        advancedActions.add(action);
        action = new AddVariableAction(null);
        advancedActions.add(action);
        action = new AttachSourceAction(null, 16);
        advancedActions.add(action);
        IAction[] adv = advancedActions.toArray(new IAction[advancedActions.size()]);
        action = new AddAdvancedAction(this.fClasspathViewer, adv);
        button = this.createPushButton(pathButtonComp, action.getText(), null);
        action.setButton(button);
        button = this.createPushButton(pathButtonComp, LauncherMessages.getString("JavaClasspathTab.3"), null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaClasspathTab.this.restoreDefaultEntries();
            }
        });
    }

    private void restoreDefaultEntries() {
        IRuntimeClasspathEntry[] entries = null;
        try {
            ILaunchConfigurationWorkingCopy copy = this.getLaunchConfiguration().getWorkingCopy();
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
            entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)copy);
        }
        catch (CoreException coreException) {
            return;
        }
        ArrayList<IRuntimeClasspathEntry> bootEntries = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int j = 0;
        while (j < entries.length) {
            if (entries[j].getClasspathProperty() != 3) {
                bootEntries.add(entries[j]);
            }
            ++j;
        }
        this.model.setBootstrapEntries(bootEntries.toArray(new IRuntimeClasspathEntry[bootEntries.size()]));
        ArrayList<IRuntimeClasspathEntry> userEntries = new ArrayList<IRuntimeClasspathEntry>(entries.length);
        int j2 = 0;
        while (j2 < entries.length) {
            if (entries[j2].getClasspathProperty() == 3) {
                userEntries.add(entries[j2]);
            }
            ++j2;
        }
        this.model.setUserEntries(userEntries.toArray(new IRuntimeClasspathEntry[userEntries.size()]));
        this.fClasspathViewer.refresh();
        this.entriesChanged(this.fClasspathViewer);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        boolean useDefault = true;
        this.setErrorMessage(null);
        try {
            useDefault = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, true);
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        if (configuration == this.getLaunchConfiguration() && !useDefault) {
            this.setDirty(false);
            return;
        }
        this.setLaunchConfiguration(configuration);
        try {
            this.createClasspathModel(configuration);
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
        this.fClasspathViewer.setLaunchConfiguration(configuration);
        this.fClasspathViewer.setInput(this.model);
        this.setDirty(false);
    }

    private void createClasspathModel(ILaunchConfiguration configuration) throws CoreException {
        this.model = new ClasspathModel();
        IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry entry = entries[i];
            switch (entry.getClasspathProperty()) {
                case 3: {
                    this.model.addEntry(1, entry);
                    break;
                }
                default: {
                    this.model.addEntry(0, entry);
                }
            }
            ++i;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        if (this.isDirty()) {
            boolean def;
            boolean bl = def = !this.hasClasspathChanged(configuration.getOriginal());
            if (def) {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, null);
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, null);
            } else {
                configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
                try {
                    IRuntimeClasspathEntry entry;
                    IClasspathEntry[] boot = this.model.getEntries(0);
                    IClasspathEntry[] user = this.model.getEntries(1);
                    ArrayList<String> mementos = new ArrayList<String>(boot.length + user.length);
                    int i = 0;
                    while (i < boot.length) {
                        IClasspathEntry bootEntry = boot[i];
                        if (bootEntry instanceof IRuntimeClasspathEntry) {
                            entry = (IRuntimeClasspathEntry)boot[i];
                            entry.setClasspathProperty(2);
                            mementos.add(entry.getMemento());
                        }
                        ++i;
                    }
                    int i2 = 0;
                    while (i2 < user.length) {
                        IClasspathEntry userEntry = user[i2];
                        if (userEntry instanceof IRuntimeClasspathEntry) {
                            entry = (IRuntimeClasspathEntry)user[i2];
                            entry.setClasspathProperty(3);
                            mementos.add(entry.getMemento());
                        }
                        ++i2;
                    }
                    configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
                }
                catch (CoreException e) {
                    JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("JavaClasspathTab.Unable_to_save_classpath_1"), e);
                }
            }
        }
    }

    private boolean hasClasspathChanged(ILaunchConfiguration configuration) {
        try {
            IClasspathEntry entry;
            IRuntimeClasspathEntry[] entries = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)configuration);
            IClasspathEntry[] bootEntries = this.model.getEntries(0);
            int i = 0;
            while (i < bootEntries.length) {
                if (i == entries.length) {
                    return true;
                }
                entry = bootEntries[i];
                if (i > entries.length || !entry.equals(entries[i])) {
                    return true;
                }
                ++i;
            }
            IClasspathEntry[] userEntries = this.model.getEntries(1);
            while (i < entries.length) {
                if (i >= userEntries.length) {
                    return true;
                }
                entry = userEntries[i];
                if (i > entries.length || !entry.equals(entries[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return true;
        }
        return false;
    }

    public String getName() {
        return LauncherMessages.getString("JavaClasspathTab.Cla&ss_path_3");
    }

    public static Image getClasspathImage() {
        if (fgClasspathImage == null) {
            fgClasspathImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        }
        return fgClasspathImage;
    }

    private void setLaunchConfiguration(ILaunchConfiguration config) {
        this.fLaunchConfiguration = config;
    }

    private ILaunchConfiguration getLaunchConfiguration() {
        return this.fLaunchConfiguration;
    }

    public void dispose() {
        if (this.fClasspathViewer != null) {
            this.fClasspathViewer.removeEntriesChangedListener(this);
        }
        if (fgClasspathImage != null) {
            fgClasspathImage.dispose();
            fgClasspathImage = null;
        }
        super.dispose();
    }

    public Image getImage() {
        return JavaClasspathTab.getClasspathImage();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = null;
        try {
            projectName = launchConfig.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
        }
        catch (CoreException coreException) {
            return false;
        }
        if (projectName.length() > 0) {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateName(projectName, 4);
            if (status.isOK()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                if (!project.exists()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.getString("JavaMainTab.20"), projectName));
                    return false;
                }
                if (!project.isOpen()) {
                    this.setErrorMessage(MessageFormat.format(LauncherMessages.getString("JavaMainTab.21"), projectName));
                    return false;
                }
            } else {
                this.setErrorMessage(MessageFormat.format(LauncherMessages.getString("JavaMainTab.19"), status.getMessage()));
                return false;
            }
        }
        return true;
    }
}

