/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDebugImages;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.NameValuePairDialog;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class AppletParametersTab
extends JavaLaunchConfigurationTab {
    private Label fWidthLabel;
    private Text fWidthText;
    private Label fHeightLabel;
    private Text fHeightText;
    private Label fNameLabel;
    private Text fNameText;
    private Table fParametersTable;
    private Button fParametersAddButton;
    private Button fParametersRemoveButton;
    private Button fParametersEditButton;
    private AppletTabListener fListener = new AppletTabListener();
    private static final String EMPTY_STRING = "";
    public static final int DEFAULT_APPLET_WIDTH = 200;
    public static final int DEFAULT_APPLET_HEIGHT = 200;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp);
        Composite widthHeightNameComp = new Composite(comp, 0);
        GridData gd = new GridData(768);
        widthHeightNameComp.setLayoutData((Object)gd);
        GridLayout widthHeightNameLayout = new GridLayout();
        widthHeightNameLayout.marginHeight = 0;
        widthHeightNameLayout.marginWidth = 0;
        widthHeightNameLayout.numColumns = 4;
        widthHeightNameComp.setLayout((Layout)widthHeightNameLayout);
        this.fWidthLabel = new Label(widthHeightNameComp, 0);
        this.fWidthLabel.setText(LauncherMessages.getString("appletlauncher.argumenttab.widthlabel.text"));
        this.fWidthLabel.setFont(font);
        this.fWidthText = new Text(widthHeightNameComp, 2052);
        gd = new GridData(768);
        this.fWidthText.setLayoutData((Object)gd);
        this.fWidthText.setFont(font);
        this.fWidthText.addModifyListener((ModifyListener)this.fListener);
        this.fNameLabel = new Label(widthHeightNameComp, 0);
        this.fNameLabel.setText(LauncherMessages.getString("appletlauncher.argumenttab.namelabel.text"));
        this.fNameLabel.setFont(font);
        this.fNameText = new Text(widthHeightNameComp, 2052);
        gd = new GridData(768);
        this.fNameText.setLayoutData((Object)gd);
        this.fNameText.setFont(font);
        this.fNameText.addModifyListener((ModifyListener)this.fListener);
        this.fHeightLabel = new Label(widthHeightNameComp, 0);
        this.fHeightLabel.setText(LauncherMessages.getString("appletlauncher.argumenttab.heightlabel.text"));
        this.fHeightLabel.setFont(font);
        this.fHeightText = new Text(widthHeightNameComp, 2052);
        gd = new GridData(768);
        this.fHeightText.setLayoutData((Object)gd);
        this.fHeightText.setFont(font);
        this.fHeightText.addModifyListener((ModifyListener)this.fListener);
        Label blank = new Label(widthHeightNameComp, 0);
        blank.setText(EMPTY_STRING);
        Label hint = new Label(widthHeightNameComp, 0);
        hint.setText(LauncherMessages.getString("AppletParametersTab.(optional_applet_instance_name)_1"));
        gd = new GridData(64);
        hint.setLayoutData((Object)gd);
        hint.setFont(font);
        this.createVerticalSpacer(comp);
        Composite parametersComp = new Composite(comp, 0);
        gd = new GridData(1808);
        parametersComp.setLayoutData((Object)gd);
        GridLayout parametersLayout = new GridLayout();
        parametersLayout.numColumns = 2;
        parametersLayout.marginHeight = 0;
        parametersLayout.marginWidth = 0;
        parametersComp.setLayout((Layout)parametersLayout);
        parametersComp.setFont(font);
        Label parameterLabel = new Label(parametersComp, 0);
        parameterLabel.setText(LauncherMessages.getString("appletlauncher.argumenttab.parameterslabel.text"));
        gd = new GridData();
        gd.horizontalSpan = 2;
        parameterLabel.setLayoutData((Object)gd);
        parameterLabel.setFont(font);
        this.fParametersTable = new Table(parametersComp, 2050);
        this.fParametersTable.setData((Object)IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS);
        TableLayout tableLayout = new TableLayout();
        this.fParametersTable.setLayout((Layout)tableLayout);
        this.fParametersTable.setFont(font);
        gd = new GridData(1808);
        this.fParametersTable.setLayoutData((Object)gd);
        TableColumn column1 = new TableColumn(this.fParametersTable, 0);
        column1.setText(LauncherMessages.getString("appletlauncher.argumenttab.parameterscolumn.name.text"));
        TableColumn column2 = new TableColumn(this.fParametersTable, 0);
        column2.setText(LauncherMessages.getString("appletlauncher.argumenttab.parameterscolumn.value.text"));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        this.fParametersTable.setHeaderVisible(true);
        this.fParametersTable.setLinesVisible(true);
        this.fParametersTable.addSelectionListener((SelectionListener)this.fListener);
        this.fParametersTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                AppletParametersTab.this.setParametersButtonsEnableState();
                if (AppletParametersTab.this.fParametersEditButton.isEnabled()) {
                    AppletParametersTab.this.handleParametersEditButtonSelected();
                }
            }
        });
        Composite envButtonComp = new Composite(parametersComp, 0);
        GridLayout envButtonLayout = new GridLayout();
        envButtonLayout.marginHeight = 0;
        envButtonLayout.marginWidth = 0;
        envButtonComp.setLayout((Layout)envButtonLayout);
        gd = new GridData(258);
        envButtonComp.setLayoutData((Object)gd);
        envButtonComp.setFont(font);
        this.fParametersAddButton = this.createPushButton(envButtonComp, LauncherMessages.getString("appletlauncher.argumenttab.parameters.button.add.text"), null);
        this.fParametersAddButton.addSelectionListener((SelectionListener)this.fListener);
        this.fParametersEditButton = this.createPushButton(envButtonComp, LauncherMessages.getString("appletlauncher.argumenttab.parameters.button.edit.text"), null);
        this.fParametersEditButton.addSelectionListener((SelectionListener)this.fListener);
        this.fParametersRemoveButton = this.createPushButton(envButtonComp, LauncherMessages.getString("appletlauncher.argumenttab.parameters.button.remove.text"), null);
        this.fParametersRemoveButton.addSelectionListener((SelectionListener)this.fListener);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        try {
            Integer.parseInt(this.getWidthText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(LauncherMessages.getString("appletlauncher.argumenttab.width.error.notaninteger"));
            return false;
        }
        try {
            Integer.parseInt(this.getHeightText());
        }
        catch (NumberFormatException numberFormatException) {
            this.setErrorMessage(LauncherMessages.getString("appletlauncher.argumenttab.height.error.notaninteger"));
            return false;
        }
        return true;
    }

    private void handleParametersAddButtonSelected() {
        NameValuePairDialog dialog = new NameValuePairDialog(this.getShell(), LauncherMessages.getString("appletlauncher.argumenttab.parameters.dialog.add.title"), new String[]{LauncherMessages.getString("appletlauncher.argumenttab.parameters.dialog.add.name.text"), LauncherMessages.getString("appletlauncher.argumenttab.parameters.dialog.add.value.text")}, new String[]{EMPTY_STRING, EMPTY_STRING});
        this.openNewParameterDialog(dialog, null);
        this.setParametersButtonsEnableState();
    }

    private void handleParametersEditButtonSelected() {
        TableItem selectedItem = this.fParametersTable.getSelection()[0];
        String name = selectedItem.getText(0);
        String value = selectedItem.getText(1);
        NameValuePairDialog dialog = new NameValuePairDialog(this.getShell(), LauncherMessages.getString("appletlauncher.argumenttab.parameters.dialog.edit.title"), new String[]{LauncherMessages.getString("appletlauncher.argumenttab.parameters.dialog.edit.name.text"), LauncherMessages.getString("appletlauncher.argumenttab.parameters.dialog.edit.value.text")}, new String[]{name, value});
        this.openNewParameterDialog(dialog, selectedItem);
    }

    private void handleParametersRemoveButtonSelected() {
        int[] selectedIndices = this.fParametersTable.getSelectionIndices();
        this.fParametersTable.remove(selectedIndices);
        this.setParametersButtonsEnableState();
        this.updateLaunchConfigurationDialog();
    }

    private void setParametersButtonsEnableState() {
        int selectCount = this.fParametersTable.getSelectionIndices().length;
        if (selectCount < 1) {
            this.fParametersEditButton.setEnabled(false);
            this.fParametersRemoveButton.setEnabled(false);
        } else {
            this.fParametersRemoveButton.setEnabled(true);
            if (selectCount == 1) {
                this.fParametersEditButton.setEnabled(true);
            } else {
                this.fParametersEditButton.setEnabled(false);
            }
        }
        this.fParametersAddButton.setEnabled(true);
    }

    private void openNewParameterDialog(NameValuePairDialog dialog, TableItem updateItem) {
        if (dialog.open() != 0) {
            return;
        }
        String[] nameValuePair = dialog.getNameValuePair();
        TableItem tableItem = updateItem;
        if (tableItem == null && (tableItem = this.getTableItemForName(nameValuePair[0])) == null) {
            tableItem = new TableItem(this.fParametersTable, 0);
        }
        tableItem.setText(nameValuePair);
        this.fParametersTable.setSelection(new TableItem[]{tableItem});
        this.updateLaunchConfigurationDialog();
    }

    private TableItem getTableItemForName(String candidateName) {
        TableItem[] items = this.fParametersTable.getItems();
        int i = 0;
        while (i < items.length) {
            String name = items[i].getText(0);
            if (name.equals(candidateName)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        try {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, Integer.parseInt(this.getWidthText()));
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, Integer.parseInt(this.getHeightText()));
        }
        catch (NumberFormatException numberFormatException) {}
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, this.fNameText.getText());
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, this.getMapFromParametersTable());
    }

    private String getWidthText() {
        return this.fWidthText.getText().trim();
    }

    private String getHeightText() {
        return this.fHeightText.getText().trim();
    }

    private Map getMapFromParametersTable() {
        TableItem[] items = this.fParametersTable.getItems();
        if (items.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>(items.length);
        int i = 0;
        while (i < items.length) {
            TableItem item = items[i];
            String key = item.getText(0);
            String value = item.getText(1);
            map.put(key, value);
            ++i;
        }
        return map;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private void updateParametersFromConfig(ILaunchConfiguration config) {
        Map envVars = null;
        try {
            if (config != null) {
                envVars = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_PARAMETERS, null);
            }
            this.updateTable(envVars, this.fParametersTable);
            this.setParametersButtonsEnableState();
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    private void updateTable(Map map, Table tableWidget) {
        tableWidget.removeAll();
        if (map == null) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            String value = (String)map.get(key);
            TableItem tableItem = new TableItem(tableWidget, 0);
            tableItem.setText(new String[]{key, value});
        }
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fWidthText.setText(Integer.toString(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_WIDTH, 200)));
        }
        catch (CoreException coreException) {
            this.fWidthText.setText(Integer.toString(200));
        }
        try {
            this.fHeightText.setText(Integer.toString(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_HEIGHT, 200)));
        }
        catch (CoreException coreException) {
            this.fHeightText.setText(Integer.toString(200));
        }
        try {
            this.fNameText.setText(config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_NAME, LauncherMessages.getString("appletlauncher.argumenttab.name.defaultvalue")));
        }
        catch (CoreException coreException) {
            this.fNameText.setText(LauncherMessages.getString("appletlauncher.argumenttab.name.defaultvalue"));
        }
        this.updateParametersFromConfig(config);
    }

    private void createVerticalSpacer(Composite comp) {
        new Label(comp, 0);
    }

    public String getName() {
        return LauncherMessages.getString("appletlauncher.argumenttab.name");
    }

    public Image getImage() {
        return JavaDebugImages.get("org.eclipse.jdt.debug.ui.variable_tab.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    private class AppletTabListener
    extends SelectionAdapter
    implements ModifyListener {
        AppletTabListener() {
        }

        public void modifyText(ModifyEvent e) {
            AppletParametersTab.this.updateLaunchConfigurationDialog();
        }

        public void widgetSelected(SelectionEvent e) {
            Object source = e.getSource();
            if (source == AppletParametersTab.this.fParametersTable) {
                AppletParametersTab.this.setParametersButtonsEnableState();
            } else if (source == AppletParametersTab.this.fParametersAddButton) {
                AppletParametersTab.this.handleParametersAddButtonSelected();
            } else if (source == AppletParametersTab.this.fParametersEditButton) {
                AppletParametersTab.this.handleParametersEditButtonSelected();
            } else if (source == AppletParametersTab.this.fParametersRemoveButton) {
                AppletParametersTab.this.handleParametersRemoveButtonSelected();
            }
        }
    }
}

