/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui.launchConfigurations;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.AppletSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.launcher.JavaLaunchConfigurationTab;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class AppletMainTab
extends JavaLaunchConfigurationTab {
    private Label fProjLabel;
    private Text fProjText;
    private Button fProjButton;
    private Label fMainLabel;
    private Text fMainText;
    private Button fSearchButton;
    private Label fAppletViewerClassLabel;
    private Text fAppletViewerClassText;
    private Button fAppletViewerClassDefaultButton;
    private static final String EMPTY_STRING = "";

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IJavaDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_APPLET_MAIN_TAB);
        GridLayout topLayout = new GridLayout();
        comp.setLayout((Layout)topLayout);
        this.createVerticalSpacer(comp);
        Composite projComp = new Composite(comp, 0);
        GridLayout projLayout = new GridLayout();
        projLayout.numColumns = 3;
        projLayout.marginHeight = 0;
        projLayout.marginWidth = 0;
        projComp.setLayout((Layout)projLayout);
        GridData gd = new GridData(768);
        projComp.setLayoutData((Object)gd);
        projComp.setFont(font);
        this.fProjLabel = new Label(projComp, 0);
        this.fProjLabel.setText(LauncherMessages.getString("appletlauncher.maintab.projectlabel.name"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fProjLabel.setLayoutData((Object)gd);
        this.fProjLabel.setFont(font);
        this.fProjText = new Text(projComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fProjText.setLayoutData((Object)gd);
        this.fProjText.setFont(font);
        this.fProjText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                AppletMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fProjButton = this.createPushButton(projComp, LauncherMessages.getString("appletlauncher.maintab.browselabel.name"), null);
        this.fProjButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AppletMainTab.this.handleProjectButtonSelected();
            }
        });
        Label spacer = this.createVerticalSpacer(projComp);
        gd = new GridData();
        gd.horizontalSpan = 3;
        spacer.setLayoutData((Object)gd);
        this.fMainLabel = new Label(projComp, 0);
        this.fMainLabel.setText(LauncherMessages.getString("appletlauncher.maintab.mainclasslabel.name"));
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.fMainLabel.setLayoutData((Object)gd);
        this.fMainLabel.setFont(font);
        this.fMainText = new Text(projComp, 2052);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.fMainText.setLayoutData((Object)gd);
        this.fMainText.setFont(font);
        this.fMainText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                AppletMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fSearchButton = this.createPushButton(projComp, LauncherMessages.getString("appletlauncher.maintab.searchlabel.name"), null);
        this.fSearchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AppletMainTab.this.handleSearchButtonSelected();
            }
        });
        this.createVerticalSpacer(projComp);
        this.fAppletViewerClassLabel = new Label(comp, 0);
        this.fAppletViewerClassLabel.setText(LauncherMessages.getString("AppletMainTab.Name_of_appletviewer_class__1"));
        this.fAppletViewerClassLabel.setFont(font);
        this.fAppletViewerClassText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fAppletViewerClassText.setLayoutData((Object)gd);
        this.fAppletViewerClassText.setFont(font);
        this.fAppletViewerClassText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                AppletMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fAppletViewerClassDefaultButton = new Button(comp, 32);
        this.fAppletViewerClassDefaultButton.setFont(font);
        this.fAppletViewerClassDefaultButton.setText(LauncherMessages.getString("AppletMainTab.Use_default_appletviewer_class_2"));
        this.fAppletViewerClassDefaultButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                AppletMainTab.this.setAppletViewerTextEnabledState();
                if (AppletMainTab.this.isDefaultAppletViewerClassName()) {
                    AppletMainTab.this.fAppletViewerClassText.setText("sun.applet.AppletViewer");
                } else {
                    AppletMainTab.this.fAppletViewerClassText.setText(AppletMainTab.EMPTY_STRING);
                }
            }
        });
    }

    protected void setAppletViewerTextEnabledState() {
        if (this.isDefaultAppletViewerClassName()) {
            this.fAppletViewerClassText.setEnabled(false);
        } else {
            this.fAppletViewerClassText.setEnabled(true);
        }
    }

    protected boolean isDefaultAppletViewerClassName() {
        return this.fAppletViewerClassDefaultButton.getSelection();
    }

    public void initializeFrom(ILaunchConfiguration config) {
        this.updateProjectFromConfig(config);
        this.updateMainTypeFromConfig(config);
        this.updateAppletViewerClassNameFromConfig(config);
    }

    private void updateProjectFromConfig(ILaunchConfiguration config) {
        String projectName = EMPTY_STRING;
        try {
            projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fProjText.setText(projectName);
    }

    private void updateMainTypeFromConfig(ILaunchConfiguration config) {
        String mainTypeName = EMPTY_STRING;
        try {
            mainTypeName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, EMPTY_STRING);
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
        this.fMainText.setText(mainTypeName);
    }

    private void updateAppletViewerClassNameFromConfig(ILaunchConfiguration config) {
        String appletViewerClassName = null;
        try {
            appletViewerClassName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, null);
            if (appletViewerClassName == null) {
                this.fAppletViewerClassText.setText("sun.applet.AppletViewer");
                this.fAppletViewerClassDefaultButton.setSelection(true);
            } else {
                this.fAppletViewerClassText.setText(appletViewerClassName);
                this.fAppletViewerClassDefaultButton.setSelection(false);
            }
            this.setAppletViewerTextEnabledState();
        }
        catch (CoreException ce) {
            JDIDebugUIPlugin.log(ce);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, this.fProjText.getText());
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, this.fMainText.getText());
        this.performApplyAppletViewerClassName(config);
    }

    private void performApplyAppletViewerClassName(ILaunchConfigurationWorkingCopy config) {
        String appletViewerClassName = null;
        if (!this.isDefaultAppletViewerClassName() && (appletViewerClassName = this.fAppletViewerClassText.getText().trim()).length() <= 0) {
            appletViewerClassName = null;
        }
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, appletViewerClassName);
    }

    public void dispose() {
    }

    private Label createVerticalSpacer(Composite comp) {
        return new Label(comp, 0);
    }

    private void handleSearchButtonSelected() {
        IJavaProject javaProject = this.getJavaProject();
        Shell shell = this.getShell();
        AppletSelectionDialog dialog = new AppletSelectionDialog(shell, (IRunnableContext)this.getLaunchConfigurationDialog(), javaProject);
        dialog.setTitle(LauncherMessages.getString("appletlauncher.maintab.selection.applet.dialog.title"));
        dialog.setMessage(LauncherMessages.getString("appletlauncher.maintab.selection.applet.dialog.message"));
        if (dialog.open() == 1) {
            return;
        }
        Object[] results = dialog.getResult();
        if (results == null || results.length < 1) {
            return;
        }
        IType type = (IType)results[0];
        if (type != null) {
            this.fMainText.setText(type.getFullyQualifiedName());
            javaProject = type.getJavaProject();
            this.fProjText.setText(javaProject.getElementName());
        }
    }

    private void handleProjectButtonSelected() {
        IJavaProject project = this.chooseJavaProject();
        if (project == null) {
            return;
        }
        String projectName = project.getElementName();
        this.fProjText.setText(projectName);
    }

    private IJavaProject chooseJavaProject() {
        Object[] projects;
        try {
            projects = JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot()).getJavaProjects();
        }
        catch (JavaModelException jme) {
            JDIDebugUIPlugin.log(jme);
            projects = new IJavaProject[]{};
        }
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT);
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setTitle(LauncherMessages.getString("appletlauncher.maintab.selection.project.dialog.title"));
        dialog.setMessage(LauncherMessages.getString("appletlauncher.maintab.selection.project.dialog.message"));
        dialog.setElements(projects);
        IJavaProject javaProject = this.getJavaProject();
        if (javaProject != null) {
            dialog.setInitialSelections(new Object[]{javaProject});
        }
        if (dialog.open() == 0) {
            return (IJavaProject)dialog.getFirstResult();
        }
        return null;
    }

    private IJavaProject getJavaProject() {
        String projectName = this.fProjText.getText().trim();
        if (projectName.length() < 1) {
            return null;
        }
        return this.getJavaModel().getJavaProject(projectName);
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private IJavaModel getJavaModel() {
        return JavaCore.create((IWorkspaceRoot)this.getWorkspaceRoot());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String name = this.fProjText.getText().trim();
        if (name.length() > 0 && !ResourcesPlugin.getWorkspace().getRoot().getProject(name).exists()) {
            this.setErrorMessage(LauncherMessages.getString("appletlauncher.maintab.project.error.doesnotexist"));
            return false;
        }
        name = this.fMainText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.getString("appletlauncher.maintab.type.error.doesnotexist"));
            return false;
        }
        name = this.fAppletViewerClassText.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage(LauncherMessages.getString("AppletMainTab.Appletviewer_class_must_be_specified_3"));
            return false;
        }
        return true;
    }

    private void initializeDefaults(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        this.initializeJavaProject(javaElement, config);
        this.initializeMainTypeAndName(javaElement, config);
        this.initializeHardCodedDefaults(config);
        this.initializeAppletViewerClass(config);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        IJavaElement je = this.getContext();
        if (je == null) {
            this.initializeHardCodedDefaults(config);
        } else {
            this.initializeDefaults(je, config);
        }
    }

    private void initializeMainTypeAndName(IJavaElement javaElement, ILaunchConfigurationWorkingCopy config) {
        String name = null;
        if (javaElement instanceof IMember) {
            IMember member = (IMember)javaElement;
            javaElement = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (javaElement instanceof ICompilationUnit || javaElement instanceof IClassFile) {
            if (javaElement.getElementType() == 5) {
                ICompilationUnit cu = (ICompilationUnit)javaElement;
                IType mainType = cu.getType(Signature.getQualifier((String)cu.getElementName()));
                if (mainType.exists()) {
                    name = mainType.getFullyQualifiedName();
                }
            } else if (javaElement.getElementType() == 6) {
                try {
                    IType mainType = ((IClassFile)javaElement).getType();
                    name = mainType.getFullyQualifiedName();
                }
                catch (JavaModelException javaModelException) {}
            }
        }
        if (name != null) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, name);
            if (name.length() > 0) {
                int index = name.lastIndexOf(46);
                if (index > 0) {
                    name = name.substring(index + 1);
                }
                name = this.getLaunchConfigurationDialog().generateName(name);
                config.rename(name);
            }
        }
    }

    private void initializeDefaultVM(ILaunchConfigurationWorkingCopy config) {
        IVMInstall vmInstall = JavaRuntime.getDefaultVMInstall();
        if (vmInstall == null) {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, null);
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null);
        } else {
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_NAME, vmInstall.getName());
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, vmInstall.getVMInstallType().getId());
        }
    }

    private void initializeHardCodedDefaults(ILaunchConfigurationWorkingCopy config) {
        this.initializeDefaultVM(config);
    }

    private void initializeAppletViewerClass(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_APPLET_APPLETVIEWER_CLASS, null);
    }

    public String getName() {
        return LauncherMessages.getString("appletlauncher.maintab.name");
    }

    public Image getImage() {
        return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

