/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public abstract class VersionConstraintImpl
implements VersionConstraint {
    private String name;
    private Version versionSpecification;
    private byte matchingRule = (byte)4;
    private BundleDescription bundle;
    private BundleDescription supplier;
    private Version actualVersion;

    public String getName() {
        return this.name;
    }

    public Version getVersionSpecification() {
        return this.versionSpecification;
    }

    public Version getActualVersion() {
        return this.actualVersion;
    }

    public byte getMatchingRule() {
        return this.matchingRule;
    }

    public BundleDescription getBundle() {
        return this.bundle;
    }

    public BundleDescription getSupplier() {
        return this.supplier;
    }

    public boolean isResolved() {
        return this.supplier != null;
    }

    public void setActualVersion(Version actualVersion) {
        this.actualVersion = actualVersion;
    }

    public void setSupplier(BundleDescription supplier) {
        this.supplier = supplier;
    }

    public void setMatchingRule(byte matchingRule) {
        this.matchingRule = matchingRule;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVersionSpecification(Version versionSpecification) {
        this.versionSpecification = versionSpecification;
    }

    public void setBundle(BundleDescription bundle) {
        this.bundle = bundle;
    }

    public void unresolve() {
        this.actualVersion = null;
        this.supplier = null;
    }

    public boolean isSatisfiedBy(Version provided) {
        Version required = this.getVersionSpecification();
        if (required == null) {
            return true;
        }
        switch (this.getMatchingRule()) {
            case 1: {
                return provided.isPerfect(required);
            }
            case 2: {
                return provided.isEquivalentTo(required);
            }
            case 3: {
                return provided.isCompatibleWith(required);
            }
        }
        return provided.isGreaterOrEqualTo(required);
    }

    public String toString() {
        return "name: " + this.name + " - version: " + this.versionSpecification;
    }
}

