/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.osgi.internal.resolver.ResolverImpl;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.StateObjectFactoryImpl;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.PlatformAdmin;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.osgi.framework.BundleException;

public class StateManager
implements PlatformAdmin {
    public static boolean DEBUG_READER = false;
    private long readStartupTime;
    private StateImpl systemState;
    private File stateLocation;
    private StateObjectFactoryImpl factory = new StateObjectFactoryImpl();
    private long lastTimeStamp;

    public StateManager(File bundleRootDir) {
        this(bundleRootDir, -1L);
    }

    public StateManager(File bundleRootDir, long expectedTimeStamp) {
        this.stateLocation = new File(bundleRootDir, ".state");
        this.readState(expectedTimeStamp);
    }

    public void shutdown() throws IOException {
        this.writeState();
        this.systemState = null;
    }

    /*
     * Exception decompiling
     */
    private void readState(long expectedTimeStamp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [4 : 158->162)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeState() throws IOException {
        if (this.systemState == null) {
            return;
        }
        if (this.stateLocation.isFile() && this.lastTimeStamp == this.systemState.getTimeStamp()) {
            return;
        }
        DataOutputStream output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.stateLocation)));
        this.factory.writeState(this.systemState, output);
    }

    public StateImpl createSystemState() {
        this.systemState = this.factory.createSystemState();
        this.initializeSystemState();
        return this.systemState;
    }

    private void initializeSystemState() {
        this.systemState.setResolver(new ResolverImpl());
        this.lastTimeStamp = this.systemState.getTimeStamp();
    }

    public StateImpl getSystemState() {
        return this.systemState;
    }

    public State getState() {
        return this.factory.createState(this.systemState);
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    public synchronized void commit(State state) throws BundleException {
        if (!(state instanceof StateImpl)) {
            throw new IllegalArgumentException();
        }
        if (state.getTimeStamp() != this.systemState.getTimeStamp()) {
            throw new BundleException("");
        }
        StateDelta delta = state.getChanges();
        BundleDelta[] addedBundles = delta.getChanges(1, false);
        int i = 0;
        while (i < addedBundles.length) {
            this.systemState.addBundle(this.factory.createBundleDescription(addedBundles[i].getBundle()));
            ++i;
        }
        BundleDelta[] removedBundles = delta.getChanges(2, false);
        int i2 = 0;
        while (i2 < removedBundles.length) {
            this.systemState.removeBundle(removedBundles[i2].getBundle());
            ++i2;
        }
    }

    public Resolver getResolver() {
        return new ResolverImpl();
    }

    public File getStateLocation() {
        return this.stateLocation;
    }
}

