/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.framework.debug.DebugOptions;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.framework.internal.core.KeyedHashSet;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.StateDeltaImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateChangeEvent;
import org.eclipse.osgi.service.resolver.StateChangeListener;
import org.eclipse.osgi.service.resolver.StateDelta;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class StateImpl
implements State {
    private transient Resolver resolver;
    private transient StateDeltaImpl changes;
    private transient Map listeners = new HashMap(11);
    private transient KeyedHashSet resolvedBundles = new KeyedHashSet();
    private boolean resolved = true;
    protected long timeStamp = System.currentTimeMillis();
    private KeyedHashSet bundleDescriptions = new KeyedHashSet(false);
    private StateObjectFactory factory;
    public static boolean DEBUG_RESOLVER = false;
    private static long cumulativeTime;

    StateImpl() {
    }

    public boolean addBundle(BundleDescription description) {
        if (description.getBundleId() < 0L) {
            throw new IllegalArgumentException("no id set");
        }
        if (!this.basicAddBundle(description)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleAdded((BundleDescriptionImpl)description);
        if (this.resolver != null) {
            this.resolver.bundleAdded(description);
        }
        return true;
    }

    public StateChangeEvent compare(State state) {
        throw new UnsupportedOperationException("not implemented");
    }

    public BundleDescription removeBundle(long bundleId) {
        BundleDescription toRemove = this.getBundle(bundleId);
        if (toRemove == null || !this.removeBundle(toRemove)) {
            return null;
        }
        return toRemove;
    }

    public boolean removeBundle(BundleDescription toRemove) {
        if (!this.bundleDescriptions.remove((KeyedElement)toRemove)) {
            return false;
        }
        this.resolved = false;
        this.getDelta().recordBundleRemoved((BundleDescriptionImpl)toRemove);
        if (this.resolver != null) {
            this.resolver.bundleRemoved(toRemove);
        }
        return true;
    }

    public StateDelta getChanges() {
        return this.getDelta();
    }

    private StateDeltaImpl getDelta() {
        if (this.changes == null) {
            this.changes = this.getNewDelta();
        }
        return this.changes;
    }

    private StateDeltaImpl getNewDelta() {
        return new StateDeltaImpl(this);
    }

    public BundleDescription[] getBundles(String requiredUniqueId) {
        ArrayList<BundleDescription> bundles = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            if (!requiredUniqueId.equals(bundle.getUniqueId())) continue;
            bundles.add(bundle);
        }
        return bundles.toArray(new BundleDescription[bundles.size()]);
    }

    public BundleDescription[] getBundles() {
        return (BundleDescription[])this.bundleDescriptions.elements((Object[])new BundleDescription[this.bundleDescriptions.size()]);
    }

    public BundleDescription getBundle(long id) {
        return (BundleDescription)this.bundleDescriptions.getByKey((Object)new Long(id));
    }

    public BundleDescription getBundle(String requiredUniqueId, Version requiredVersion) {
        BundleDescription[] bundles = this.getBundles();
        int i = 0;
        while (i < bundles.length) {
            if (requiredUniqueId.equals(bundles[i].getUniqueId()) && bundles[i].getVersion().equals((Object)requiredVersion)) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isResolved() {
        return this.resolved || this.isEmpty();
    }

    public void resolveConstraint(VersionConstraint constraint, Version actualVersion, BundleDescription supplier) {
        VersionConstraintImpl modifiable = (VersionConstraintImpl)constraint;
        if (modifiable.getActualVersion() != actualVersion || modifiable.getSupplier() != supplier) {
            modifiable.setActualVersion(actualVersion);
            modifiable.setSupplier(supplier);
            if (constraint instanceof BundleSpecification || constraint instanceof HostSpecification) {
                boolean optional = constraint instanceof BundleSpecification && ((BundleSpecification)constraint).isOptional();
                this.getDelta().recordConstraintResolved((BundleDescriptionImpl)constraint.getBundle(), optional);
            }
        }
    }

    public void resolveBundle(BundleDescription bundle, int status) {
        ((BundleDescriptionImpl)bundle).setState(status);
        this.getDelta().recordBundleResolved((BundleDescriptionImpl)bundle, status);
        if (status == 4) {
            this.resolvedBundles.add((KeyedElement)bundle);
        } else {
            this.unresolveConstraints(bundle);
            this.resolvedBundles.remove((KeyedElement)bundle);
        }
    }

    private void unresolveConstraints(BundleDescription bundle) {
        HostSpecification host = bundle.getHost();
        if (host != null) {
            ((VersionConstraintImpl)host).unresolve();
        }
        PackageSpecification[] packages = bundle.getPackages();
        int i = 0;
        while (i < packages.length) {
            ((VersionConstraintImpl)packages[i]).unresolve();
            ++i;
        }
        BundleSpecification[] requiredBundles = bundle.getRequiredBundles();
        int i2 = 0;
        while (i2 < requiredBundles.length) {
            ((VersionConstraintImpl)requiredBundles[i2]).unresolve();
            ++i2;
        }
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver newResolver) {
        if (this.resolver == newResolver) {
            return;
        }
        if (this.resolver != null) {
            this.resolver.setState(null);
        }
        this.resolver = newResolver;
        if (this.resolver == null) {
            return;
        }
        this.resolver.setState((State)this);
    }

    private StateDelta resolve(boolean incremental, BundleDescription[] reResolve) {
        if (this.resolver == null) {
            throw new IllegalStateException("no resolver set");
        }
        long start = 0L;
        if (DEBUG_RESOLVER) {
            start = System.currentTimeMillis();
        }
        if (!incremental) {
            this.flush();
        }
        if (this.resolved && reResolve == null) {
            return new StateDeltaImpl(this);
        }
        if (reResolve != null) {
            this.resolver.resolve(reResolve);
        } else {
            this.resolver.resolve();
        }
        this.resolved = true;
        StateDeltaImpl savedChanges = this.changes == null ? new StateDeltaImpl(this) : this.changes;
        this.changes = new StateDeltaImpl(this);
        if (DEBUG_RESOLVER) {
            DebugOptions.getDefault().setOption("org.eclipse.core.runtime.adaptor/resolver/timing/value", Long.toString(cumulativeTime += System.currentTimeMillis() - start));
        }
        return savedChanges;
    }

    private void flush() {
        this.resolver.flush();
        this.resolved = false;
        if (this.resolvedBundles.isEmpty()) {
            return;
        }
        Iterator iter = this.resolvedBundles.iterator();
        while (iter.hasNext()) {
            BundleDescriptionImpl resolvedBundle = (BundleDescriptionImpl)iter.next();
            resolvedBundle.setState(0);
        }
        this.resolvedBundles.clear();
    }

    public StateDelta resolve() {
        return this.resolve(true, null);
    }

    public StateDelta resolve(boolean incremental) {
        return this.resolve(incremental, null);
    }

    public StateDelta resolve(BundleDescription[] reResolve) {
        return this.resolve(true, reResolve);
    }

    public void setOverrides(Object value) {
        throw new UnsupportedOperationException();
    }

    public BundleDescription[] getResolvedBundles() {
        return (BundleDescription[])this.resolvedBundles.elements((Object[])new BundleDescription[this.resolvedBundles.size()]);
    }

    public void addStateChangeListener(StateChangeListener listener, int flags) {
        if (this.listeners.containsKey(listener)) {
            return;
        }
        this.listeners.put(listener, new Integer(flags));
    }

    public void removeStateChangeListener(StateChangeListener listener) {
        this.listeners.remove(listener);
    }

    public boolean isEmpty() {
        return this.bundleDescriptions.isEmpty();
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public boolean basicAddBundle(BundleDescription description) {
        ((BundleDescriptionImpl)description).setContainingState(this);
        return this.bundleDescriptions.add((KeyedElement)((BundleDescriptionImpl)description));
    }

    void addResolvedBundle(BundleDescriptionImpl resolved) {
        this.resolvedBundles.add((KeyedElement)resolved);
    }

    public BundleDescription[] getDependentBundles(BundleDescription[] roots) {
        boolean changed;
        HashSet<KeyedElement> remaining = new HashSet<KeyedElement>(Arrays.asList(this.resolvedBundles.elements()));
        KeyedHashSet reachable = new KeyedHashSet(roots.length);
        int i = 0;
        while (i < roots.length) {
            if (roots[i].isResolved()) {
                reachable.add((KeyedElement)roots[i]);
                remaining.remove(roots[i]);
            }
            ++i;
        }
        do {
            changed = false;
            Iterator remainingIter = remaining.iterator();
            while (remainingIter.hasNext()) {
                BundleDescription candidate = (BundleDescription)remainingIter.next();
                if (!this.isDependent(candidate, reachable)) continue;
                reachable.add((KeyedElement)candidate);
                remainingIter.remove();
                changed = true;
            }
        } while (changed);
        return (BundleDescription[])reachable.elements((Object[])new BundleDescription[reachable.size()]);
    }

    private boolean isDependent(BundleDescription candidate, KeyedHashSet elements) {
        HostSpecification candidateHost = candidate.getHost();
        if (candidateHost != null && candidateHost.isResolved() && elements.contains((KeyedElement)candidateHost.getSupplier())) {
            return true;
        }
        BundleSpecification[] candidateRequired = candidate.getRequiredBundles();
        int i = 0;
        while (i < candidateRequired.length) {
            if (candidateRequired[i].isResolved() && elements.contains((KeyedElement)candidateRequired[i].getSupplier())) {
                return true;
            }
            ++i;
        }
        PackageSpecification[] candidatePackages = candidate.getPackages();
        int i2 = 0;
        while (i2 < candidatePackages.length) {
            if (candidatePackages[i2].isResolved() && candidatePackages[i2].getSupplier() != candidate && elements.contains((KeyedElement)candidatePackages[i2].getSupplier())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public PackageSpecification getExportedPackage(String packageName, Version version) {
        boolean ignoreVersion = version == null;
        Iterator iter = this.resolvedBundles.iterator();
        while (iter.hasNext()) {
            PackageSpecification[] packages = ((BundleDescriptionImpl)iter.next()).getPackages();
            int i = 0;
            while (i < packages.length) {
                if (packages[i].getName().equals(packageName) && (ignoreVersion || packages[i].getVersionSpecification().equals((Object)version)) && packages[i].getSupplier() != null) {
                    return packages[i].getSupplier().getPackage(packageName);
                }
                ++i;
            }
        }
        return null;
    }

    public PackageSpecification[] getExportedPackages(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return new PackageSpecification[0];
        }
        PackageSpecification[] allPackages = bundle.getPackages();
        PackageSpecification[] exported = new PackageSpecification[allPackages.length];
        int exportedCount = 0;
        int i = 0;
        while (i < allPackages.length) {
            if (allPackages[i].isExported() && allPackages[i].getSupplier() == bundle) {
                exported[exportedCount++] = allPackages[i];
            }
            ++i;
        }
        if (exportedCount < exported.length) {
            PackageSpecification[] tmpExported = new PackageSpecification[exportedCount];
            System.arraycopy(exported, 0, tmpExported, 0, exportedCount);
            exported = tmpExported;
        }
        return exported;
    }

    public PackageSpecification[] getExportedPackages() {
        ArrayList<PackageSpecification> allExportedPackages = new ArrayList<PackageSpecification>();
        Iterator iter = this.resolvedBundles.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            PackageSpecification[] bundlePackages = bundle.getPackages();
            int i = 0;
            while (i < bundlePackages.length) {
                if (bundlePackages[i].isExported() && bundlePackages[i].getSupplier() == bundle) {
                    allExportedPackages.add(bundlePackages[i]);
                }
                ++i;
            }
        }
        return allExportedPackages.toArray(new PackageSpecification[allExportedPackages.size()]);
    }

    public BundleDescription[] getImportingBundles(PackageSpecification exportedPackage) {
        if (!exportedPackage.isResolved()) {
            return null;
        }
        ArrayList<BundleDescription> allImportingBundles = new ArrayList<BundleDescription>();
        Iterator iter = this.resolvedBundles.iterator();
        block0: while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            PackageSpecification[] bundlePackages = bundle.getPackages();
            int i = 0;
            while (i < bundlePackages.length) {
                if (bundlePackages[i].getName().equals(exportedPackage.getName()) && bundlePackages[i].getSupplier() == exportedPackage.getBundle()) {
                    allImportingBundles.add(bundle);
                    continue block0;
                }
                ++i;
            }
        }
        return allImportingBundles.toArray(new BundleDescription[allImportingBundles.size()]);
    }

    public BundleDescription[] getFragments(BundleDescription host) {
        ArrayList<BundleDescription> fragments = new ArrayList<BundleDescription>();
        Iterator iter = this.bundleDescriptions.iterator();
        while (iter.hasNext()) {
            BundleDescription bundle = (BundleDescription)iter.next();
            HostSpecification hostSpec = bundle.getHost();
            if (hostSpec == null || hostSpec.getSupplier() != host) continue;
            fragments.add(bundle);
        }
        return fragments.toArray(new BundleDescription[fragments.size()]);
    }

    public void setTimeStamp(long newTimeStamp) {
        this.timeStamp = newTimeStamp;
    }

    public StateObjectFactory getFactory() {
        return this.factory;
    }

    void setFactory(StateObjectFactory factory) {
        this.factory = factory;
    }
}

