/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.internal.resolver.BundleDeltaImpl;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.service.resolver.BundleDelta;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.StateDelta;

public class StateDeltaImpl
implements StateDelta {
    private State state;
    private Map changes = new HashMap();

    public StateDeltaImpl(State state) {
        this.state = state;
    }

    public BundleDelta[] getChanges() {
        return this.changes.values().toArray(new BundleDelta[this.changes.size()]);
    }

    public BundleDelta[] getChanges(int mask, boolean exact) {
        ArrayList<BundleDelta> result = new ArrayList<BundleDelta>();
        Iterator changesIter = this.changes.values().iterator();
        while (changesIter.hasNext()) {
            BundleDelta change = (BundleDelta)changesIter.next();
            if (change.getType() != mask && (exact || (change.getType() & mask) != mask)) continue;
            result.add(change);
        }
        return result.toArray(new BundleDelta[result.size()]);
    }

    public State getState() {
        return this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void recordBundleAdded(BundleDescriptionImpl added) {
        Object key = added.getKey();
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(key);
        if (change != null) {
            if ((change.getType() & 2) == 0) throw new IllegalStateException();
            change.setType(4 | change.getType() & 0xFFFFFFFD);
            return;
        } else {
            this.changes.put(key, new BundleDeltaImpl(added, 1));
        }
    }

    void recordBundleRemoved(BundleDescriptionImpl removed) {
        Object key = removed.getKey();
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(key);
        if (change != null) {
            if ((change.getType() & 1) != 0) {
                this.changes.remove(key);
                return;
            }
            change.setType(change.getType() | 2);
        } else {
            this.changes.put(key, new BundleDeltaImpl(removed, 2));
        }
    }

    void recordConstraintResolved(BundleDescriptionImpl changedLinkage, boolean optional) {
        int newType;
        Object key = changedLinkage.getKey();
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(key);
        int n = newType = optional ? 64 : 32;
        if (change == null || newType == 32 && change.getType() == 64) {
            this.changes.put(key, new BundleDeltaImpl(changedLinkage, newType));
        }
    }

    void recordBundleResolved(BundleDescriptionImpl resolved, int status) {
        int newType;
        Object key = resolved.getKey();
        BundleDeltaImpl change = (BundleDeltaImpl)this.changes.get(key);
        int n = newType = status == 4 ? 8 : 16;
        if (change == null) {
            change = new BundleDeltaImpl(resolved, newType);
            this.changes.put(key, change);
            return;
        }
        int currentType = change.getType();
        if (newType == 8 && currentType == 16 || newType == 16 && currentType == 8) {
            this.changes.remove(key);
            return;
        }
        change.setType(newType |= currentType & 0xFFFFFFE7);
    }
}

