/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Dictionary;
import java.util.HashMap;
import org.eclipse.osgi.internal.resolver.BundleDescriptionImpl;
import org.eclipse.osgi.internal.resolver.BundleSpecificationImpl;
import org.eclipse.osgi.internal.resolver.HostSpecificationImpl;
import org.eclipse.osgi.internal.resolver.PackageSpecificationImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleException;

class StateBuilder {
    StateBuilder() {
    }

    static BundleDescription createBundleDescription(Dictionary manifest, String location) throws BundleException {
        String version;
        BundleDescriptionImpl result = new BundleDescriptionImpl();
        result.setUniqueId((String)manifest.get("Bundle-GlobalName"));
        if (result.getUniqueId() == null) {
            result.setUniqueId((String)manifest.get("Bundle-Name"));
        }
        result.setVersion((version = (String)manifest.get("Bundle-Version")) != null ? new Version(version) : Version.EMPTY_VERSION);
        result.setLocation(location);
        ManifestElement[] host = ManifestElement.parseBundleDescriptions((String)((String)manifest.get("Host-Bundle")));
        if (host != null) {
            result.setHost(StateBuilder.createHostSpecification(result, host[0]));
        }
        ManifestElement[] imports = ManifestElement.parsePackageDescription((String)((String)manifest.get("Import-Package")));
        ManifestElement[] exports = ManifestElement.parsePackageDescription((String)((String)manifest.get("Export-Package")));
        result.setPackages(StateBuilder.createPackages(result, exports, imports));
        ManifestElement[] provides = ManifestElement.parsePackageDescription((String)((String)manifest.get("Provide-Package")));
        result.setProvidedPackages(StateBuilder.createProvidedPackages(result, provides));
        ManifestElement[] requires = ManifestElement.parseBundleDescriptions((String)((String)manifest.get("Require-Bundle")));
        result.setRequiredBundles(StateBuilder.createRequiredBundles(result, requires));
        return result;
    }

    private static BundleSpecification[] createRequiredBundles(BundleDescriptionImpl parent, ManifestElement[] specs) {
        if (specs == null) {
            return null;
        }
        BundleSpecification[] result = new BundleSpecification[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = StateBuilder.createRequiredBundle(parent, specs[i]);
            ++i;
        }
        return result;
    }

    private static BundleSpecification createRequiredBundle(BundleDescriptionImpl parent, ManifestElement spec) {
        BundleSpecificationImpl result = new BundleSpecificationImpl();
        result.setName(spec.getValue());
        String version = spec.getAttribute("bundle-version");
        if (version != null) {
            result.setVersionSpecification(new Version(version));
        }
        result.setMatchingRule(StateBuilder.parseMatchingRule(spec.getAttribute("version-match")));
        result.setExported(spec.getAttribute("provide-packages") != null);
        result.setOptional(spec.getAttribute("optional") != null);
        return result;
    }

    private static byte parseMatchingRule(String match) {
        if (match == null) {
            return 4;
        }
        if (match.equals("equivalent")) {
            return 2;
        }
        if (match.equals("compatible")) {
            return 3;
        }
        if (match.equals("perfect")) {
            return 1;
        }
        return 4;
    }

    private static String[] createProvidedPackages(BundleDescription parent, ManifestElement[] specs) {
        if (specs == null || specs.length == 0) {
            return null;
        }
        String[] result = new String[specs.length];
        int i = 0;
        while (i < specs.length) {
            result[i] = specs[i].getValue();
            ++i;
        }
        return result;
    }

    private static PackageSpecification[] createPackages(BundleDescription parent, ManifestElement[] exported, ManifestElement[] imported) {
        int i;
        int capacity = (exported == null ? 0 : exported.length) + (imported == null ? 0 : imported.length);
        if (capacity == 0) {
            return null;
        }
        HashMap<String, PackageSpecification> packages = new HashMap<String, PackageSpecification>(capacity);
        if (imported != null) {
            i = 0;
            while (i < imported.length) {
                packages.put(imported[i].getValue(), StateBuilder.createPackage(parent, imported[i], false));
                ++i;
            }
        }
        if (exported != null) {
            i = 0;
            while (i < exported.length) {
                packages.put(exported[i].getValue(), StateBuilder.createPackage(parent, exported[i], true));
                ++i;
            }
        }
        return packages.values().toArray(new PackageSpecification[packages.size()]);
    }

    private static PackageSpecification createPackage(BundleDescription parent, ManifestElement spec, boolean export) {
        PackageSpecificationImpl result = new PackageSpecificationImpl();
        result.setName(spec.getValue());
        String version = spec.getAttribute("specification-version");
        if (version != null) {
            result.setVersionSpecification(new Version(version));
        }
        result.setExport(export);
        return result;
    }

    private static HostSpecification createHostSpecification(BundleDescription parent, ManifestElement spec) {
        if (spec == null) {
            return null;
        }
        HostSpecificationImpl result = new HostSpecificationImpl();
        result.setName(spec.getValue());
        String version = spec.getAttribute("bundle-version");
        if (version != null) {
            result.setVersionSpecification(new Version(version));
        }
        result.setMatchingRule(StateBuilder.parseMatchingRule(spec.getAttribute("version-match")));
        result.setReloadHost(false);
        return result;
    }
}

