/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IDependencySystem;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementChange;
import org.eclipse.core.dependencies.IElementSet;
import org.eclipse.core.dependencies.IResolutionDelta;
import org.eclipse.osgi.internal.resolver.Eclipse30SelectionPolicy;
import org.eclipse.osgi.internal.resolver.ResolverHelper;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.Resolver;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverImpl
implements Resolver {
    private State state;
    private IDependencySystem dependencies;

    public void resolve(BundleDescription[] reRefresh) {
        int i = 0;
        while (i < reRefresh.length) {
            this.unresolveBundle(reRefresh[i]);
            ++i;
        }
        this.resolve();
    }

    public synchronized void resolve() {
        IResolutionDelta delta;
        if (this.state == null) {
            throw new IllegalStateException("no state set");
        }
        if (this.dependencies == null) {
            this.dependencies = ResolverHelper.buildDependencySystem(this.state, new Eclipse30SelectionPolicy());
        }
        try {
            delta = this.dependencies.resolve();
        }
        catch (IDependencySystem.CyclicSystemException e) {
            e.printStackTrace();
            return;
        }
        this.processInnerDelta(delta);
        this.resolvePackages();
    }

    public void setState(State newState) {
        if (this.state == newState) {
            return;
        }
        if (this.state != null) {
            this.state.setResolver(null);
        }
        this.state = newState;
        if (newState != null) {
            this.state.setResolver((Resolver)this);
        }
        this.flush();
    }

    private void processInnerDelta(IResolutionDelta delta) {
        IElementChange[] changes = delta.getAllChanges();
        int i = 0;
        while (i < changes.length) {
            IElement element = changes[i].getElement();
            BundleDescription bundle = (BundleDescription)element.getUserObject();
            int kind = changes[i].getKind();
            if ((kind & 4) != 0) {
                this.state.resolveBundle(bundle, 4);
                this.resolveConstraints(element, bundle);
            } else if (kind == 10) {
                this.state.resolveBundle(bundle, 2);
            } else if (kind == 8) {
                this.state.resolveBundle(bundle, 2);
            } else if (kind == 16) {
                this.resolveConstraints(element, bundle);
            }
            ++i;
        }
    }

    private void resolveConstraints(IElement element, BundleDescription bundle) {
        IDependency[] dependencies = element.getDependencies();
        int j = 0;
        while (j < dependencies.length) {
            if (dependencies[j].getResolvedVersionId() != null) {
                VersionConstraint constraint = (VersionConstraint)dependencies[j].getUserObject();
                Version actualVersion = (Version)dependencies[j].getResolvedVersionId();
                BundleDescription supplier = this.state.getBundle(constraint.getName(), actualVersion);
                this.state.resolveConstraint(constraint, actualVersion, supplier);
            }
            ++j;
        }
    }

    public void bundleAdded(BundleDescription bundle) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.add(bundle, this.dependencies);
    }

    public void bundleRemoved(BundleDescription bundle) {
        if (this.dependencies == null) {
            return;
        }
        ResolverHelper.remove(bundle, this.dependencies);
    }

    public State getState() {
        return this.state;
    }

    public void flush() {
        this.dependencies = null;
    }

    private boolean resolvePackages() {
        PackageSpecification exported;
        int j;
        PackageSpecification[] required;
        int i;
        HashMap<String, PackageSpecification> availablePackages;
        boolean success;
        int tries = 0;
        do {
            ++tries;
            success = true;
            BundleDescription[] initialBundles = this.state.getResolvedBundles();
            availablePackages = new HashMap<String, PackageSpecification>(11);
            i = 0;
            while (i < initialBundles.length) {
                required = initialBundles[i].getPackages();
                j = 0;
                while (j < required.length) {
                    if (required[j].isExported()) {
                        Version existingVersion;
                        Version toExport = required[j].getVersionSpecification();
                        PackageSpecification existing = (PackageSpecification)availablePackages.get(required[j].getName());
                        Version version = existingVersion = existing == null ? null : existing.getVersionSpecification();
                        if (existingVersion == null || toExport != null && toExport.isGreaterThan(existingVersion)) {
                            availablePackages.put(required[j].getName(), required[j]);
                        }
                    }
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < initialBundles.length) {
                required = initialBundles[i].getPackages();
                j = 0;
                while (j < required.length) {
                    exported = (PackageSpecification)availablePackages.get(required[j].getName());
                    Version exportedVersion = exported == null ? null : exported.getVersionSpecification();
                    Version importedVersion = required[j].getVersionSpecification();
                    if (exported == null || importedVersion != null && (exportedVersion == null || !exportedVersion.isGreaterOrEqualTo(importedVersion))) {
                        this.unresolveRequirementChain(initialBundles[i]);
                        success = false;
                        break;
                    }
                    ++j;
                }
                ++i;
            }
        } while (!success);
        BundleDescription[] resolvedBundles = this.state.getResolvedBundles();
        i = 0;
        while (i < resolvedBundles.length) {
            required = resolvedBundles[i].getPackages();
            j = 0;
            while (j < required.length) {
                exported = (PackageSpecification)availablePackages.get(required[j].getName());
                this.state.resolveConstraint((VersionConstraint)required[j], exported.getVersionSpecification(), exported.getBundle());
                ++j;
            }
            ++i;
        }
        return tries > 1;
    }

    private void unresolveRequirementChain(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return;
        }
        this.state.resolveBundle(bundle, 2);
        if (bundle.getUniqueId() == null) {
            return;
        }
        IElementSet bundleElementSet = this.dependencies.getElementSet(bundle.getUniqueId());
        Collection requiring = bundleElementSet.getRequiringElements(bundle.getVersion());
        Iterator requiringIter = requiring.iterator();
        while (requiringIter.hasNext()) {
            IElement requiringElement = (IElement)requiringIter.next();
            BundleDescription requiringBundle = this.state.getBundle((String)requiringElement.getId(), (Version)requiringElement.getVersionId());
            if (requiringBundle == null) continue;
            this.unresolveRequirementChain(requiringBundle);
        }
    }

    private void unresolveBundle(BundleDescription bundle) {
        if (!bundle.isResolved()) {
            return;
        }
        if (this.dependencies != null) {
            ResolverHelper.unresolve(bundle, this.dependencies);
        }
    }
}

