/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Comparator;
import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IDependencySystem;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IMatchRule;
import org.eclipse.core.dependencies.ISelectionPolicy;
import org.eclipse.core.internal.dependencies.DependencySystem;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class ResolverHelper {
    private static final Version NULL_VERSION = new Version(0, 0, 0);
    private static final IMatchRule COMPATIBLE = new EclipseCompatibleMatchRule();
    private static final IMatchRule EQUIVALENT = new EclipseEquivalentMatchRule();
    private static final IMatchRule GREATER_OR_EQUAL = new EclipseGreaterOrEqualMatchRule();
    private static final IMatchRule PERFECT = new EclipsePerfectMatchRule();

    public static IMatchRule getMatchRule(int b) {
        switch (b) {
            case 2: {
                return EQUIVALENT;
            }
            case 4: {
                return GREATER_OR_EQUAL;
            }
            case 1: {
                return PERFECT;
            }
            case 3: {
                return COMPATIBLE;
            }
            case 0: {
                return COMPATIBLE;
            }
        }
        throw new IllegalArgumentException("match byte: " + b);
    }

    public static IElement createElement(BundleDescription bundleDescription, IDependencySystem system) {
        String uniqueId = ResolverHelper.getUniqueId(bundleDescription);
        Version version = ResolverHelper.getVersion(bundleDescription);
        return system.createElement(uniqueId, version, ResolverHelper.createPrerequisites(bundleDescription, system), true, bundleDescription);
    }

    private static Version getVersion(BundleDescription bundleDescription) {
        Version version = bundleDescription.getVersion();
        if (version == null) {
            version = Version.EMPTY_VERSION;
        }
        return version;
    }

    private static String getUniqueId(BundleDescription bundleDescription) {
        String uniqueId = bundleDescription.getUniqueId();
        if (uniqueId == null) {
            uniqueId = Long.toString(bundleDescription.getBundleId());
        }
        return uniqueId;
    }

    private static IDependency[] createUnsatisfiablePrerequisites(IDependencySystem system) {
        return new IDependency[]{system.createDependency("", new UnsatisfiableRule(), null, false, null)};
    }

    private static IDependency[] createPrerequisites(BundleDescription bundleDesc, IDependencySystem system) {
        int dependencyCount;
        BundleSpecification[] required = bundleDesc.getRequiredBundles();
        HostSpecification host = bundleDesc.getHost();
        int n = dependencyCount = required == null ? 0 : required.length;
        if (host != null) {
            ++dependencyCount;
        }
        if (dependencyCount == 0) {
            return new IDependency[0];
        }
        IDependency[] prereqs = new IDependency[dependencyCount];
        int i = 0;
        while (i < required.length) {
            prereqs[i] = ResolverHelper.createPrerequisite(system, (VersionConstraint)required[i]);
            ++i;
        }
        if (host != null) {
            prereqs[prereqs.length - 1] = ResolverHelper.createPrerequisite(system, (VersionConstraint)host);
        }
        return prereqs;
    }

    private static IDependency createPrerequisite(IDependencySystem system, VersionConstraint constraint) {
        boolean optional = constraint instanceof BundleSpecification && ((BundleSpecification)constraint).isOptional();
        Version requiredVersion = constraint.getVersionSpecification();
        if (NULL_VERSION.equals((Object)requiredVersion)) {
            requiredVersion = null;
        }
        return system.createDependency(constraint.getName(), ResolverHelper.getMatchRule(constraint.getMatchingRule()), requiredVersion, optional, constraint);
    }

    public static IDependencySystem createDependencySystem(ISelectionPolicy policy) {
        return new DependencySystem(new BundleVersionComparator(), policy);
    }

    public static IDependencySystem buildDependencySystem(State state, ISelectionPolicy selectionPolicy) {
        IDependencySystem dependencySystem = ResolverHelper.createDependencySystem(selectionPolicy);
        BundleDescription[] bundles = state.getBundles();
        int i = 0;
        while (i < bundles.length) {
            dependencySystem.addElement(ResolverHelper.createElement(bundles[i], dependencySystem));
            ++i;
        }
        return dependencySystem;
    }

    public static void remove(BundleDescription description, IDependencySystem system) {
        system.removeElement(ResolverHelper.getUniqueId(description), ResolverHelper.getVersion(description));
    }

    public static void add(BundleDescription description, IDependencySystem system) {
        system.addElement(ResolverHelper.createElement(description, system));
    }

    public static void unresolve(BundleDescription bundle, IDependencySystem system) {
        IElement element = system.getElement(ResolverHelper.getUniqueId(bundle), ResolverHelper.getVersion(bundle));
        if (element != null) {
            system.unresolve(new IElement[]{element});
        }
    }

    static class BundleVersionComparator
    implements Comparator {
        BundleVersionComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            Version v1 = (Version)arg0;
            Version v2 = (Version)arg1;
            return v1.isGreaterThan(v2) ? 1 : (v1.isPerfect(v2) ? 0 : -1);
        }
    }

    private static final class UnsatisfiableRule
    implements IMatchRule {
        UnsatisfiableRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return false;
        }

        public String toString() {
            return "unsatisfiable";
        }
    }

    private static final class EclipsePerfectMatchRule
    implements IMatchRule {
        EclipsePerfectMatchRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return ((Version)available).isPerfect((Version)required);
        }

        public String toString() {
            return "perfect";
        }
    }

    private static final class EclipseCompatibleMatchRule
    implements IMatchRule {
        EclipseCompatibleMatchRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return ((Version)available).isCompatibleWith((Version)required);
        }

        public String toString() {
            return "compatible";
        }
    }

    private static final class EclipseGreaterOrEqualMatchRule
    implements IMatchRule {
        EclipseGreaterOrEqualMatchRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return ((Version)available).isGreaterOrEqualTo((Version)required);
        }

        public String toString() {
            return "greaterOrEqual";
        }
    }

    private static final class EclipseEquivalentMatchRule
    implements IMatchRule {
        EclipseEquivalentMatchRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return ((Version)available).isEquivalentTo((Version)required);
        }

        public String toString() {
            return "equivalent";
        }
    }
}

