/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementSet;
import org.eclipse.core.dependencies.ISelectionPolicy;

public class Eclipse30SelectionPolicy
implements ISelectionPolicy {
    public Set selectMultiple(IElementSet elementSet) {
        Set<Object> selected = new HashSet<IElement>();
        Set previouslyResolvedSet = elementSet.getResolved();
        Iterator iter = previouslyResolvedSet.iterator();
        while (iter.hasNext()) {
            IElement previouslyResolved = (IElement)iter.next();
            if (!elementSet.getSatisfied().contains(previouslyResolved)) continue;
            selected.add(previouslyResolved);
        }
        Iterator requiringIter = elementSet.getRequiring().iterator();
        while (requiringIter.hasNext()) {
            IElementSet requiringNode = (IElementSet)requiringIter.next();
            Set requiringNodeSelectedVersions = requiringNode.getSelected();
            Iterator requiringVersionsIter = requiringNodeSelectedVersions.iterator();
            while (requiringVersionsIter.hasNext()) {
                IElement requiringSelectedVersion = (IElement)requiringVersionsIter.next();
                IDependency requiringSelectedVersionDependency = requiringSelectedVersion.getDependency(elementSet.getId());
                if (requiringSelectedVersionDependency == null) continue;
                IElement bestVersion = null;
                Iterator satisfiedIter = elementSet.getSatisfied().iterator();
                while (satisfiedIter.hasNext()) {
                    boolean betterThanBest;
                    IElement satisfiedVersion = (IElement)satisfiedIter.next();
                    boolean satisfiesDependency = requiringSelectedVersionDependency.getMatchRule().isSatisfied(requiringSelectedVersionDependency.getRequiredVersionId(), satisfiedVersion.getVersionId());
                    if (!satisfiesDependency) continue;
                    boolean bl = betterThanBest = bestVersion == null || elementSet.getSystem().compare(satisfiedVersion.getVersionId(), bestVersion.getVersionId()) > 0;
                    if (!betterThanBest) continue;
                    bestVersion = satisfiedVersion;
                }
                if (bestVersion == null) continue;
                selected.add(bestVersion);
            }
        }
        if (selected.isEmpty()) {
            IElement bestVersion = null;
            Iterator satisfiedIter = elementSet.getSatisfied().iterator();
            while (satisfiedIter.hasNext()) {
                boolean betterThanBest;
                IElement satisfiedVersion = (IElement)satisfiedIter.next();
                boolean bl = betterThanBest = bestVersion == null || elementSet.getSystem().compare(satisfiedVersion.getVersionId(), bestVersion.getVersionId()) > 0;
                if (!betterThanBest) continue;
                bestVersion = satisfiedVersion;
            }
            selected = Collections.singleton(bestVersion);
        }
        return selected;
    }

    public IElement selectSingle(IElementSet elementSet) {
        IElement highest;
        Set previouslyResolvedSet = elementSet.getResolved();
        if (!previouslyResolvedSet.isEmpty()) {
            IElement previouslyResolved = (IElement)previouslyResolvedSet.iterator().next();
            if (elementSet.getSatisfied().contains(previouslyResolved)) {
                return previouslyResolved;
            }
        }
        if (elementSet.getRequiring().isEmpty()) {
            highest = null;
            Iterator satisfiedIter = elementSet.getSatisfied().iterator();
            while (satisfiedIter.hasNext()) {
                IElement satisfiedVersion = (IElement)satisfiedIter.next();
                if (highest != null && elementSet.getSystem().compare(satisfiedVersion.getVersionId(), highest.getVersionId()) <= 0) continue;
                highest = satisfiedVersion;
            }
            return highest;
        }
        highest = null;
        int highestStatus = 0;
        Iterator satisfiedIter = elementSet.getSatisfied().iterator();
        while (satisfiedIter.hasNext()) {
            boolean higherThanHighest;
            boolean satisfiesAllMandatory = true;
            boolean satisfiesAll = true;
            boolean isRequired = false;
            IElement satisfiedVersion = (IElement)satisfiedIter.next();
            Iterator requiringIter = elementSet.getRequiring().iterator();
            while (requiringIter.hasNext()) {
                IElementSet requiringNode = (IElementSet)requiringIter.next();
                Set requiringNodeSelectedVersions = requiringNode.getSelected();
                Iterator requiringVersionsIter = requiringNodeSelectedVersions.iterator();
                while (requiringVersionsIter.hasNext()) {
                    IElement requiringSelectedVersion = (IElement)requiringVersionsIter.next();
                    IDependency requiringSelectedVersionDep = requiringSelectedVersion.getDependency(elementSet.getId());
                    if (requiringSelectedVersionDep == null) continue;
                    boolean satisfiesDependency = requiringSelectedVersionDep.getMatchRule().isSatisfied(requiringSelectedVersionDep.getRequiredVersionId(), satisfiedVersion.getVersionId());
                    isRequired |= satisfiesDependency;
                    satisfiesAll &= satisfiesDependency;
                    satisfiesAllMandatory &= satisfiesDependency | requiringSelectedVersionDep.isOptional();
                }
            }
            int status = satisfiesAll ? 3 : (satisfiesAllMandatory ? 2 : (isRequired ? 1 : 0));
            boolean bl = higherThanHighest = highest == null || elementSet.getSystem().compare(satisfiedVersion.getVersionId(), highest.getVersionId()) > 0;
            if (status <= highestStatus && (status != highestStatus || !higherThanHighest)) continue;
            highest = satisfiedVersion;
            highestStatus = status;
        }
        return highest;
    }
}

