/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.resolver;

import java.util.ArrayList;
import java.util.Dictionary;
import org.eclipse.osgi.framework.internal.core.KeyedElement;
import org.eclipse.osgi.internal.resolver.StateImpl;
import org.eclipse.osgi.internal.resolver.VersionConstraintImpl;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.PackageSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.service.resolver.Version;
import org.eclipse.osgi.service.resolver.VersionConstraint;

public class BundleDescriptionImpl
implements BundleDescription,
KeyedElement {
    private long bundleId = -1L;
    private String uniqueId;
    private String location;
    private int state;
    private Version version;
    private HostSpecification host;
    private PackageSpecification[] packages;
    private String[] providedPackages;
    private BundleSpecification[] requiredBundles;
    private State containingState;

    public String getLocation() {
        return this.location;
    }

    public boolean isResolved() {
        return (this.state & 4) != 0;
    }

    public State getContainingState() {
        return this.containingState;
    }

    public int getState() {
        return this.state;
    }

    public Version getVersion() {
        return this.version;
    }

    public BundleDescription[] getFragments() {
        if (this.host != null) {
            return new BundleDescription[0];
        }
        return ((StateImpl)this.containingState).getFragments(this);
    }

    public Dictionary getManifest() {
        return null;
    }

    public HostSpecification getHost() {
        return this.host;
    }

    public void setContainingState(State value) {
        this.containingState = value;
    }

    public void setHost(HostSpecification host) {
        this.host = host;
        if (host != null) {
            ((VersionConstraintImpl)host).setBundle(this);
        }
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setPackages(PackageSpecification[] packages) {
        this.packages = packages;
        if (packages != null) {
            int i = 0;
            while (i < packages.length) {
                ((VersionConstraintImpl)packages[i]).setBundle(this);
                ++i;
            }
        }
    }

    public void setProvidedPackages(String[] providedPackages) {
        this.providedPackages = providedPackages;
    }

    public void setRequiredBundles(BundleSpecification[] requiredBundles) {
        this.requiredBundles = requiredBundles;
        if (requiredBundles != null) {
            int i = 0;
            while (i < requiredBundles.length) {
                ((VersionConstraintImpl)requiredBundles[i]).setBundle(this);
                ++i;
            }
        }
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public PackageSpecification[] getPackages() {
        if (this.packages == null) {
            return new PackageSpecification[0];
        }
        return this.packages;
    }

    public String[] getProvidedPackages() {
        if (this.providedPackages == null) {
            return new String[0];
        }
        return this.providedPackages;
    }

    public BundleSpecification[] getRequiredBundles() {
        if (this.requiredBundles == null) {
            return new BundleSpecification[0];
        }
        return this.requiredBundles;
    }

    public BundleSpecification getRequiredBundle(String name) {
        if (this.requiredBundles == null) {
            return null;
        }
        int i = 0;
        while (i < this.requiredBundles.length) {
            if (this.requiredBundles[i].getName().equals(name)) {
                return this.requiredBundles[i];
            }
            ++i;
        }
        return null;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public PackageSpecification getPackage(String name) {
        if (this.packages == null) {
            return null;
        }
        int i = 0;
        while (i < this.packages.length) {
            if (this.packages[i].getName().equals(name)) {
                return this.packages[i];
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getUniqueId()) + "_" + this.getVersion();
    }

    public long getBundleId() {
        return this.bundleId;
    }

    public void setBundleId(long bundleId) {
        this.bundleId = bundleId;
    }

    public Object getKey() {
        return new Long(this.bundleId);
    }

    public boolean compare(KeyedElement other) {
        if (!(other instanceof BundleDescriptionImpl)) {
            return false;
        }
        BundleDescriptionImpl otherBundleDescription = (BundleDescriptionImpl)other;
        return this.bundleId == otherBundleDescription.bundleId;
    }

    public int getKeyHashCode() {
        return (int)(this.bundleId % Integer.MAX_VALUE);
    }

    public VersionConstraint[] getUnsatisfiedConstraints() {
        int i;
        if (this.containingState == null) {
            throw new IllegalStateException("Does not belong to a state");
        }
        ArrayList<Object> unsatisfied = new ArrayList<Object>();
        if (this.host != null && this.host.isResolved() && !this.isResolvable((VersionConstraint)this.host)) {
            unsatisfied.add(this.host);
        }
        if (this.requiredBundles != null) {
            i = 0;
            while (i < this.requiredBundles.length) {
                if (!this.requiredBundles[i].isResolved() && !this.isResolvable((VersionConstraint)this.requiredBundles[i])) {
                    unsatisfied.add(this.requiredBundles[i]);
                }
                ++i;
            }
        }
        if (this.packages != null) {
            i = 0;
            while (i < this.packages.length) {
                if (!this.packages[i].isResolved() && !this.isResolvable(this.packages[i])) {
                    unsatisfied.add(this.packages[i]);
                }
                ++i;
            }
        }
        return unsatisfied.toArray(new VersionConstraint[unsatisfied.size()]);
    }

    private boolean isResolvable(PackageSpecification specification) {
        if (specification.isExported()) {
            return true;
        }
        PackageSpecification exported = ((StateImpl)this.containingState).getExportedPackage(specification.getName(), null);
        if (exported == null) {
            return false;
        }
        return specification.isSatisfiedBy(exported.getVersionSpecification());
    }

    private boolean isResolvable(VersionConstraint specification) {
        BundleDescription[] availableBundles = this.containingState.getBundles(specification.getName());
        int i = 0;
        while (i < availableBundles.length) {
            if (availableBundles[i].isResolved() && specification.isSatisfiedBy(availableBundles[i].getVersion())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int hashCode() {
        if (this.uniqueId == null) {
            return (int)(this.bundleId % Integer.MAX_VALUE);
        }
        return (int)(this.bundleId * (long)this.uniqueId.hashCode() % Integer.MAX_VALUE);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BundleDescription)) {
            return false;
        }
        BundleDescription other = (BundleDescription)object;
        return this.bundleId == other.getBundleId() && (this.uniqueId == null & other.getUniqueId() == null || this.uniqueId != null && this.uniqueId.equals(other.getUniqueId()));
    }
}

