/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementSet;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.IElementSetVisitor;

public class SatisfactionVisitor
implements IElementSetVisitor {
    private int order;

    public SatisfactionVisitor(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public Collection getAncestors(ElementSet elementSet) {
        return elementSet.getRequired();
    }

    public Collection getDescendants(ElementSet elementSet) {
        return elementSet.getRequiring();
    }

    public void update(ElementSet elementSet) {
        if (elementSet.getRequired().isEmpty()) {
            elementSet.setSatisfied(elementSet.getAvailable());
            return;
        }
        HashSet<IElement> satisfied = new HashSet<IElement>();
        Iterator elementsIter = elementSet.getAvailable().iterator();
        while (elementsIter.hasNext()) {
            IElement element = (IElement)elementsIter.next();
            IDependency[] dependencies = element.getDependencies();
            boolean versionSatisfied = true;
            int i = 0;
            while (i < dependencies.length) {
                if (!dependencies[i].isOptional()) {
                    IElementSet requiredNode = elementSet.getSystem().getElementSet(dependencies[i].getRequiredObjectId());
                    Set requiredNodeSatisfiedVersions = requiredNode.getSatisfied();
                    boolean depSatisfied = false;
                    Iterator requiredNodeSatisfiedVersionsIter = requiredNodeSatisfiedVersions.iterator();
                    while (requiredNodeSatisfiedVersionsIter.hasNext()) {
                        IElement requiredSatisfiedVersion = (IElement)requiredNodeSatisfiedVersionsIter.next();
                        if (!dependencies[i].getMatchRule().isSatisfied(dependencies[i].getRequiredVersionId(), requiredSatisfiedVersion.getVersionId())) continue;
                        depSatisfied = true;
                        break;
                    }
                    if (!depSatisfied) {
                        versionSatisfied = false;
                        break;
                    }
                }
                ++i;
            }
            if (!versionSatisfied) continue;
            satisfied.add(element);
        }
        elementSet.setSatisfied(satisfied);
    }
}

