/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementSet;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.IElementSetVisitor;

public class ResolutionVisitor
implements IElementSetVisitor {
    private int order;

    public ResolutionVisitor(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public Collection getAncestors(ElementSet elementSet) {
        return elementSet.getRequired();
    }

    public Collection getDescendants(ElementSet elementSet) {
        return elementSet.getRequiring();
    }

    public void update(ElementSet elementSet) {
        if (elementSet.getRequired().isEmpty()) {
            elementSet.setResolved(elementSet.getSelected());
            return;
        }
        HashSet<IElement> resolved = new HashSet<IElement>();
        Iterator elementsIter = elementSet.getSelected().iterator();
        while (elementsIter.hasNext()) {
            IElement element = (IElement)elementsIter.next();
            IDependency[] dependencies = element.getDependencies();
            boolean versionResolved = true;
            int i = 0;
            while (i < dependencies.length) {
                IElementSet requiredNode = elementSet.getSystem().getElementSet(dependencies[i].getRequiredObjectId());
                ArrayList requiredNodeResolvedVersions = new ArrayList(requiredNode.getResolved());
                Object highestRequiredVersionId = null;
                Iterator requiredNodeResolvedVersionsIter = requiredNodeResolvedVersions.iterator();
                while (requiredNodeResolvedVersionsIter.hasNext()) {
                    IElement requiredResolvedVersion = (IElement)requiredNodeResolvedVersionsIter.next();
                    if (!dependencies[i].getMatchRule().isSatisfied(dependencies[i].getRequiredVersionId(), requiredResolvedVersion.getVersionId()) || highestRequiredVersionId != null && elementSet.getSystem().compare(requiredResolvedVersion.getVersionId(), highestRequiredVersionId) <= 0) continue;
                    highestRequiredVersionId = requiredResolvedVersion.getVersionId();
                }
                if (highestRequiredVersionId == null && !dependencies[i].isOptional()) {
                    versionResolved = false;
                    break;
                }
                elementSet.resolveDependency(element, dependencies[i], highestRequiredVersionId);
                ++i;
            }
            if (!versionResolved) continue;
            resolved.add(element);
        }
        elementSet.setResolved(resolved);
    }
}

