/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementChange;
import org.eclipse.core.dependencies.IResolutionDelta;
import org.eclipse.core.internal.dependencies.ElementChange;

public class ResolutionDelta
implements IResolutionDelta {
    private Map changes = new HashMap();

    ResolutionDelta() {
    }

    public IElementChange[] getAllChanges() {
        return this.changes.values().toArray(new IElementChange[this.changes.size()]);
    }

    public IElementChange getChange(Object id, Object versionId, Object userObject) {
        return (IElementChange)this.changes.get(new ElementIdentifier(id, versionId, userObject));
    }

    void recordChange(IElement element, int kind) {
        ElementChange existingChange = (ElementChange)this.getChange(element.getId(), element.getVersionId(), element.getUserObject());
        if (existingChange == null) {
            this.changes.put(new ElementIdentifier(element.getId(), element.getVersionId(), element.getUserObject()), new ElementChange(element, kind));
            return;
        }
        if (kind == 2) {
            if (existingChange.getKind() == 1) {
                this.changes.remove(new ElementIdentifier(element.getId(), element.getVersionId(), element.getUserObject()));
                return;
            }
            if ((existingChange.getKind() & 1) != 0) {
                existingChange.setKind(existingChange.getKind() & 0xFFFFFFFE | 2);
                return;
            }
        }
        existingChange.setKind(existingChange.getKind() | kind);
    }

    public String toString() {
        return this.changes.values().toString();
    }

    class ElementIdentifier {
        private Object id;
        private Object versionId;
        private Object userObject;

        ElementIdentifier(Object id, Object versionId, Object userObject) {
            this.id = id;
            this.versionId = versionId;
            this.userObject = userObject;
        }

        public int hashCode() {
            return this.id.hashCode() << 16 | this.versionId.hashCode() & 0xFFFF;
        }

        public boolean equals(Object anObject) {
            if (!(anObject instanceof ElementIdentifier)) {
                return false;
            }
            ElementIdentifier change = (ElementIdentifier)anObject;
            return change.userObject != null && change.userObject.equals(this.userObject) || this.id.equals(change.id) && this.versionId.equals(change.versionId) && change.userObject == null && this.userObject == null;
        }
    }
}

