/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementChange;

class ElementChange
implements IElementChange {
    private IElement element;
    private int kind;

    ElementChange(IElement element, int kind) {
        this.element = element;
        this.kind = kind;
    }

    public Object getVersionId() {
        return this.element.getVersionId();
    }

    public int getKind() {
        return this.kind;
    }

    public IElement getElement() {
        return this.element;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.element.getId());
        result.append('_');
        result.append(this.getVersionId());
        result.append(" (");
        result.append(this.getStatusName(this.getKind()));
        result.append(')');
        return result.toString();
    }

    private String getStatusName(int status) {
        StringBuffer statusStr = new StringBuffer();
        if ((status & 1) != 0) {
            statusStr.append("ADDED|");
        }
        if ((status & 2) != 0) {
            statusStr.append("REMOVED|");
        }
        if ((status & 4) != 0) {
            statusStr.append("RESOLVED|");
        }
        if ((status & 8) != 0) {
            statusStr.append("UNRESOLVED|");
        }
        if ((status & 0x10) != 0) {
            statusStr.append("LINKAGE_CHANGED|");
        }
        if (statusStr.length() == 0) {
            statusStr.append("UNKNOWN");
        } else {
            statusStr.deleteCharAt(statusStr.length() - 1);
        }
        return statusStr.toString();
    }

    void setKind(int kind) {
        this.kind = kind;
    }
}

