/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IDependencySystem;
import org.eclipse.core.dependencies.IElement;
import org.eclipse.core.dependencies.IElementSet;
import org.eclipse.core.dependencies.IMatchRule;
import org.eclipse.core.dependencies.IResolutionDelta;
import org.eclipse.core.dependencies.ISelectionPolicy;
import org.eclipse.core.internal.dependencies.ComputeNodeOrder;
import org.eclipse.core.internal.dependencies.Dependency;
import org.eclipse.core.internal.dependencies.Element;
import org.eclipse.core.internal.dependencies.ElementSet;
import org.eclipse.core.internal.dependencies.IElementSetVisitor;
import org.eclipse.core.internal.dependencies.ResolutionDelta;
import org.eclipse.core.internal.dependencies.ResolutionVisitor;
import org.eclipse.core.internal.dependencies.SatisfactionVisitor;
import org.eclipse.core.internal.dependencies.SelectionVisitor;

public class DependencySystem
implements IDependencySystem {
    public static final int SATISFACTION = 0;
    public static final int SELECTION = 1;
    public static final int RESOLUTION = 2;
    public static final int UP_TO_DATE = Integer.MAX_VALUE;
    private long elementCount;
    private int mark;
    private ResolutionDelta lastDelta = new ResolutionDelta();
    private ResolutionDelta delta = new ResolutionDelta();
    private Comparator comparator;
    private Map elementSets = new HashMap();
    private ISelectionPolicy selectionPolicy;
    private boolean debug;

    public DependencySystem(Comparator comparator, ISelectionPolicy selectionPolicy, boolean debug) {
        this.comparator = comparator;
        this.selectionPolicy = selectionPolicy;
        this.debug = debug;
    }

    public DependencySystem(Comparator comparator, ISelectionPolicy selectionPolicy) {
        this(comparator, selectionPolicy, false);
    }

    public IElementSet getElementSet(Object id) {
        ElementSet elementSet = (ElementSet)this.elementSets.get(id);
        if (elementSet == null) {
            elementSet = new ElementSet(id, this);
            this.elementSets.put(id, elementSet);
        }
        return elementSet;
    }

    public Collection discoverRoots() {
        LinkedList<ElementSet> roots = new LinkedList<ElementSet>();
        Iterator elementSetsIter = this.elementSets.values().iterator();
        while (elementSetsIter.hasNext()) {
            ElementSet elementSet = (ElementSet)elementSetsIter.next();
            if (!elementSet.isRoot()) continue;
            roots.add(elementSet);
        }
        return roots;
    }

    public IResolutionDelta resolve() throws IDependencySystem.CyclicSystemException {
        return this.resolve(true);
    }

    public IResolutionDelta resolve(boolean produceDelta) throws IDependencySystem.CyclicSystemException {
        Collection roots = this.discoverRoots();
        Collection satisfied = this.visit(roots, new SatisfactionVisitor(0));
        Collection selected = this.visit(satisfied, new SelectionVisitor(1, this.selectionPolicy));
        this.visit(selected, new ResolutionVisitor(2));
        this.lastDelta = this.delta;
        this.delta = new ResolutionDelta();
        this.pruneEmptySets();
        return this.lastDelta;
    }

    private void pruneEmptySets() {
        Iterator elementSetsIter = this.elementSets.values().iterator();
        while (elementSetsIter.hasNext()) {
            ElementSet elementSet = (ElementSet)elementSetsIter.next();
            if (elementSet.getElementCount() != 0 || elementSet.getRequiringCount() != 0) continue;
            elementSetsIter.remove();
        }
    }

    public Collection visit(Collection elementSets, IElementSetVisitor visitor) throws IDependencySystem.CyclicSystemException {
        int visitCounter = 0;
        int mark = this.getNewMark(visitor.getOrder());
        if (elementSets.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        LinkedList<ElementSet> leaves = new LinkedList<ElementSet>();
        while (!elementSets.isEmpty()) {
            LinkedList nextLevel = new LinkedList();
            Iterator elementSetsIter = elementSets.iterator();
            while (elementSetsIter.hasNext()) {
                ElementSet elementSet = (ElementSet)elementSetsIter.next();
                if (mark == elementSet.getVisitedMark()) continue;
                if (elementSet.getVisitedMark() == elementSet.getChangedMark() && visitor.getOrder() > this.getVisitorOrder(elementSet.getChangedMark())) {
                    elementSet.markNeedingUpdate(visitor.getOrder());
                }
                boolean shouldVisit = true;
                Iterator ancestorIter = visitor.getAncestors(elementSet).iterator();
                while (ancestorIter.hasNext()) {
                    ElementSet ancestorNode = (ElementSet)ancestorIter.next();
                    if (ancestorNode.getVisitedMark() != mark) {
                        shouldVisit = false;
                        break;
                    }
                    if (ancestorNode.getChangedMark() != mark) continue;
                    elementSet.markNeedingUpdate(visitor.getOrder());
                }
                if (!shouldVisit) continue;
                elementSet.setVisitedMark(mark);
                if (elementSet.isNeedingUpdate(visitor.getOrder())) {
                    visitor.update(elementSet);
                }
                ++visitCounter;
                if (visitor.getDescendants(elementSet).isEmpty()) {
                    leaves.add(elementSet);
                    continue;
                }
                nextLevel.addAll(visitor.getDescendants(elementSet));
            }
            elementSets = nextLevel;
        }
        if (visitCounter != this.elementSets.size()) {
            throw new IDependencySystem.CyclicSystemException(this.getCycleString());
        }
        return leaves;
    }

    public String getCycleString() {
        Object[] nodes = this.elementSets.values().toArray(new IElementSet[this.elementSets.size()]);
        ArrayList<Object[]> dependencies = new ArrayList<Object[]>();
        int i = 0;
        while (i < nodes.length) {
            Iterator required = nodes[i].getRequiring().iterator();
            while (required.hasNext()) {
                dependencies.add(new Object[]{nodes[i], required.next()});
            }
            ++i;
        }
        Object[][] cycles = ComputeNodeOrder.computeNodeOrder(nodes, (Object[][])dependencies.toArray((T[])new Object[dependencies.size()][]));
        StringBuffer result = new StringBuffer();
        int i2 = 0;
        while (i2 < cycles.length) {
            result.append("{");
            int j = 0;
            while (j < cycles[i2].length) {
                result.append(((IElementSet)cycles[i2][j]).getId());
                result.append(",");
                ++j;
            }
            result.deleteCharAt(result.length() - 1);
            result.append("},");
            ++i2;
        }
        result.deleteCharAt(result.length() - 1);
        return result.toString();
    }

    private int getVisitorOrder(int mark) {
        return mark & 0xFF;
    }

    private int getNewMark(int order) {
        this.mark = this.mark % 255 + 1;
        return (this.mark << 8) + (order & 0xFF);
    }

    public void addElements(IElement[] elementsToAdd) {
        int i = 0;
        while (i < elementsToAdd.length) {
            this.addElement(elementsToAdd[i]);
            ++i;
        }
    }

    public void addElement(IElement element) {
        ((ElementSet)this.getElementSet(element.getId())).addElement(element);
        ++this.elementCount;
    }

    public void removeElements(IElement[] elementsToRemove) {
        int i = 0;
        while (i < elementsToRemove.length) {
            this.removeElement(elementsToRemove[i]);
            ++i;
        }
    }

    public void removeElement(Object id, Object versionId) {
        ElementSet elementSet = (ElementSet)this.elementSets.get(id);
        if (elementSet == null) {
            return;
        }
        elementSet.removeElement(versionId);
    }

    public void removeElement(IElement element) {
        ElementSet elementSet = (ElementSet)this.elementSets.get(element.getId());
        if (elementSet == null) {
            return;
        }
        elementSet.removeElement(element);
    }

    public long getElementCount() {
        return this.elementCount;
    }

    public Map getNodes() {
        return this.elementSets;
    }

    public List getResolved() {
        int mark = this.getNewMark(2);
        LinkedList elementSets = this.discoverRoots();
        if (elementSets.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        LinkedList resolved = new LinkedList();
        while (!elementSets.isEmpty()) {
            LinkedList nextLevel = new LinkedList();
            Iterator elementSetsIter = elementSets.iterator();
            while (elementSetsIter.hasNext()) {
                Set resolvedInSet;
                ElementSet elementSet = (ElementSet)elementSetsIter.next();
                if (mark == elementSet.getVisitedMark() || (resolvedInSet = elementSet.getResolved()).isEmpty()) continue;
                boolean shouldVisit = true;
                Iterator ancestorIter = elementSet.getRequired().iterator();
                while (ancestorIter.hasNext()) {
                    ElementSet ancestorNode = (ElementSet)ancestorIter.next();
                    if (ancestorNode.getVisitedMark() == mark) continue;
                    shouldVisit = false;
                    break;
                }
                if (!shouldVisit) continue;
                elementSet.setVisitedMark(mark);
                resolved.addAll(resolvedInSet);
                nextLevel.addAll(elementSet.getRequiring());
            }
            elementSets = nextLevel;
        }
        return resolved;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        Iterator elementSetsIter = this.elementSets.values().iterator();
        while (elementSetsIter.hasNext()) {
            IElementSet elementSet = (IElementSet)elementSetsIter.next();
            Iterator elementsIter = elementSet.getAvailable().iterator();
            while (elementsIter.hasNext()) {
                IElement element = (IElement)elementsIter.next();
                result.append(element + ": " + Arrays.asList(element.getDependencies()));
                result.append(',');
            }
            result.deleteCharAt(result.length() - 1);
            result.append('\n');
        }
        return result.toString();
    }

    void recordElementStatusChanged(IElement element, int kind) {
        this.delta.recordChange(element, kind);
    }

    void recordDependencyChanged(Collection oldResolved, Collection newResolved, Map present) {
        IElement element;
        Iterator oldResolvedIter = oldResolved.iterator();
        while (oldResolvedIter.hasNext()) {
            element = (IElement)oldResolvedIter.next();
            if (newResolved.contains(element)) continue;
            this.delta.recordChange(element, 8);
        }
        Iterator newResolvedIter = newResolved.iterator();
        while (newResolvedIter.hasNext()) {
            element = (IElement)newResolvedIter.next();
            if (oldResolved.contains(element)) continue;
            this.delta.recordChange(element, 4);
        }
    }

    public IElement getElement(Object id, Object versionId) {
        ElementSet elementSet = (ElementSet)this.elementSets.get(id);
        if (elementSet == null) {
            return null;
        }
        return elementSet.getElement(versionId);
    }

    public IElement createElement(Object id, Object versionId, IDependency[] dependencies, boolean singleton, Object userObject) {
        return new Element(id, versionId, dependencies, singleton, userObject);
    }

    public IDependency createDependency(Object requiredObjectId, IMatchRule satisfactionRule, Object requiredVersionId, boolean optional, Object userObject) {
        return new Dependency(requiredObjectId, satisfactionRule, requiredVersionId, optional, userObject);
    }

    public int compare(Object obj1, Object obj2) {
        return this.comparator.compare(obj1, obj2);
    }

    public IResolutionDelta getLastDelta() {
        return this.lastDelta;
    }

    boolean inDebugMode() {
        return this.debug;
    }

    public Collection getRequiringElements(IElement required) {
        ElementSet containing = (ElementSet)this.getElementSet(required.getId());
        return containing.getRequiringElements(required.getVersionId());
    }

    public void unresolve(IElement[] elements) {
        int mark = this.getNewMark(2);
        int i = 0;
        while (i < elements.length) {
            ElementSet set = (ElementSet)this.getElementSet(elements[i].getId());
            if (set == null) {
                return;
            }
            set.unresolve(elements[i], mark);
            ++i;
        }
    }
}

