/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.dependencies;

import org.eclipse.core.dependencies.IDependency;
import org.eclipse.core.dependencies.IMatchRule;
import org.eclipse.core.internal.dependencies.Assert;

class Dependency
implements IDependency {
    private int changedMark;
    private Object requiredObjectId;
    private Object requiredVersionId;
    private IMatchRule matchRule;
    private boolean optional;
    private Object resolvedVersionId;
    private Object userObject;

    public Dependency(Object requiredObjectId, IMatchRule matchRule, Object requiredVersionId, boolean optional, Object userObject) {
        Assert.isNotNull(requiredObjectId);
        Assert.isNotNull(matchRule);
        this.requiredObjectId = requiredObjectId;
        this.requiredVersionId = requiredVersionId;
        this.matchRule = requiredVersionId == null ? new UnspecifiedVersionMatchRule() : matchRule;
        this.optional = optional;
        this.userObject = userObject;
    }

    public IMatchRule getMatchRule() {
        return this.matchRule;
    }

    public Object getRequiredObjectId() {
        return this.requiredObjectId;
    }

    public Object getRequiredVersionId() {
        return this.requiredVersionId;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public Object getResolvedVersionId() {
        return this.resolvedVersionId;
    }

    public void resolve(Object resolvedVersionId, int changedMark) {
        if (resolvedVersionId == null && this.resolvedVersionId == null || resolvedVersionId != null && resolvedVersionId.equals(this.resolvedVersionId)) {
            return;
        }
        this.resolvedVersionId = resolvedVersionId;
        this.changedMark = changedMark;
    }

    public int getChangedMark() {
        return this.changedMark;
    }

    public String toString() {
        return " -> " + this.getRequiredObjectId() + "_" + this.getRequiredVersionId() + " (" + this.getMatchRule() + ")";
    }

    public Object getUserObject() {
        return this.userObject;
    }

    class UnspecifiedVersionMatchRule
    implements IMatchRule {
        UnspecifiedVersionMatchRule() {
        }

        public boolean isSatisfied(Object required, Object available) {
            return true;
        }
    }
}

