/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.MessageConsolePartition;

public class MessageConsolePartitioner
implements IDocumentPartitioner,
IDocumentPartitionerExtension {
    private IDocument fDocument = null;
    private List fPartitions = new ArrayList(5);
    private MessageConsoleStream fLastStream = null;

    public void connect(IDocument document) {
        this.fDocument = document;
        document.setDocumentPartitioner((IDocumentPartitioner)this);
    }

    public void disconnect() {
        this.fDocument.setDocumentPartitioner(null);
    }

    public void documentAboutToBeChanged(DocumentEvent event) {
    }

    public boolean documentChanged(DocumentEvent event) {
        return this.documentChanged2(event) != null;
    }

    public String[] getLegalContentTypes() {
        return new String[]{MessageConsolePartition.MESSAGE_PARTITION_TYPE};
    }

    public String getContentType(int offset) {
        ITypedRegion partition = this.getPartition(offset);
        if (partition != null) {
            return partition.getType();
        }
        return null;
    }

    public ITypedRegion[] computePartitioning(int offset, int length) {
        if (offset == 0 && length == this.fDocument.getLength()) {
            return this.fPartitions.toArray(new ITypedRegion[this.fPartitions.size()]);
        }
        int end = offset + length;
        ArrayList<ITypedRegion> list = new ArrayList<ITypedRegion>();
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int partitionStart = partition.getOffset();
            int partitionEnd = partitionStart + partition.getLength();
            if (offset >= partitionStart && offset <= partitionEnd || offset < partitionStart && end >= partitionStart) {
                list.add(partition);
            }
            ++i;
        }
        return list.toArray(new ITypedRegion[list.size()]);
    }

    public ITypedRegion getPartition(int offset) {
        int i = 0;
        while (i < this.fPartitions.size()) {
            ITypedRegion partition = (ITypedRegion)this.fPartitions.get(i);
            int start = partition.getOffset();
            int end = start + partition.getLength();
            if (offset >= start && offset < end) {
                return partition;
            }
            ++i;
        }
        return null;
    }

    public IRegion documentChanged2(DocumentEvent event) {
        String text = event.getText();
        if (this.getDocument().getLength() == 0) {
            this.fPartitions.clear();
            return new Region(0, 0);
        }
        this.addPartition(new MessageConsolePartition(this.fLastStream, event.getOffset(), text.length()));
        ITypedRegion[] affectedRegions = this.computePartitioning(event.getOffset(), text.length());
        if (affectedRegions.length == 0) {
            return null;
        }
        if (affectedRegions.length == 1) {
            return affectedRegions[0];
        }
        int affectedLength = affectedRegions[0].getLength();
        int i = 1;
        while (i < affectedRegions.length) {
            ITypedRegion region = affectedRegions[i];
            affectedLength += region.getLength();
            ++i;
        }
        return new Region(affectedRegions[0].getOffset(), affectedLength);
    }

    private MessageConsolePartition addPartition(MessageConsolePartition partition) {
        if (this.fPartitions.isEmpty()) {
            this.fPartitions.add(partition);
        } else {
            int index = this.fPartitions.size() - 1;
            MessageConsolePartition last = (MessageConsolePartition)((Object)this.fPartitions.get(index));
            if (last.canBeCombinedWith(partition)) {
                partition = last.combineWith(partition);
                this.fPartitions.set(index, partition);
            } else {
                this.fPartitions.add(partition);
            }
        }
        return partition;
    }

    public MessageConsolePartitioner() {
        Document doc = new Document();
        this.connect((IDocument)doc);
    }

    public synchronized void appendToDocument(final String text, final MessageConsoleStream stream) {
        Runnable r = new Runnable(){

            public void run() {
                MessageConsolePartitioner.this.fLastStream = stream;
                try {
                    MessageConsolePartitioner.this.fDocument.replace(MessageConsolePartitioner.this.fDocument.getLength(), 0, text);
                }
                catch (BadLocationException badLocationException) {}
            }
        };
        Display display = ConsolePlugin.getStandardDisplay();
        if (display != null) {
            display.asyncExec(r);
        }
    }

    public IDocument getDocument() {
        return this.fDocument;
    }
}

