/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.console.ConsoleDropDownAction;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsoleWorkbenchPart;
import org.eclipse.ui.internal.console.IConsoleHelpContextIds;
import org.eclipse.ui.internal.console.PinConsoleAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class ConsoleView
extends PageBookView
implements IConsoleView,
IConsoleListener,
IPropertyChangeListener {
    private boolean fPinned = false;
    private IConsole fActiveConsole = null;
    private Map fConsoleToPart = new HashMap();
    private Map fPartToConsole = new HashMap();
    private PinConsoleAction fPinAction = null;
    private ConsoleDropDownAction fDisplayConsoleAction = null;

    private boolean isAvailable() {
        return this.getPageBook() != null && !this.getPageBook().isDisposed();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Object source = event.getSource();
        if (source instanceof IConsole && event.getProperty().equals("org.eclipse.jface.text") && source.equals(this.getConsole())) {
            this.updateTitle();
        }
    }

    public void partClosed(IWorkbenchPart part) {
        IConsole console;
        if (this.isPinned() && (console = (IConsole)this.fPartToConsole.get(part)) != null && console.equals(this.getConsole())) {
            this.pin(null);
        }
        super.partClosed(part);
        this.fPinAction.update();
    }

    public IConsole getConsole() {
        return this.fActiveConsole;
    }

    protected void showPageRec(PageBookView.PageRec pageRec) {
        if (!this.isPinned()) {
            super.showPageRec(pageRec);
            this.fActiveConsole = (IConsole)this.fPartToConsole.get(pageRec.part);
            this.updateTitle();
            if (this.fPinAction != null) {
                this.fPinAction.update();
            }
        }
    }

    protected void updateTitle() {
        IConsole console = this.getConsole();
        if (console == null) {
            this.setTitle(ConsoleMessages.getString("ConsoleView.0"));
        } else {
            this.setTitle(MessageFormat.format(ConsoleMessages.getString("ConsoleView.1"), console.getName()));
        }
    }

    protected void doDestroyPage(IWorkbenchPart part, PageBookView.PageRec pageRecord) {
        IPage page = pageRecord.page;
        page.dispose();
        pageRecord.dispose();
        IConsole console = (IConsole)this.fPartToConsole.get(part);
        console.removePropertyChangeListener(this);
        this.fPartToConsole.remove(part);
        this.fConsoleToPart.remove(console);
        this.fPinAction.update();
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart dummyPart) {
        ConsoleWorkbenchPart part = (ConsoleWorkbenchPart)dummyPart;
        IConsole console = part.getConsole();
        IPageBookViewPage page = console.createPage(this);
        this.initPage(page);
        page.createControl((Composite)this.getPageBook());
        console.addPropertyChangeListener(this);
        PageBookView.PageRec rec = new PageBookView.PageRec(dummyPart, (IPage)page);
        return rec;
    }

    protected boolean isImportant(IWorkbenchPart part) {
        return part instanceof ConsoleWorkbenchPart;
    }

    public void dispose() {
        super.dispose();
        ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this);
    }

    protected IPage createDefaultPage(PageBook book) {
        MessagePage page = new MessagePage();
        page.createControl((Composite)this.getPageBook());
        this.initPage((IPageBookViewPage)page);
        return page;
    }

    public void consolesAdded(final IConsole[] consoles) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < consoles.length) {
                        if (ConsoleView.this.isAvailable()) {
                            IConsole console = consoles[i];
                            ConsoleWorkbenchPart part = new ConsoleWorkbenchPart(console, ConsoleView.this.getSite());
                            ConsoleView.this.fConsoleToPart.put(console, part);
                            ConsoleView.this.fPartToConsole.put(part, console);
                            ConsoleView.this.partActivated(part);
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    public void consolesRemoved(final IConsole[] consoles) {
        if (this.isAvailable()) {
            Runnable r = new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < consoles.length) {
                        if (ConsoleView.this.isAvailable()) {
                            IConsole[] available;
                            IConsole console = consoles[i];
                            ConsoleWorkbenchPart part = (ConsoleWorkbenchPart)ConsoleView.this.fConsoleToPart.get(console);
                            if (part != null) {
                                ConsoleView.this.partClosed(part);
                            }
                            if (ConsoleView.this.getConsole() == null && (available = ConsolePlugin.getDefault().getConsoleManager().getConsoles()).length > 0) {
                                ConsoleView.this.display(available[available.length - 1]);
                            }
                        }
                        ++i;
                    }
                }
            };
            this.asyncExec(r);
        }
    }

    protected void createContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager("#PopUp");
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        if (this.getSite() != null) {
            this.getSite().registerContextMenu(menuMgr, null);
        }
    }

    protected void createActions() {
        this.fPinAction = new PinConsoleAction(this);
        this.fDisplayConsoleAction = new ConsoleDropDownAction(this);
    }

    protected void configureToolBar(IToolBarManager mgr) {
        mgr.add((IAction)this.fPinAction);
        mgr.add((IAction)this.fDisplayConsoleAction);
        mgr.add((IContributionItem)new Separator("launchGroup"));
        mgr.add((IContributionItem)new Separator("outputGroup"));
    }

    public void display(IConsole console) {
        ConsoleWorkbenchPart part;
        if (!this.isPinned() && (part = (ConsoleWorkbenchPart)this.fConsoleToPart.get(console)) != null) {
            this.partActivated(part);
        }
    }

    public void pin(IConsole console) {
        if (console == null) {
            this.fPinned = false;
        } else {
            this.display(console);
            this.fPinned = true;
        }
        if (this.fPinAction != null) {
            this.fPinAction.update();
        }
    }

    public boolean isPinned() {
        return this.fPinned;
    }

    protected IWorkbenchPart getBootstrapPart() {
        return null;
    }

    public void asyncExec(Runnable r) {
        if (this.isAvailable()) {
            this.getPageBook().getDisplay().asyncExec(r);
        }
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.createActions();
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        this.configureToolBar(tbm);
        this.updateForExistingConsoles();
        this.getViewSite().getActionBars().updateActionBars();
        WorkbenchHelp.setHelp((Control)parent, (String)IConsoleHelpContextIds.CONSOLE_VIEW);
    }

    private void updateForExistingConsoles() {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        this.consolesAdded(consoles);
        manager.addConsoleListener(this);
    }
}

