/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.console;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleListener;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.internal.console.ConsoleMessages;
import org.eclipse.ui.internal.console.ConsolePluginImages;
import org.eclipse.ui.internal.console.ShowConsoleAction;
import org.eclipse.ui.texteditor.IUpdate;

class ConsoleDropDownAction
extends Action
implements IMenuCreator,
IConsoleListener,
IUpdate {
    private IConsoleView fView;
    private Menu fMenu;

    public void update() {
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        this.setEnabled(consoles.length > 1);
    }

    public ConsoleDropDownAction(IConsoleView view) {
        this.fView = view;
        this.setText(ConsoleMessages.getString("ConsoleDropDownAction.0"));
        this.setToolTipText(ConsoleMessages.getString("ConsoleDropDownAction.1"));
        this.setImageDescriptor(ConsolePluginImages.getImageDescriptor("IMG_VIEW_CONSOLE"));
        this.setMenuCreator(this);
        ConsolePlugin.getDefault().getConsoleManager().addConsoleListener(this);
        this.update();
    }

    public void dispose() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fView = null;
        ConsolePlugin.getDefault().getConsoleManager().removeConsoleListener(this);
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = new Menu(parent);
        IConsole[] consoles = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        IConsole current = this.fView.getConsole();
        int i = 0;
        while (i < consoles.length) {
            IConsole console = consoles[i];
            ShowConsoleAction action = new ShowConsoleAction(this.fView, console);
            action.setChecked(console.equals(current));
            this.addActionToMenu(this.fMenu, action);
            ++i;
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    protected void addMenuSeparator() {
        new MenuItem(this.fMenu, 2);
    }

    public void run() {
    }

    public void consolesAdded(IConsole[] consoles) {
        Display display = ConsolePlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ConsoleDropDownAction.this.update();
            }
        });
    }

    public void consolesRemoved(IConsole[] consoles) {
        Display display = ConsolePlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                if (ConsoleDropDownAction.this.fMenu != null) {
                    ConsoleDropDownAction.this.fMenu.dispose();
                }
                ConsoleDropDownAction.this.update();
            }
        });
    }
}

