/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.console;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Font;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.internal.console.MessageConsolePage;
import org.eclipse.ui.internal.console.MessageConsolePartitioner;
import org.eclipse.ui.part.IPageBookViewPage;

public class MessageConsole
extends AbstractConsole {
    private Font fFont = null;
    public static final String P_FONT = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".P_FONT";
    public static final String P_STREAM_COLOR = String.valueOf(ConsolePlugin.getUniqueIdentifier()) + ".P_STREAM_COLOR";
    private MessageConsolePartitioner fPartitioner = new MessageConsolePartitioner();

    public MessageConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    public IPageBookViewPage createPage(IConsoleView view) {
        return new MessageConsolePage(view, this);
    }

    public void setFont(Font font) {
        Font old = this.fFont;
        this.fFont = font;
        this.firePropertyChange(this, P_FONT, old, font);
    }

    public Font getFont() {
        if (this.fFont == null) {
            return JFaceResources.getTextFont();
        }
        return this.fFont;
    }

    public MessageConsoleStream newMessageStream() {
        return new MessageConsoleStream(this);
    }

    protected synchronized void appendToDocument(String text, MessageConsoleStream stream) {
        this.fPartitioner.appendToDocument(text, stream);
    }

    public IDocument getDocument() {
        return this.fPartitioner.getDocument();
    }
}

