/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSListener;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;

public class KnownRepositories {
    private List repositoryListeners = new ArrayList();
    private Map repositories = new HashMap();
    private static KnownRepositories instance;

    public static synchronized KnownRepositories getInstance() {
        if (instance == null) {
            instance = new KnownRepositories();
        }
        return instance;
    }

    public void addRepositoryListener(ICVSListener listener) {
        List list = this.repositoryListeners;
        synchronized (list) {
            this.repositoryListeners.add(listener);
        }
    }

    public void removeRepositoryListener(ICVSListener listener) {
        List list = this.repositoryListeners;
        synchronized (list) {
            this.repositoryListeners.remove(listener);
        }
    }

    private ICVSListener[] getListeners() {
        List list = this.repositoryListeners;
        synchronized (list) {
            return this.repositoryListeners.toArray(new ICVSListener[this.repositoryListeners.size()]);
        }
    }

    private void fireNotification(Notification notification) {
        ICVSListener[] listeners = this.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ICVSListener listener = listeners[i];
            notification.run(listener);
            ++i;
        }
    }

    private void addToRepositoriesCache(final ICVSRepositoryLocation repository) {
        this.repositories.put(repository.getLocation(), repository);
        this.fireNotification(new Notification(){

            public void notify(ICVSListener listener) {
                listener.repositoryAdded(repository);
            }
        });
    }

    private void removeFromRepositoriesCache(final ICVSRepositoryLocation repository) {
        if (this.repositories.remove(repository.getLocation()) != null) {
            this.fireNotification(new Notification(){

                public void notify(ICVSListener listener) {
                    listener.repositoryRemoved(repository);
                }
            });
        }
    }

    public ICVSRepositoryLocation createRepository(Properties configuration) throws CVSException {
        CVSRepositoryLocation location = CVSRepositoryLocation.fromProperties(configuration);
        CVSRepositoryLocation existingLocation = (CVSRepositoryLocation)this.repositories.get(location.getLocation());
        if (existingLocation != null) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSProvider.alreadyExists")));
        }
        return location;
    }

    public void addRepository(ICVSRepositoryLocation repository) throws CVSException {
        CVSRepositoryLocation existingLocation = (CVSRepositoryLocation)this.repositories.get(repository.getLocation());
        if (existingLocation != null) {
            ((CVSRepositoryLocation)repository).updateCache();
        } else {
            this.addToRepositoriesCache(repository);
            ((CVSRepositoryLocation)repository).updateCache();
        }
    }

    public void disposeRepository(ICVSRepositoryLocation repository) throws CVSException {
        ((CVSRepositoryLocation)repository).dispose();
        this.removeFromRepositoriesCache(repository);
    }

    public boolean isKnownRepository(String location) {
        return this.repositories.get(location) != null;
    }

    public ICVSRepositoryLocation[] getKnownRepositories() {
        return this.repositories.values().toArray(new ICVSRepositoryLocation[this.repositories.size()]);
    }

    public ICVSRepositoryLocation getRepository(String location) throws CVSException {
        ICVSRepositoryLocation repository = (ICVSRepositoryLocation)this.repositories.get(location);
        if (repository == null) {
            repository = CVSRepositoryLocation.fromString(location);
            this.addToRepositoriesCache(repository);
        }
        return repository;
    }

    private abstract class Notification
    implements ISafeRunnable {
        private ICVSListener listener;

        Notification() {
        }

        public void handleException(Throwable exception) {
        }

        public void run(ICVSListener listener) {
            this.listener = listener;
            Platform.run((ISafeRunnable)this);
        }

        public void run() throws Exception {
            this.notify(this.listener);
        }

        protected abstract void notify(ICVSListener var1);
    }
}

