/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.internal.jobs.JobManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.syncinfo.CVSRemoteSynchronizer;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class RemoteTagSynchronizer
extends CVSRemoteSynchronizer {
    private CVSTag tag;

    public RemoteTagSynchronizer(String id, CVSTag tag) {
        super(id);
        this.tag = tag;
    }

    public void collectChanges(IResource local, IRemoteResource remote, Collection changedResources, int depth, IProgressMonitor monitor) throws TeamException {
        byte[] remoteBytes = this.getRemoteSyncBytes(local, remote);
        boolean changed = remoteBytes == null ? this.setRemoteDoesNotExist(local) : this.setSyncBytes(local, remoteBytes);
        if (changed) {
            changedResources.add(local);
        }
        if (depth == 0) {
            return;
        }
        Map children = this.mergedMembers(local, remote, monitor);
        Iterator it = children.keySet().iterator();
        while (it.hasNext()) {
            IResource localChild = (IResource)it.next();
            IRemoteResource remoteChild = (IRemoteResource)children.get(localChild);
            this.collectChanges(localChild, remoteChild, changedResources, depth == 2 ? 2 : 0, monitor);
        }
        IResource[] resources = this.getChildrenWithSyncBytes(local);
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (!children.containsKey(resource)) {
                this.removeSyncBytes(resource, 2);
                changedResources.add(resource);
            }
            ++i;
        }
    }

    protected Map mergedMembers(IResource local, IRemoteResource remote, IProgressMonitor progress) throws TeamException {
        HashMap<IResource, IRemoteResource> mergedResources = new HashMap<IResource, IRemoteResource>();
        IRemoteResource[] remoteChildren = this.getRemoteChildren(remote, progress);
        IResource[] localChildren = this.getLocalChildren(local);
        if (remoteChildren.length > 0 || localChildren.length > 0) {
            String name;
            int i;
            HashSet<String> allSet = new HashSet<String>(20);
            HashMap<String, IResource> localSet = null;
            HashMap<String, IRemoteResource> remoteSet = null;
            if (localChildren.length > 0) {
                localSet = new HashMap<String, IResource>(10);
                i = 0;
                while (i < localChildren.length) {
                    IResource localChild = localChildren[i];
                    name = localChild.getName();
                    localSet.put(name, localChild);
                    allSet.add(name);
                    ++i;
                }
            }
            if (remoteChildren.length > 0) {
                remoteSet = new HashMap<String, IRemoteResource>(10);
                i = 0;
                while (i < remoteChildren.length) {
                    IRemoteResource remoteChild = remoteChildren[i];
                    name = remoteChild.getName();
                    remoteSet.put(name, remoteChild);
                    allSet.add(name);
                    ++i;
                }
            }
            Iterator e = allSet.iterator();
            while (e.hasNext()) {
                IRemoteResource remoteChild;
                String keyChildName = (String)e.next();
                if (progress != null && progress.isCanceled()) {
                    throw new OperationCanceledException();
                }
                IResource localChild = localSet != null ? (IResource)localSet.get(keyChildName) : null;
                IRemoteResource iRemoteResource = remoteChild = remoteSet != null ? (IRemoteResource)remoteSet.get(keyChildName) : null;
                if (localChild == null) {
                    Assert.isTrue(remoteChild != null);
                    boolean isContainer = remoteChild.isContainer();
                    localChild = this.getResourceChild(local, keyChildName, isContainer);
                }
                mergedResources.put(localChild, remoteChild);
            }
        }
        return mergedResources;
    }

    private IRemoteResource[] getRemoteChildren(IRemoteResource remote, IProgressMonitor progress) throws TeamException {
        return remote != null ? remote.members(progress) : new IRemoteResource[]{};
    }

    private IResource[] getLocalChildren(IResource local) throws TeamException {
        IResource[] localChildren = null;
        if (local.getType() != 1 && (local.exists() || local.isPhantom())) {
            ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)local);
            if (local.exists() || cvsFolder.isCVSFolder()) {
                ICVSResource[] cvsChildren = cvsFolder.members(24);
                ArrayList<IResource> resourceChildren = new ArrayList<IResource>();
                int i = 0;
                while (i < cvsChildren.length) {
                    ICVSResource cvsResource = cvsChildren[i];
                    resourceChildren.add(cvsResource.getIResource());
                    ++i;
                }
                localChildren = resourceChildren.toArray(new IResource[resourceChildren.size()]);
            }
        }
        if (localChildren == null) {
            localChildren = new IResource[]{};
        }
        return localChildren;
    }

    private IResource[] getChildrenWithSyncBytes(IResource local) throws TeamException {
        try {
            if (local.getType() != 1 && (local.exists() || local.isPhantom())) {
                IResource[] allChildren = ((IContainer)local).members(true);
                ArrayList<IResource> childrenWithSyncBytes = new ArrayList<IResource>();
                int i = 0;
                while (i < allChildren.length) {
                    IResource resource = allChildren[i];
                    if (this.internalGetSyncBytes(resource) != null) {
                        childrenWithSyncBytes.add(resource);
                    }
                    ++i;
                }
                return childrenWithSyncBytes.toArray(new IResource[childrenWithSyncBytes.size()]);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
        return new IResource[0];
    }

    private byte[] internalGetSyncBytes(IResource resource) throws TeamException {
        return super.getSyncBytes(resource);
    }

    private IResource getResourceChild(IResource parent, String childName, boolean isContainer) {
        if (parent.getType() == 1) {
            return null;
        }
        if (isContainer) {
            return ((IContainer)parent).getFolder((IPath)new Path(childName));
        }
        return ((IContainer)parent).getFile((IPath)new Path(childName));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IResource[] refresh(IResource resource, int depth, boolean cacheFileContentsHint, IProgressMonitor monitor) throws TeamException {
        IProject rule;
        ArrayList changedResources;
        block8: {
            IResource[] iResourceArray;
            block7: {
                changedResources = new ArrayList();
                rule = resource.getProject();
                monitor.beginTask(null, 100);
                try {
                    JobManager.getInstance().beginRule((ISchedulingRule)rule, monitor);
                    if (!resource.getProject().isAccessible()) {
                        iResourceArray = new IResource[]{};
                        Object var11_8 = null;
                        break block7;
                    }
                    monitor.setTaskName(Policy.bind("RemoteTagSynchronizer.0", resource.getFullPath().makeRelative().toString()));
                    ICVSRemoteResource tree = this.buildRemoteTree(resource, depth, cacheFileContentsHint, Policy.subMonitorFor(monitor, 70));
                    IProgressMonitor sub = Policy.infiniteSubMonitorFor(monitor, 30);
                    try {
                        sub.beginTask(null, 64);
                        this.collectChanges(resource, tree, changedResources, depth, sub);
                    }
                    catch (Throwable throwable) {
                        Object var9_14 = null;
                        sub.done();
                        throw throwable;
                    }
                    {
                        Object var9_15 = null;
                        sub.done();
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_9 = null;
                    JobManager.getInstance().endRule((ISchedulingRule)rule);
                    monitor.done();
                    throw throwable;
                }
            }
            JobManager.getInstance().endRule((ISchedulingRule)rule);
            monitor.done();
            return iResourceArray;
        }
        Object var11_10 = null;
        JobManager.getInstance().endRule((ISchedulingRule)rule);
        monitor.done();
        return changedResources.toArray(new IResource[changedResources.size()]);
    }

    protected ICVSRemoteResource buildRemoteTree(IResource resource, int depth, boolean cacheFileContentsHint, IProgressMonitor monitor) throws TeamException {
        return CVSWorkspaceRoot.getRemoteTree(resource, this.tag, cacheFileContentsHint, monitor);
    }
}

