/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.BaseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.RemoteTagSynchronizer;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class OptimizedRemoteSynchronizer
extends RemoteTagSynchronizer {
    private BaseSynchronizer baseSynchronizer = new BaseSynchronizer();

    public OptimizedRemoteSynchronizer(String id) {
        this(id, null);
    }

    public OptimizedRemoteSynchronizer(String id, CVSTag tag) {
        super(id, tag);
    }

    public byte[] getSyncBytes(IResource resource) throws TeamException {
        byte[] bytes = this.internalGetSyncBytes(resource);
        if (bytes == null && !this.isRemoteKnown(resource)) {
            bytes = this.baseSynchronizer.getSyncBytes(resource);
        }
        return bytes;
    }

    public boolean setSyncBytes(IResource resource, byte[] bytes) throws TeamException {
        byte[] baseBytes = this.baseSynchronizer.getSyncBytes(resource);
        if (baseBytes != null && Util.equals(baseBytes, bytes)) {
            return this.removeSyncBytes(resource, 0);
        }
        return super.setSyncBytes(resource, bytes);
    }

    public BaseSynchronizer getBaseSynchronizer() {
        return this.baseSynchronizer;
    }

    private byte[] internalGetSyncBytes(IResource resource) throws TeamException {
        return super.getSyncBytes(resource);
    }

    protected byte[] getRemoteSyncBytes(IResource local, ICVSRemoteResource remote) throws TeamException {
        if (remote == null && local.getType() == 2) {
            return this.baseSynchronizer.getSyncBytes(local);
        }
        return super.getRemoteSyncBytes(local, remote);
    }
}

