/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.RemoteBytesSynchronizer;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;

public abstract class CVSRemoteSynchronizer
extends RemoteBytesSynchronizer {
    public static final String SYNC_KEY_QUALIFIER = "org.eclipse.team.cvs";

    public CVSRemoteSynchronizer(String id) {
        super(new QualifiedName(SYNC_KEY_QUALIFIER, id));
    }

    public IRemoteResource getRemoteResource(IResource resource) throws TeamException {
        byte[] remoteBytes = this.getSyncBytes(resource);
        if (remoteBytes == null) {
            return null;
        }
        if (resource.getType() == 1) {
            byte[] parentBytes = this.getSyncBytes((IResource)resource.getParent());
            if (parentBytes == null) {
                CVSProviderPlugin.log((CoreException)((Object)new CVSException(Policy.bind("ResourceSynchronizer.missingParentBytesOnGet", this.getSyncName().toString(), resource.getFullPath().toString()))));
                return null;
            }
            return RemoteFile.fromBytes(resource, remoteBytes, parentBytes);
        }
        return RemoteFolder.fromBytes(resource, remoteBytes);
    }

    public boolean setSyncBytes(IResource resource, byte[] bytes) throws TeamException {
        boolean changed = super.setSyncBytes(resource, bytes);
        if (resource.getType() == 1 && this.getSyncBytes(resource) != null && !this.parentHasSyncBytes(resource)) {
            CVSProviderPlugin.log((CoreException)((Object)new TeamException(Policy.bind("ResourceSynchronizer.missingParentBytesOnSet", this.getSyncName().toString(), resource.getFullPath().toString()))));
        }
        return changed;
    }

    protected boolean parentHasSyncBytes(IResource resource) throws TeamException {
        if (resource.getType() == 4) {
            return true;
        }
        return this.getSyncBytes((IResource)resource.getParent()) != null;
    }

    protected byte[] getRemoteSyncBytes(IResource local, IRemoteResource remote) throws TeamException {
        if (remote != null) {
            return ((RemoteResource)remote).getSyncBytes();
        }
        return null;
    }
}

