/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.syncinfo;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.RemoteSynchronizer;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.EclipseSynchronizer;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;

public class BaseSynchronizer
extends RemoteSynchronizer {
    public byte[] getSyncBytes(IResource resource) throws CVSException {
        if (resource.getType() == 1) {
            byte[] bytes = EclipseSynchronizer.getInstance().getSyncBytes(resource);
            if (bytes != null) {
                if (ResourceSyncInfo.isDeletion(bytes)) {
                    bytes = ResourceSyncInfo.convertFromDeletion(bytes);
                } else if (ResourceSyncInfo.isAddition(bytes)) {
                    bytes = null;
                }
            }
            return bytes;
        }
        FolderSyncInfo info = EclipseSynchronizer.getInstance().getFolderSync((IContainer)resource);
        if (info == null) {
            return null;
        }
        return info.getBytes();
    }

    protected QualifiedName getSyncName() {
        return new QualifiedName("org.eclipse.team.cvs.core", "workspace");
    }

    public IResource[] refresh(IResource resource, int depth, boolean cacheFileContentsHint, IProgressMonitor monitor) throws TeamException {
        IResource[] iResourceArray;
        try {
            monitor.beginTask(null, 100);
            iResourceArray = new IResource[]{};
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return iResourceArray;
    }

    public IRemoteResource getRemoteResource(IResource resource) throws TeamException {
        return CVSWorkspaceRoot.getRemoteResourceFor(resource);
    }

    public boolean hasRemote(IResource resource) throws TeamException {
        return this.getSyncBytes(resource) != null;
    }
}

