/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.SyncInfoCache;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

class SynchronizerSyncInfoCache
extends SyncInfoCache {
    public SynchronizerSyncInfoCache() {
        this.getWorkspaceSynchronizer().add(SyncInfoCache.FOLDER_SYNC_KEY);
        this.getWorkspaceSynchronizer().add(SyncInfoCache.RESOURCE_SYNC_KEY);
    }

    private ISynchronizer getWorkspaceSynchronizer() {
        return ResourcesPlugin.getWorkspace().getSynchronizer();
    }

    void flush(IProject project) throws CVSException {
        this.purgeCache((IContainer)project, true);
    }

    void flush(IFolder folder) throws CVSException {
        this.purgeCache((IContainer)folder, false);
    }

    FolderSyncInfo getCachedFolderSync(IContainer container) throws CVSException {
        try {
            byte[] bytes = this.getWorkspaceSynchronizer().getSyncInfo(SyncInfoCache.FOLDER_SYNC_KEY, (IResource)container);
            if (bytes == null) {
                return null;
            }
            return FolderSyncInfo.getFolderSyncInfo(bytes);
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    void setCachedFolderSync(IContainer container, FolderSyncInfo info, boolean canModifyWorkspace) throws CVSException {
        try {
            if (info == null) {
                if (container.exists() || container.isPhantom()) {
                    this.getWorkspaceSynchronizer().flushSyncInfo(SyncInfoCache.FOLDER_SYNC_KEY, (IResource)container, 0);
                }
            } else {
                this.getWorkspaceSynchronizer().setSyncInfo(SyncInfoCache.FOLDER_SYNC_KEY, (IResource)container, info.getBytes());
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    byte[] getCachedSyncBytes(IResource resource) throws CVSException {
        try {
            byte[] bytes = this.getWorkspaceSynchronizer().getSyncInfo(SyncInfoCache.RESOURCE_SYNC_KEY, resource);
            if (bytes != null && resource.getType() == 1) {
                if (ResourceSyncInfo.isAddition(bytes)) {
                    bytes = null;
                } else if (!ResourceSyncInfo.isDeletion(bytes)) {
                    bytes = ResourceSyncInfo.convertToDeletion(bytes);
                }
            }
            return bytes;
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    void setCachedSyncBytes(IResource resource, byte[] syncBytes, boolean canModifyWorkspace) throws CVSException {
        byte[] oldBytes = this.getCachedSyncBytes(resource);
        try {
            if (syncBytes == null) {
                if (oldBytes != null && (resource.exists() || resource.isPhantom())) {
                    this.checkCanModifyWorkspace(resource, canModifyWorkspace);
                    this.getWorkspaceSynchronizer().flushSyncInfo(SyncInfoCache.RESOURCE_SYNC_KEY, resource, 0);
                }
            } else if (oldBytes == null || !Util.equals(ResourceSyncInfo.convertToDeletion(syncBytes), ResourceSyncInfo.convertToDeletion(oldBytes))) {
                this.checkCanModifyWorkspace(resource, canModifyWorkspace);
                this.getWorkspaceSynchronizer().setSyncInfo(SyncInfoCache.RESOURCE_SYNC_KEY, resource, syncBytes);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }

    private void checkCanModifyWorkspace(IResource resource, boolean canModifyWorkspace) throws CVSException {
        if (!canModifyWorkspace) {
            throw new CVSException(2, -25, Policy.bind("SynchronizerSyncInfoCache.0", resource.getFullPath().toString()));
        }
    }

    String getDirtyIndicator(IResource resource) throws CVSException {
        if (resource.getType() == 1) {
            return this.getCachedSyncBytes(resource) != null ? "d" : "c";
        }
        return this.calculateDirtyCountForPhantomFolder((IContainer)resource);
    }

    void setDirtyIndicator(IResource resource, String indicator) throws CVSException {
    }

    void flushDirtyCache(IResource container) throws CVSException {
    }

    boolean isSyncInfoLoaded(IContainer parent) throws CVSException {
        return true;
    }

    boolean isResourceSyncInfoCached(IContainer container) throws CVSException {
        return true;
    }

    void setResourceSyncInfoCached(IContainer container) throws CVSException {
    }

    boolean isFolderSyncInfoCached(IContainer container) throws CVSException {
        return true;
    }

    boolean isDirtyCacheFlushed(IContainer resource) throws CVSException {
        return false;
    }

    private String calculateDirtyCountForPhantomFolder(IContainer parent) throws CVSException {
        ICVSFolder cvsFolder = CVSWorkspaceRoot.getCVSFolderFor(parent);
        if (this.getCachedFolderSync(parent) == null) {
            return "c";
        }
        String indicator = "c";
        ICVSResource[] children = cvsFolder.members(80);
        int i = 0;
        while (i < children.length) {
            ICVSResource resource = children[i];
            if (!resource.isFolder()) {
                indicator = "d";
                break;
            }
            indicator = this.calculateDirtyCountForPhantomFolder((IContainer)resource.getIResource());
            ++i;
        }
        return indicator;
    }

    public void purgeCache(IContainer root, boolean deep) throws CVSException {
        int depth = deep ? 2 : 0;
        try {
            if (root.exists() || root.isPhantom()) {
                this.getWorkspaceSynchronizer().flushSyncInfo(SyncInfoCache.RESOURCE_SYNC_KEY, (IResource)root, depth);
            }
            if (root.exists() || root.isPhantom()) {
                this.getWorkspaceSynchronizer().flushSyncInfo(SyncInfoCache.FOLDER_SYNC_KEY, (IResource)root, depth);
            }
        }
        catch (CoreException e) {
            throw CVSException.wrapException(e);
        }
    }
}

