/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.IUpdateMessageListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.UpdateListener;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderMemberFetcher;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class RemoteFolder
extends RemoteResource
implements ICVSRemoteFolder,
ICVSFolder {
    protected static final int CHILD_DOES_NOT_EXIST = 1000;
    protected FolderSyncInfo folderInfo;
    private ICVSRemoteResource[] children;
    private ICVSRepositoryLocation repository;

    public static RemoteFolder fromBytes(IResource local, byte[] bytes) throws CVSException {
        Assert.isNotNull(bytes);
        Assert.isTrue(local.getType() != 1);
        FolderSyncInfo syncInfo = FolderSyncInfo.getFolderSyncInfo(bytes);
        return new RemoteFolder(null, local.getName(), CVSProviderPlugin.getPlugin().getRepository(syncInfo.getRoot()), syncInfo.getRepository(), syncInfo.getTag(), syncInfo.getIsStatic());
    }

    public RemoteFolder(RemoteFolder parent, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag) {
        this(parent, repositoryRelativePath == null ? "" : Util.getLastSegment(repositoryRelativePath), repository, repositoryRelativePath, tag, false);
    }

    public RemoteFolder(RemoteFolder parent, String name, ICVSRepositoryLocation repository, String repositoryRelativePath, CVSTag tag, boolean isStatic) {
        super(parent, name);
        if (repository != null) {
            this.folderInfo = new FolderSyncInfo(repositoryRelativePath.toString(), repository.getLocation(), tag, isStatic);
        }
        this.repository = repository;
    }

    public void accept(ICVSResourceVisitor visitor) throws CVSException {
        visitor.visitFolder(this);
    }

    public void accept(ICVSResourceVisitor visitor, boolean recurse) throws CVSException {
        visitor.visitFolder(this);
        ICVSResource[] resources = recurse ? this.members(127) : this.members(1);
        int i = 0;
        while (i < resources.length) {
            resources[i].accept(visitor, recurse);
            ++i;
        }
    }

    public boolean exists(IProgressMonitor monitor) throws TeamException {
        try {
            this.members(monitor);
            return true;
        }
        catch (CVSException e) {
            if (e.getStatus().getCode() == -17) {
                return false;
            }
            throw e;
        }
    }

    protected boolean exists(ICVSRemoteResource child, IProgressMonitor monitor) throws CVSException {
        return this.exists(child, this.getTag(), monitor);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean exists(ICVSRemoteResource child, CVSTag tag, IProgressMonitor monitor) throws CVSException {
        boolean bl;
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RemoteFolder.exists"), 100);
        try {
            boolean[] exists;
            block10: {
                exists = new boolean[]{true};
                IUpdateMessageListener listener = new IUpdateMessageListener(){

                    public void directoryInformation(ICVSFolder parent, String path, boolean newDirectory) {
                        exists[0] = true;
                    }

                    public void directoryDoesNotExist(ICVSFolder parent, String path) {
                        exists[0] = false;
                    }

                    public void fileInformation(int type, ICVSFolder parent, String filename) {
                    }

                    public void fileDoesNotExist(ICVSFolder parent, String filename) {
                        exists[0] = false;
                    }
                };
                ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                localOptions.add(Update.RETRIEVE_ABSENT_DIRECTORIES);
                if (tag != null && tag.getType() != 0) {
                    localOptions.add(Update.makeTagOption(tag));
                }
                boolean retry = false;
                Session session = new Session(this.getRepository(), this, false);
                session.open(Policy.subMonitorFor(progress, 10), false);
                try {
                    IStatus status = Command.UPDATE.execute(session, new Command.GlobalOption[]{Command.DO_NOT_CHANGE}, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new ICVSResource[]{child}, (ICommandOutputListener)new UpdateListener(listener), Policy.subMonitorFor(progress, 70));
                    if (status.getCode() == -10) {
                        CVSServerException e = new CVSServerException(status);
                        if (e.isNoTagException() && child.isContainer()) {
                            retry = true;
                        } else if (e.containsErrors()) {
                            throw e;
                        }
                    }
                    Object var12_14 = null;
                    session.close();
                    if (!retry) break block10;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    session.close();
                    throw throwable;
                }
                Policy.checkCanceled(progress);
                boolean bl2 = this.exists(child, null, Policy.subMonitorFor(progress, 20));
                Object var14_17 = null;
                progress.done();
                return bl2;
            }
            bl = exists[0];
            Object var14_18 = null;
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            progress.done();
            throw throwable;
        }
        progress.done();
        return bl;
    }

    public ICVSRemoteResource[] getMembers(IProgressMonitor monitor) throws TeamException {
        return this.getMembers(this.getTag(), monitor);
    }

    protected ICVSRemoteResource[] getMembers(CVSTag tag, IProgressMonitor monitor) throws CVSException {
        RemoteFolderMemberFetcher fetcher = new RemoteFolderMemberFetcher(this, tag);
        fetcher.fetchMembers(Policy.monitorFor(monitor));
        return this.children;
    }

    public ICVSResource[] members(int flags) throws CVSException {
        ArrayList<ICVSRemoteResource> result = new ArrayList<ICVSRemoteResource>();
        ICVSRemoteResource[] resources = this.getChildren();
        if (this.children == null) {
            return new ICVSResource[0];
        }
        if ((flags & 0x20) == 0 && (flags & 0x40) == 1) {
            return new ICVSResource[0];
        }
        boolean includeFiles = (flags & 1) != 0 || (flags & 3) == 0;
        boolean includeFolders = (flags & 2) != 0 || (flags & 3) == 0;
        boolean includeManaged = (flags & 0x10) != 0 || (flags & 0x1C) == 0;
        boolean includeUnmanaged = (flags & 8) != 0 || (flags & 0x1C) == 0;
        boolean includeIgnored = (flags & 4) != 0;
        int i = 0;
        while (i < resources.length) {
            ICVSRemoteResource cvsResource = resources[i];
            if (includeFiles && !cvsResource.isFolder() || includeFolders && cvsResource.isFolder()) {
                boolean isManaged = cvsResource.isManaged();
                boolean isIgnored = cvsResource.isIgnored();
                if (isManaged && includeManaged || isIgnored && includeIgnored || !isManaged && !isIgnored && includeUnmanaged) {
                    result.add(cvsResource);
                }
            }
            ++i;
        }
        return result.toArray(new ICVSResource[result.size()]);
    }

    public ICVSFolder getFolder(String name) throws CVSException {
        if (name.equals(".") || name.equals("./")) {
            return this;
        }
        ICVSResource child = this.getChild(name);
        if (child.isFolder()) {
            return (ICVSFolder)child;
        }
        throw new CVSException(4, 1000, Policy.bind("RemoteFolder.invalidChild", name, this.getName()));
    }

    public ICVSFile getFile(String name) throws CVSException {
        ICVSResource child = this.getChild(name);
        if (!child.isFolder()) {
            return (ICVSFile)child;
        }
        throw new CVSException(4, 1000, Policy.bind("RemoteFolder.invalidChild", name, this.getName()));
    }

    public Command.LocalOption[] getLocalOptions() {
        return Command.NO_LOCAL_OPTIONS;
    }

    public String getRepositoryRelativePath() {
        return this.getFolderSyncInfo().getRepository();
    }

    public String getRelativePath(ICVSFolder ancestor) throws CVSException {
        if (ancestor == this) {
            return ".";
        }
        if (this.parent == null) {
            throw new CVSException(Policy.bind("RemoteFolder.invalidChild", this.getName(), ancestor.getName()));
        }
        return super.getRelativePath(ancestor);
    }

    public ICVSRepositoryLocation getRepository() {
        return this.repository;
    }

    public boolean isExpandable() {
        return true;
    }

    public boolean isFolder() {
        return true;
    }

    public boolean childExists(String path) {
        try {
            return this.getChild(path) != null;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public ICVSResource getChild(String path) throws CVSException {
        if (path.equals(".") || path.length() == 0) {
            return this;
        }
        if (path.indexOf("/") != -1) {
            Path p = new Path(path);
            try {
                return ((RemoteFolder)this.getChild(p.segment(0))).getChild(p.removeFirstSegments(1).toString());
            }
            catch (CVSException cVSException) {
                throw new CVSException(4, 1000, Policy.bind("RemoteFolder.invalidChild", path, this.getName()));
            }
        }
        ICVSRemoteResource[] children = this.getChildren();
        if (children == null) {
            throw new CVSException(4, 1000, Policy.bind("RemoteFolder.invalidChild", path, this.getName()));
        }
        int i = 0;
        while (i < children.length) {
            if (children[i].getName().equals(path)) {
                return children[i];
            }
            ++i;
        }
        throw new CVSException(4, 1000, Policy.bind("RemoteFolder.invalidChild", path, this.getName()));
    }

    public void mkdir() throws CVSException {
        throw new CVSException(Policy.bind("RemoteResource.invalidOperation"));
    }

    public void flush(boolean deep) {
    }

    public FolderSyncInfo getFolderSyncInfo() {
        return this.folderInfo;
    }

    public String getRemoteLocation(ICVSFolder stopSearching) throws CVSException {
        if (this.folderInfo == null) {
            return Util.appendPath(this.parent.getRemoteLocation(stopSearching), this.getName());
        }
        return this.folderInfo.getRemoteLocation();
    }

    public boolean isCVSFolder() {
        return this.folderInfo != null;
    }

    public void acceptChildren(ICVSResourceVisitor visitor) throws CVSException {
        throw new CVSException(Policy.bind("RemoteResource.invalidOperation"));
    }

    public boolean isContainer() {
        return true;
    }

    public IRemoteResource[] members(IProgressMonitor progress) throws TeamException {
        return this.getMembers(progress);
    }

    public InputStream getContents(IProgressMonitor progress) throws TeamException {
        return null;
    }

    public ICVSRemoteResource[] getChildren() {
        return this.children;
    }

    protected void setChildren(ICVSRemoteResource[] children) {
        this.children = children;
    }

    public void setTag(CVSTag tag) {
        this.folderInfo = new FolderSyncInfo(this.folderInfo.getRepository(), this.folderInfo.getRoot(), tag, this.folderInfo.getIsStatic());
    }

    public CVSTag getTag() {
        if (this.folderInfo == null) {
            return null;
        }
        return this.folderInfo.getTag();
    }

    public void setFolderSyncInfo(FolderSyncInfo folderInfo) throws CVSException {
        this.folderInfo = folderInfo;
    }

    public void run(ICVSRunnable job, IProgressMonitor monitor) throws CVSException {
        job.run(monitor);
    }

    public void run(ICVSRunnable job, int flags, IProgressMonitor monitor) throws CVSException {
        job.run(monitor);
    }

    public IStatus tag(CVSTag tag, Command.LocalOption[] localOptions, IProgressMonitor monitor) throws CVSException {
        monitor = Policy.monitorFor(monitor);
        monitor.beginTask(null, 100);
        Session session = new Session(this.getRepository(), this, true);
        session.open(Policy.subMonitorFor(monitor, 10), true);
        try {
            IStatus iStatus = Command.RTAG.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions, (CVSTag)this.folderInfo.getTag(), tag, new ICVSRemoteResource[]{this}, Policy.subMonitorFor(monitor, 90));
            Object var5_6 = null;
            session.close();
            return iStatus;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            session.close();
            throw throwable;
        }
    }

    public ICVSResource[] fetchChildren(IProgressMonitor monitor) throws CVSException {
        try {
            return this.getMembers(monitor);
        }
        catch (TeamException e) {
            throw new CVSException(e.getStatus());
        }
    }

    public boolean equals(Object target) {
        if (!super.equals(target)) {
            return false;
        }
        RemoteFolder folder = (RemoteFolder)target;
        CVSTag tag1 = this.getTag();
        CVSTag tag2 = folder.getTag();
        if (tag1 == null) {
            tag1 = CVSTag.DEFAULT;
        }
        if (tag2 == null) {
            tag2 = CVSTag.DEFAULT;
        }
        return tag1.equals(tag2);
    }

    public int hashCode() {
        CVSTag tag = this.getTag();
        if (tag == null) {
            tag = CVSTag.DEFAULT;
        }
        return super.hashCode() | tag.getName().hashCode();
    }

    protected IPath getRelativePathFromRootRelativePath(ICVSFolder root, IPath path) throws CVSException {
        if (root == this) {
            return path;
        }
        Assert.isTrue(!path.isEmpty());
        return this.getRelativePathFromRootRelativePath((ICVSFolder)root.getChild(path.segment(0)), path.removeFirstSegments(1));
    }

    public ICVSRemoteResource forTag(ICVSRemoteFolder parent, CVSTag tagName) {
        return new RemoteFolder((RemoteFolder)parent, this.getName(), this.repository, this.folderInfo.getRepository(), tagName, this.folderInfo.getIsStatic());
    }

    public ICVSRemoteResource forTag(CVSTag tagName) {
        return (ICVSRemoteFolder)this.forTag(null, tagName);
    }

    public boolean isDefinedModule() {
        return false;
    }

    public ResourceSyncInfo getSyncInfo() {
        return new ResourceSyncInfo(this.getName());
    }

    public byte[] getSyncBytes() {
        try {
            return this.folderInfo.getBytes();
        }
        catch (CVSException cVSException) {
            return null;
        }
    }

    public String getComment() throws TeamException {
        return null;
    }

    public String getContentIdentifier() throws TeamException {
        return null;
    }

    public String getCreatorDisplayName() throws TeamException {
        return null;
    }

    public IStorage getBufferedStorage(IProgressMonitor monitor) throws TeamException {
        return null;
    }

    public boolean isManaged() {
        return super.isManaged() && this.isCVSFolder();
    }
}

