/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.Checkout;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Request;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSRemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFolder;
import org.eclipse.team.internal.ccvs.core.resources.FileContentCachingService;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteModule;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public class CVSWorkspaceRoot {
    private ICVSFolder localRoot;

    public CVSWorkspaceRoot(IContainer resource) {
        this.localRoot = CVSWorkspaceRoot.getCVSFolderFor(resource);
    }

    public static void checkout(ICVSRepositoryLocation repository, IProject project, String sourceModule, CVSTag tag, IProgressMonitor monitor) throws TeamException {
        if (sourceModule == null) {
            sourceModule = project.getName();
        }
        CVSWorkspaceRoot.checkout(new ICVSRemoteFolder[]{new RemoteFolder(null, repository, sourceModule, tag)}, new IProject[]{project}, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void checkout(final ICVSRemoteFolder[] resources, final IProject[] projects, IProgressMonitor monitor) throws TeamException {
        final TeamException[] eHolder = new TeamException[1];
        try {
            try {
                IWorkspaceRunnable workspaceRunnable = new IWorkspaceRunnable(){

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor pm) throws CoreException {
                        try {
                            try {
                                pm.beginTask(null, 1000 * resources.length);
                                ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
                                int i = 0;
                                while (i < resources.length) {
                                    Object var13_15;
                                    IProject project = null;
                                    RemoteFolder resource = (RemoteFolder)resources[i];
                                    if (projects != null) {
                                        project = projects[i];
                                    }
                                    String moduleName = resource instanceof RemoteModule ? ((RemoteModule)resource).getName() : resource.getRepositoryRelativePath();
                                    ICVSRepositoryLocation repository = resource.getRepository();
                                    Session session = new Session(repository, root);
                                    try {
                                        CVSTag tag;
                                        session.open(Policy.subMonitorFor(pm, 50), false);
                                        HashSet<IProject> targetProjects = new HashSet<IProject>();
                                        if (project == null) {
                                            IStatus status = Request.EXPAND_MODULES.execute(session, new String[]{moduleName}, Policy.subMonitorFor(pm, 50));
                                            if (status.getCode() == -10) {
                                                throw new CVSServerException(status);
                                            }
                                            String[] expansions = session.getModuleExpansions();
                                            int j = 0;
                                            while (j < expansions.length) {
                                                targetProjects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(new Path(expansions[j]).segment(0)));
                                                ++j;
                                            }
                                        } else {
                                            targetProjects.add(project);
                                        }
                                        root.run(new ICVSRunnable(this, targetProjects){
                                            final /* synthetic */ 1 this$1;
                                            private final /* synthetic */ Set val$targetProjects;
                                            {
                                                this.this$1 = var1_1;
                                                this.val$targetProjects = set;
                                            }

                                            public void run(IProgressMonitor monitor) throws CVSException {
                                                CVSWorkspaceRoot.scrubProjects(this.val$targetProjects.toArray(new IProject[this.val$targetProjects.size()]), monitor);
                                            }
                                        }, Policy.subMonitorFor(pm, 100));
                                        ArrayList<Command.LocalOption> localOptions = new ArrayList<Command.LocalOption>();
                                        if (project != null) {
                                            localOptions.add(Checkout.makeDirectoryNameOption(project.getName()));
                                        }
                                        if (CVSProviderPlugin.getPlugin().getPruneEmptyDirectories()) {
                                            localOptions.add(Checkout.PRUNE_EMPTY_DIRECTORIES);
                                        }
                                        if ((tag = resource.getTag()) == null) {
                                            tag = CVSTag.DEFAULT;
                                        }
                                        localOptions.add(Update.makeTagOption(tag));
                                        IStatus status = Command.CHECKOUT.execute(session, Command.NO_GLOBAL_OPTIONS, localOptions.toArray(new Command.LocalOption[localOptions.size()]), new String[]{moduleName}, null, Policy.subMonitorFor(pm, 800));
                                        if (status.getCode() == -10) {
                                            throw new CVSServerException(status);
                                        }
                                        CVSWorkspaceRoot.refreshProjects(targetProjects.toArray(new IProject[targetProjects.size()]), Policy.subMonitorFor(pm, 100));
                                    }
                                    catch (Throwable throwable) {
                                        var13_15 = null;
                                        session.close();
                                        throw throwable;
                                    }
                                    {
                                        var13_15 = null;
                                        session.close();
                                        ++i;
                                    }
                                }
                            }
                            catch (TeamException e) {
                                eHolder[0] = e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var15_18 = null;
                            pm.done();
                            throw throwable;
                        }
                        {
                            Object var15_19 = null;
                        }
                        pm.done();
                    }
                };
                ResourcesPlugin.getWorkspace().run(workspaceRunnable, monitor);
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        monitor.done();
        if (eHolder[0] != null) {
            throw eHolder[0];
        }
    }

    public static void setSharing(IProject project, FolderSyncInfo info, IProgressMonitor monitor) throws TeamException {
        ICVSFolder folder = (ICVSFolder)CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
        FolderSyncInfo folderInfo = folder.getFolderSyncInfo();
        if (!info.equals(folderInfo)) {
            throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSProvider.infoMismatch", project.getName())));
        }
        CVSProviderPlugin.getPlugin().getRepository(info.getRoot());
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] getExpansions(ICVSRemoteFolder[] resources, IProgressMonitor monitor) throws CVSException {
        IStatus status;
        if (resources.length == 0) {
            return new String[0];
        }
        ICVSFolder root = CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot());
        String[] arguments = new String[resources.length];
        int i = 0;
        while (i < resources.length) {
            arguments[i] = resources[i] instanceof RemoteModule ? ((RemoteModule)resources[i]).getName() : resources[i].getRepositoryRelativePath();
            ++i;
        }
        Session s = new Session(resources[0].getRepository(), root);
        s.open(monitor, false);
        try {
            status = Request.EXPAND_MODULES.execute(s, arguments, monitor);
            Object var6_9 = null;
            s.close();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            s.close();
            throw throwable;
        }
        if (status.getCode() == -10) {
            throw new CVSServerException(status);
        }
        return s.getModuleExpansions();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void scrubProjects(IProject[] projects, IProgressMonitor monitor) throws CVSException {
        if (projects == null) {
            monitor.done();
            return;
        }
        monitor.beginTask(Policy.bind("CVSProvider.Scrubbing_projects_1"), projects.length * 100);
        try {
            try {
                int i = 0;
                while (i < projects.length) {
                    block16: {
                        File location;
                        IProject project = projects[i];
                        if (project != null && project.exists()) {
                            Object var7_8;
                            if (!project.isOpen()) {
                                project.open(Policy.subMonitorFor(monitor, 10));
                            }
                            monitor.subTask(Policy.bind("CVSProvider.Scrubbing_local_project_1"));
                            if (RepositoryProvider.getProvider((IProject)project) != null) {
                                RepositoryProvider.unmap((IProject)project);
                            }
                            IResource[] children = project.members(2);
                            IProgressMonitor subMonitor = Policy.subMonitorFor(monitor, 80);
                            subMonitor.beginTask(null, children.length * 100);
                            try {
                                int j = 0;
                                while (j < children.length) {
                                    if (!children[j].getName().equals(".project")) {
                                        children[j].delete(true, Policy.subMonitorFor(subMonitor, 100));
                                    }
                                    ++j;
                                }
                            }
                            catch (Throwable throwable) {
                                var7_8 = null;
                                subMonitor.done();
                                throw throwable;
                            }
                            {
                                var7_8 = null;
                                subMonitor.done();
                                break block16;
                            }
                        }
                        if (project != null && (location = new File(project.getParent().getLocation().toFile(), project.getName())).exists()) {
                            CVSWorkspaceRoot.deepDelete(location);
                        }
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                throw CVSException.wrapException(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        monitor.done();
    }

    private static void deepDelete(File resource) {
        if (resource.isDirectory()) {
            File[] fileList = resource.listFiles();
            int i = 0;
            while (i < fileList.length) {
                CVSWorkspaceRoot.deepDelete(fileList[i]);
                ++i;
            }
        }
        resource.delete();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void refreshProjects(IProject[] projects, IProgressMonitor monitor) throws CoreException, TeamException {
        monitor.beginTask(Policy.bind("CVSProvider.Creating_projects_2"), projects.length * 100);
        try {
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
                CVSTeamProvider provider = (CVSTeamProvider)RepositoryProvider.getProvider((IProject)project, (String)CVSProviderPlugin.getTypeId());
                provider.setWatchEditEnabled(CVSProviderPlugin.getPlugin().isWatchEditEnabled());
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        monitor.done();
    }

    public static ICVSFolder getCVSFolderFor(IContainer resource) {
        return new EclipseFolder(resource);
    }

    public static ICVSFile getCVSFileFor(IFile resource) {
        return new EclipseFile(resource);
    }

    public static ICVSResource getCVSResourceFor(IResource resource) {
        if (resource.getType() == 1) {
            return CVSWorkspaceRoot.getCVSFileFor((IFile)resource);
        }
        return CVSWorkspaceRoot.getCVSFolderFor((IContainer)resource);
    }

    public static ICVSRemoteResource getRemoteResourceFor(IResource resource) throws CVSException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        return CVSWorkspaceRoot.getRemoteResourceFor(managed);
    }

    public static ICVSRemoteResource getRemoteResourceFor(ICVSResource resource) throws CVSException {
        if (resource.isFolder()) {
            ICVSFolder folder = (ICVSFolder)resource;
            FolderSyncInfo syncInfo = folder.getFolderSyncInfo();
            if (syncInfo != null) {
                return new RemoteFolder(null, CVSProviderPlugin.getPlugin().getRepository(syncInfo.getRoot()), syncInfo.getRepository(), syncInfo.getTag());
            }
        } else if (resource.isManaged()) {
            RemoteFolder parent = (RemoteFolder)CVSWorkspaceRoot.getRemoteResourceFor(resource.getParent());
            if (parent == null) {
                if (resource.isManaged()) {
                    CVSProviderPlugin.log((CoreException)((Object)new CVSException(Policy.bind("CVSWorkspaceRoot.11", Util.getFullestPath(resource)))));
                }
            } else {
                return RemoteFile.getBase(parent, (ICVSFile)resource);
            }
        }
        return null;
    }

    private static ICVSRemoteResource getRemoteTreeFromParent(IResource resource, ICVSResource managed, CVSTag tag, IProgressMonitor progress) throws TeamException {
        ICVSFolder parent = managed.getParent();
        FolderSyncInfo syncInfo = parent.getFolderSyncInfo();
        if (syncInfo == null) {
            return null;
        }
        ICVSRepositoryLocation location = CVSProviderPlugin.getPlugin().getRepository(parent.getFolderSyncInfo().getRoot());
        RemoteFolderTree remoteParent = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, parent, tag, progress);
        ICVSRemoteResource remote = null;
        if (remoteParent != null) {
            try {
                remote = (ICVSRemoteResource)remoteParent.getChild(resource.getName());
            }
            catch (CVSException cVSException) {
                remote = null;
            }
            if (remote != null && remote.isContainer() != managed.isFolder()) {
                throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.typesDiffer", resource.getFullPath().toString()), null));
            }
        }
        return remote;
    }

    public static IRemoteSyncElement getRemoteSyncTree(IResource resource, CVSTag tag, IProgressMonitor progress) throws TeamException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor(resource);
        ICVSRemoteResource baseTree = null;
        if (resource.getType() == 1) {
            ICVSRepositoryLocation location;
            baseTree = remote;
            if (remote == null) {
                ICVSRemoteResource parent = CVSWorkspaceRoot.getRemoteResourceFor((IResource)resource.getParent());
                if (parent == null) {
                    throw new CVSException((IStatus)new CVSStatus(4, Policy.bind("CVSTeamProvider.unmanagedParent", resource.getFullPath().toString()), null));
                }
                location = parent.getRepository();
            } else {
                location = remote.getRepository();
            }
            remote = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress);
        } else if (remote == null) {
            remote = CVSWorkspaceRoot.getRemoteTreeFromParent(resource, managed, tag, progress);
        } else {
            ICVSRepositoryLocation location = remote.getRepository();
            baseTree = RemoteFolderTreeBuilder.buildBaseTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress);
            remote = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress);
        }
        return new CVSRemoteSyncElement(true, resource, baseTree, remote);
    }

    public static IRemoteSyncElement getRemoteSyncTree(IProject project, ICVSRepositoryLocation location, String moduleName, CVSTag tag, IProgressMonitor progress) throws TeamException {
        if (CVSWorkspaceRoot.getCVSFolderFor((IContainer)project).isCVSFolder()) {
            return CVSWorkspaceRoot.getRemoteSyncTree((IResource)project, tag, progress);
        }
        progress.beginTask(null, 100);
        RemoteFolder folder = new RemoteFolder(null, location, moduleName, tag);
        RemoteFolderTree remote = RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)folder.getRepository(), folder, folder.getTag(), Policy.subMonitorFor(progress, 80));
        CVSRemoteSyncElement tree = new CVSRemoteSyncElement(true, (IResource)project, null, remote);
        tree.makeFoldersInSync(Policy.subMonitorFor(progress, 10));
        RepositoryProvider.map((IProject)project, (String)CVSProviderPlugin.getTypeId());
        progress.done();
        return tree;
    }

    public static IRemoteSyncElement getRemoteSyncTree(IProject project, IResource[] resources, CVSTag tag, IProgressMonitor progress) throws TeamException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor((IResource)project);
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor((IResource)project);
        if (remote == null) {
            return new CVSRemoteSyncElement(true, (IResource)project, null, null);
        }
        ArrayList<ICVSResource> cvsResources = new ArrayList<ICVSResource>();
        int i = 0;
        while (i < resources.length) {
            cvsResources.add(CVSWorkspaceRoot.getCVSResourceFor(resources[i]));
            ++i;
        }
        CVSRepositoryLocation location = (CVSRepositoryLocation)remote.getRepository();
        RemoteFolderTree base = RemoteFolderTreeBuilder.buildBaseTree(location, (ICVSFolder)managed, tag, progress);
        remote = RemoteFolderTreeBuilder.buildRemoteTree(location, (ICVSFolder)managed, cvsResources.toArray(new ICVSResource[cvsResources.size()]), tag, progress);
        return new CVSRemoteSyncElement(true, (IResource)project, base, remote);
    }

    public static ICVSRemoteResource getRemoteTree(IResource resource, CVSTag tag, IProgressMonitor progress) throws TeamException {
        return CVSWorkspaceRoot.getRemoteTree(resource, tag, false, progress);
    }

    public static ICVSRemoteResource getRemoteTree(IResource resource, CVSTag tag, boolean cacheFileContentsHint, IProgressMonitor progress) throws TeamException {
        ICVSResource managed = CVSWorkspaceRoot.getCVSResourceFor(resource);
        ICVSRemoteResource remote = CVSWorkspaceRoot.getRemoteResourceFor(resource);
        if (remote == null) {
            RemoteFile file;
            progress.beginTask(null, 100);
            remote = CVSWorkspaceRoot.getRemoteTreeFromParent(resource, managed, tag, Policy.subMonitorFor(progress, 50));
            if (cacheFileContentsHint && remote != null && remote instanceof RemoteFile && !(file = (RemoteFile)remote).isContentsCached()) {
                file.fetchContents(Policy.subMonitorFor(progress, 50));
            }
            progress.done();
        } else if (resource.getType() == 1) {
            ICVSRepositoryLocation location = remote.getRepository();
            remote = cacheFileContentsHint ? FileContentCachingService.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress) : RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFile)managed, tag, progress);
        } else {
            ICVSRepositoryLocation location = remote.getRepository();
            remote = cacheFileContentsHint ? FileContentCachingService.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress) : RemoteFolderTreeBuilder.buildRemoteTree((CVSRepositoryLocation)location, (ICVSFolder)managed, tag, progress);
        }
        return remote;
    }

    public static boolean hasRemote(IResource resource) {
        try {
            ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
            int type = resource.getType();
            if (type != 1) {
                if (type == 4) {
                    return ((ICVSFolder)cvsResource).isCVSFolder();
                }
                return cvsResource.isManaged();
            }
            byte[] syncBytes = ((ICVSFile)cvsResource).getSyncBytes();
            if (syncBytes != null) {
                return !ResourceSyncInfo.isAddition(syncBytes);
            }
            return false;
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    public ICVSRepositoryLocation getRemoteLocation() throws CVSException {
        FolderSyncInfo info = this.localRoot.getFolderSyncInfo();
        if (info == null) {
            throw new CVSException(Policy.bind("CVSWorkspaceRoot.notCVSFolder", this.localRoot.getName()));
        }
        return CVSProviderPlugin.getPlugin().getRepository(info.getRoot());
    }

    public ICVSFolder getLocalRoot() {
        return this.localRoot;
    }

    public static boolean isLinkedResource(IResource resource) {
        if (resource.isLinked()) {
            return true;
        }
        if (resource.getType() == 4 || resource.getType() == 8) {
            return false;
        }
        String linkedParentName = resource.getProjectRelativePath().segment(0);
        IFolder linkedParent = resource.getProject().getFolder(linkedParentName);
        return linkedParent.isLinked();
    }

    public static boolean isSharedWithCVS(IResource resource) throws CVSException {
        if (!resource.isAccessible()) {
            return false;
        }
        if (CVSWorkspaceRoot.isLinkedResource(resource)) {
            return false;
        }
        if (RepositoryProvider.getProvider((IProject)resource.getProject(), (String)CVSProviderPlugin.getTypeId()) == null) {
            return false;
        }
        ICVSResource cvsResource = CVSWorkspaceRoot.getCVSResourceFor(resource);
        if (cvsResource.isManaged()) {
            return true;
        }
        if (!cvsResource.exists()) {
            return false;
        }
        if (cvsResource.isFolder() && ((ICVSFolder)cvsResource).isCVSFolder()) {
            return true;
        }
        if (cvsResource.isIgnored()) {
            return false;
        }
        return cvsResource.getParent().isCVSFolder();
    }

    public static boolean isOrphanedSubtree(IContainer container) throws CVSException {
        ICVSFolder mFolder = CVSWorkspaceRoot.getCVSFolderFor(container);
        return mFolder.isCVSFolder() && !mFolder.isManaged() && mFolder.getIResource().getType() == 2 && !CVSWorkspaceRoot.isLinkedResource((IResource)container);
    }
}

