/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.IRemoteSyncElement;
import org.eclipse.team.core.sync.RemoteSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSResourceVisitor;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.resources.CVSLocalSyncElement;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.resources.RemoteResource;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.MutableResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Assert;

public class CVSRemoteSyncElement
extends RemoteSyncElement {
    CVSLocalSyncElement localSync;
    IRemoteResource remote;
    boolean isThreeWay = true;

    public CVSRemoteSyncElement(boolean isThreeWay, IResource local, IRemoteResource base, IRemoteResource remote) {
        this.localSync = new CVSLocalSyncElement(local, base);
        this.remote = remote;
        this.isThreeWay = isThreeWay;
    }

    public IRemoteSyncElement create(boolean isThreeWay, IResource local, IRemoteResource base, IRemoteResource remote, Object data) {
        return new CVSRemoteSyncElement(isThreeWay, local, base, remote);
    }

    public IRemoteResource getRemote() {
        return this.remote;
    }

    protected Object getData() {
        return this.localSync.getData();
    }

    public IResource getLocal() {
        return this.localSync.getLocal();
    }

    public IRemoteResource getBase() {
        return this.localSync.getBase();
    }

    public boolean isCheckedOut() {
        return this.localSync.isCheckedOut();
    }

    public boolean hasBase() {
        return this.getBase() != null;
    }

    public boolean hasRemote() {
        return this.remote != null;
    }

    public ILocalSyncElement create(IResource local, IRemoteResource base, Object data) {
        return this.localSync.create(local, base, data);
    }

    public boolean isIgnored(IResource resource) {
        return this.localSync.isIgnored(resource);
    }

    public boolean isThreeWay() {
        return this.isThreeWay;
    }

    public void makeOutgoing(IProgressMonitor monitor) throws TeamException {
        int syncKind = this.getSyncKind(1, monitor);
        boolean incoming = (syncKind & 0xC) == 8;
        boolean outgoing = (syncKind & 0xC) == 4;
        ICVSResource local = this.localSync.getCVSResource();
        RemoteResource remote = (RemoteResource)this.getRemote();
        ResourceSyncInfo origInfo = local.getSyncInfo();
        MutableResourceSyncInfo info = null;
        if (origInfo != null) {
            info = origInfo.cloneMutable();
        }
        if (outgoing) {
            return;
        }
        if (incoming) {
            if (local.exists()) {
                if (remote == null) {
                    info.setAdded();
                } else {
                    info.setRevision(remote.getSyncInfo().getRevision());
                    info.setTimeStamp(null);
                }
            } else {
                info = remote.getSyncInfo().cloneMutable();
                info.setDeleted(true);
            }
        } else if (local.exists()) {
            if (this.hasRemote()) {
                if (this.hasBase()) {
                    info.setRevision(remote.getSyncInfo().getRevision());
                } else {
                    remote.getContents(Policy.monitorFor(monitor));
                    info = remote.getSyncInfo().cloneMutable();
                }
            } else if (this.hasBase()) {
                info.setAdded();
            } else {
                Assert.isTrue(false);
            }
        } else if (this.hasRemote()) {
            info.setRevision(remote.getSyncInfo().getRevision());
            info.setDeleted(true);
        } else {
            info = null;
            return;
        }
        if (info != null) {
            info.setTag(local.getParent().getFolderSyncInfo().getTag());
        }
        ((ICVSFile)local).setSyncInfo(info, 0);
    }

    public void makeIncoming(IProgressMonitor monitor) throws TeamException {
        CVSWorkspaceRoot.getCVSResourceFor(this.getLocal()).unmanage(null);
    }

    public void makeInSync(IProgressMonitor monitor) throws TeamException {
        boolean outgoing;
        if (!this.isContainer()) {
            return;
        }
        int syncKind = this.getSyncKind(1, monitor);
        boolean bl = outgoing = (syncKind & 0xC) == 4;
        if (outgoing) {
            return;
        }
        ICVSFolder local = (ICVSFolder)this.localSync.getCVSResource();
        RemoteFolder remote = (RemoteFolder)this.getRemote();
        if (!local.getParent().isCVSFolder()) {
            return;
        }
        if (local.isManaged() && local.isCVSFolder()) {
            FolderSyncInfo remoteInfo = remote.getFolderSyncInfo();
            FolderSyncInfo localInfo = local.getFolderSyncInfo();
            if (!localInfo.getRoot().equals(remoteInfo.getRoot())) {
                throw new CVSException(Policy.bind("CVSRemoteSyncElement.rootDiffers", new Object[]{local.getName(), remoteInfo.getRoot(), localInfo.getRoot()}));
            }
            if (!localInfo.getRepository().equals(remoteInfo.getRepository())) {
                throw new CVSException(Policy.bind("CVSRemoteSyncElement.repositoryDiffers", new Object[]{local.getName(), remoteInfo.getRepository(), localInfo.getRepository()}));
            }
            return;
        }
        if (!local.exists()) {
            local.mkdir();
        }
        FolderSyncInfo remoteInfo = remote.getFolderSyncInfo();
        FolderSyncInfo localInfo = local.getParent().getFolderSyncInfo();
        local.setFolderSyncInfo(new FolderSyncInfo(remoteInfo.getRepository(), remoteInfo.getRoot(), localInfo.getTag(), false));
    }

    public void makeFoldersInSync(IProgressMonitor progress) throws TeamException {
        FolderSyncInfo remoteInfo = ((RemoteFolder)this.getRemote()).getFolderSyncInfo();
        ((ICVSFolder)this.localSync.getCVSResource()).setFolderSyncInfo(remoteInfo);
        ILocalSyncElement[] children = this.members(progress);
        int i = 0;
        while (i < children.length) {
            CVSRemoteSyncElement child = (CVSRemoteSyncElement)children[i];
            if (child.isContainer() && child.getLocal().exists() && child.getRemote() != null) {
                child.makeFoldersInSync(progress);
            }
            ++i;
        }
    }

    public int getSyncKind(int granularity, IProgressMonitor progress) {
        if (this.isContainer() && this.isThreeWay()) {
            int folderKind = 0;
            IResource local = this.getLocal();
            ICVSRemoteFolder remote = (ICVSRemoteFolder)this.getRemote();
            ICVSFolder cvsFolder = (ICVSFolder)this.localSync.getCVSResource();
            boolean isCVSFolder = false;
            try {
                isCVSFolder = cvsFolder.isCVSFolder();
            }
            catch (CVSException cVSException) {}
            if (!local.exists()) {
                if (remote != null) {
                    folderKind = isCVSFolder ? (this.containsOutgoingDeletions(cvsFolder) ? 0 : 9) : 9;
                }
            } else if (remote == null) {
                folderKind = isCVSFolder ? 10 : 5;
            } else if (!isCVSFolder) {
                folderKind = 13;
            }
            return folderKind;
        }
        int kind = super.getSyncKind(granularity, progress);
        if (this.remote != null && (kind & 0x10) == 0) {
            int type = ((RemoteResource)this.remote).getWorkspaceSyncState();
            switch (type) {
                case 6: {
                    return kind | 0x40;
                }
                case 7: {
                    return kind | 0x20;
                }
            }
        }
        kind = this.handleDeletionConflicts(kind);
        return kind;
    }

    private boolean containsOutgoingDeletions(ICVSFolder cvsFolder) {
        final boolean[] result = new boolean[1];
        try {
            cvsFolder.accept(new ICVSResourceVisitor(){

                public void visitFile(ICVSFile file) throws CVSException {
                }

                public void visitFolder(ICVSFolder folder) throws CVSException {
                    if (folder.members(1).length > 0) {
                        result[0] = true;
                    } else {
                        folder.acceptChildren(this);
                    }
                }
            });
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
        }
        return result[0];
    }

    private int handleDeletionConflicts(int kind) {
        if (kind == 30) {
            try {
                ICVSResource cvsResource = this.localSync.getCVSResource();
                if (!this.isContainer() && cvsResource.isManaged()) {
                    cvsResource.unmanage(null);
                }
                return 0;
            }
            catch (CVSException e) {
                CVSProviderPlugin.log((CoreException)((Object)e));
                return 14;
            }
        }
        return kind;
    }

    protected boolean timestampEquals(IRemoteResource e1, IRemoteResource e2) {
        if (e1.isContainer()) {
            return e2.isContainer();
        }
        return e1.equals(e2);
    }

    protected boolean timestampEquals(IResource e1, IRemoteResource e2) {
        if (e1.getType() != 1) {
            return e2.isContainer();
        }
        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)e1);
        try {
            byte[] syncBytes1 = cvsFile.getSyncBytes();
            byte[] syncBytes2 = ((ICVSRemoteFile)e2).getSyncBytes();
            if (syncBytes1 != null) {
                if (ResourceSyncInfo.isDeletion(syncBytes1) || ResourceSyncInfo.isMerge(syncBytes1) || cvsFile.isModified(null)) {
                    return false;
                }
                return ResourceSyncInfo.getRevision(syncBytes1).equals(ResourceSyncInfo.getRevision(syncBytes2));
            }
            return false;
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            return false;
        }
    }
}

