/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.sync.ILocalSyncElement;
import org.eclipse.team.core.sync.IRemoteResource;
import org.eclipse.team.core.sync.LocalSyncElement;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFile;
import org.eclipse.team.internal.ccvs.core.resources.EclipseFolder;

public class CVSLocalSyncElement
extends LocalSyncElement {
    protected IRemoteResource base;
    protected IResource local;

    public CVSLocalSyncElement(IResource local, IRemoteResource base) {
        this.local = local;
        this.base = base;
    }

    public ILocalSyncElement create(IResource local, IRemoteResource base, Object data) {
        return new CVSLocalSyncElement(local, base);
    }

    public IResource getLocal() {
        return this.local;
    }

    public IRemoteResource getBase() {
        return this.base;
    }

    public boolean isCheckedOut() {
        return this.getLocal() != null;
    }

    public boolean hasRemote() {
        return this.getLocal() != null;
    }

    protected Object getData() {
        return null;
    }

    public ICVSResource getCVSResource() {
        return this.getCVSResourceFor(this.getLocal());
    }

    public boolean isIgnored(IResource child) {
        ICVSResource cvsResource = this.getCVSResourceFor(this.getLocal());
        if (cvsResource == null || !cvsResource.isFolder()) {
            return false;
        }
        try {
            ICVSResource managedChild = ((ICVSFolder)cvsResource).getChild(child.getName());
            return managedChild.isIgnored();
        }
        catch (CVSException cVSException) {
            return false;
        }
    }

    private ICVSResource getCVSResourceFor(IResource resource) {
        if (resource.getType() != 1) {
            return new EclipseFolder((IContainer)resource);
        }
        return new EclipseFile((IFile)resource);
    }
}

